/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.core;

import javax.servlet.http.HttpServletResponse;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetSharedControllerService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/proposalDevelopment"})
public class ProposalBudgetController
extends ProposalDevelopmentControllerBase {
    @Autowired
    @Qualifier(value="proposalBudgetSharedControllerService")
    private ProposalBudgetSharedControllerService proposalBudgetSharedController;

    @RequestMapping(params={"methodToCall=addBudget"})
    public ModelAndView addBudget(@RequestParam(value="addBudgetDto.budgetName") String budgetName, @RequestParam(value="addBudgetDto.summaryBudget") Boolean summaryBudget, @RequestParam(value="addBudgetDto.modularBudget", defaultValue="false") Boolean modularBudget, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        super.save(form);
        return this.getProposalBudgetSharedController().addBudget(budgetName, summaryBudget, modularBudget, form.getDevelopmentProposal(), (UifFormBase)form);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(params={"methodToCall=copyBudget"})
    public ModelAndView copyBudget(@RequestParam(value="copyBudgetDto.budgetName") String budgetName, @RequestParam(value="copyBudgetDto.originalBudgetId") Long originalBudgetId, @RequestParam(value="copyBudgetDto.allPeriods") Boolean allPeriods, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        super.save(form);
        return this.getProposalBudgetSharedController().copyBudget(budgetName, originalBudgetId, allPeriods, form.getDevelopmentProposal(), (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=populateBudgetSummary"})
    public ModelAndView populateBudgetSummary(@RequestParam(value="budgetId") Long budgetId, @RequestParam(value="viewOnly") boolean viewOnly, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        if (!viewOnly) {
            super.save(form);
        }
        return this.getProposalBudgetSharedController().populateBudgetSummary(budgetId, form.getDevelopmentProposal().getBudgets(), form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=markBudgetVersionComplete"})
    public ModelAndView markBudgetVersionComplete(@RequestParam(value="budgetId") Long budgetId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = this.getProposalBudgetSharedController().getSelectedBudget(budgetId, form.getDevelopmentProposal().getBudgets());
        form.getDocument().refreshPessimisticLocks();
        if (this.getProposalBudgetSharedController().isBudgetLocked(budget.getBudgetVersionNumber(), form.getDocument().getPessimisticLocks(), form.getPageId()) || !this.getProposalBudgetSharedController().isAllowedToCompleteBudget(budget, form.getPageId())) {
            form.setAjaxReturnType("update-page");
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        this.getProposalBudgetSharedController().markBudgetVersionStatus(budget, "budgetStatusCompleteCode");
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=markBudgetVersionIncomplete"})
    public ModelAndView markBudgetIncomplete(@RequestParam(value="budgetId") Long budgetId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = this.getProposalBudgetSharedController().getSelectedBudget(budgetId, form.getDevelopmentProposal().getBudgets());
        form.getDocument().refreshPessimisticLocks();
        if (this.getProposalBudgetSharedController().isBudgetLocked(budget.getBudgetVersionNumber(), form.getDocument().getPessimisticLocks(), form.getPageId())) {
            form.setAjaxReturnType("update-page");
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        this.getProposalBudgetSharedController().markBudgetVersionStatus(budget, "budgetStatusIncompleteCode");
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=markForSubmission"})
    public ModelAndView markForSubmission(@RequestParam(value="budgetId") Long budgetId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        ProposalDevelopmentBudgetExt finalBudget = this.getProposalBudgetSharedController().getSelectedBudget(budgetId, form.getDevelopmentProposal().getBudgets());
        form.getProposalDevelopmentDocument().getDevelopmentProposal().setFinalBudget(finalBudget);
        return super.save(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=removeFromSubmission"})
    public ModelAndView removeFromSubmission(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        form.getProposalDevelopmentDocument().getDevelopmentProposal().setFinalBudget(null);
        return super.save(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=openBudget"})
    public ModelAndView openBudget(@RequestParam(value="budgetId") String budgetId, @RequestParam(value="viewOnly") boolean viewOnly, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        if (!viewOnly) {
            super.save(form);
        }
        return this.getProposalBudgetSharedController().openBudget(budgetId, viewOnly, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=populatePrintForms"})
    public ModelAndView populatePrintForms(@RequestParam(value="budgetId") Long budgetId, @RequestParam(value="viewOnly") boolean viewOnly, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        if (!viewOnly) {
            super.save(form);
        }
        return this.getProposalBudgetSharedController().populatePrintForms(budgetId, form.getDevelopmentProposal().getBudgets(), form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=printBudgetForms"})
    public ModelAndView printBudgetForms(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        return this.getProposalBudgetSharedController().printBudgetForms(form.getSelectedBudget(), form, response);
    }

    public ProposalBudgetSharedControllerService getProposalBudgetSharedController() {
        return this.proposalBudgetSharedController;
    }

    public void setProposalBudgetSharedController(ProposalBudgetSharedControllerService proposalBudgetSharedController) {
        this.proposalBudgetSharedController = proposalBudgetSharedController;
    }
}

