/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.notification;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.common.notification.impl.NotificationRendererBase;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.auth.perm.ProposalDevelopmentPermissionsService;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetChangedData;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.propdev.impl.docperm.ProposalUserRoles;
import org.kuali.coeus.propdev.impl.editable.ProposalChangedData;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.UserSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentNotificationRenderer")
@Scope(value="prototype")
public class ProposalDevelopmentNotificationRenderer
extends NotificationRendererBase {
    private static final long serialVersionUID = 1143944858168503090L;
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final String DELIMITER = ",";
    private DevelopmentProposal developmentProposal;
    private ProposalChangedData proposalChangedData;
    private BudgetChangedData budgetChangedData;
    private Narrative modifiedNarrative;
    private ProposalPerson proposalPerson;
    private static final String COI_URL = "coi.standalone.base.url";
    @Autowired
    @Qualifier(value="proposalDevelopmentService")
    private transient ProposalDevelopmentService proposalDevelopmentService;
    @Autowired
    @Qualifier(value="parameterService")
    private transient ParameterService parameterService;
    @Autowired
    @Qualifier(value="proposalDevelopmentPermissionsService")
    private ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    public ProposalDevelopmentNotificationRenderer() {
    }

    public ProposalDevelopmentNotificationRenderer(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        UserSession userSession;
        SimpleDateFormat dateFormatter = new SimpleDateFormat(MM_DD_YYYY);
        Map<String, String> result = super.getDefaultReplacementParameters();
        result.put("{DOCUMENT_NUMBER}", this.developmentProposal.getProposalDocument().getDocumentNumber());
        result.put("{PROPOSAL_NUMBER}", this.developmentProposal.getProposalNumber());
        result.put("{PROPOSAL_TYPE}", this.developmentProposal.getProposalType() == null ? "" : this.developmentProposal.getProposalType().getDescription());
        result.put("{PROPOSAL_TITLE}", this.developmentProposal.getTitle());
        result.put("{PRINCIPAL INVESTIGATOR}", this.developmentProposal.getPrincipalInvestigatorName());
        result.put("{SPONSOR_CODE}", this.developmentProposal.getSponsorCode());
        result.put("{SPONSOR_NAME}", this.developmentProposal.getSponsorName());
        result.put("{START_DATE}", this.developmentProposal.getRequestedStartDateInitial().toString());
        result.put("{END_DATE}", this.developmentProposal.getRequestedEndDateInitial().toString());
        result.put("{PROGRAM_ANNOUNCEMENT_NUMBER}", this.developmentProposal.getProgramAnnouncementNumber() == null ? "" : this.developmentProposal.getProgramAnnouncementNumber());
        result.put("{PROGRAM_ANNOUNCEMENT_TITLE}", this.developmentProposal.getProgramAnnouncementTitle() == null ? "" : this.developmentProposal.getProgramAnnouncementTitle());
        result.put("{CFDA_NUMBER}", this.developmentProposal.getProposalCfdas().stream().map(ProposalCfda::getCfdaNumber).collect(Collectors.joining(DELIMITER)));
        if (this.developmentProposal.getDeadlineDate() != null) {
            result.put("{DEADLINE_DATE}", dateFormatter.format(this.developmentProposal.getDeadlineDate()));
        } else {
            result.put("{DEADLINE_DATE}", "");
        }
        result.put("{PI_NAME}", this.developmentProposal.getPrincipalInvestigatorName());
        result.put("{LEAD_UNIT}", this.developmentProposal.getUnitNumber());
        result.put("{LEAD_UNIT_NAME}", this.developmentProposal.getUnit().getUnitName());
        result.put("{PRIME_SPONSOR_CODE}", this.developmentProposal.getPrimeSponsorCode());
        result.put("{PRIME_SPONSOR_NAME}", this.developmentProposal.getPrimeSponsor() != null ? this.developmentProposal.getPrimeSponsor().getSponsorName() : "");
        InstitutionalProposal instProp = this.getProposalDevelopmentService().getInstitutionalProposal(this.developmentProposal.getProposalNumber());
        result.put("{INSTITUTIONAL_PROPOSAL_NUMBER}", instProp != null ? instProp.getProposalNumber() : "");
        result.put("{INSTITUTIONAL_PROPOSAL_DOC_NBR}", instProp != null ? instProp.getInstitutionalProposalDocument().getDocumentNumber() : "");
        if (this.proposalChangedData != null) {
            result.put("{OVERRIDE_FIELD_NAME}", this.proposalChangedData.getEditableColumn().getColumnLabel());
            result.put("{OVERRIDE_FIELD_VALUE}", this.proposalChangedData.getDisplayValue());
        }
        if (this.budgetChangedData != null) {
            result.put("{OVERRIDE_FIELD_NAME}", this.budgetChangedData.getEditableColumn().getColumnLabel());
            result.put("{OVERRIDE_FIELD_VALUE}", this.budgetChangedData.getDisplayValue());
        }
        if (this.modifiedNarrative != null) {
            result.put("{NARRATIVE_MODULE_NUM}", this.modifiedNarrative.getModuleNumber().toString());
            result.put("{NARRATIVE_TYPE}", this.modifiedNarrative.getNarrativeType().getDescription());
            result.put("{NARRATIVE_MODULE_DESCRIPTION}", this.modifiedNarrative.getModuleTitle() == null ? "" : this.modifiedNarrative.getModuleTitle());
        }
        if (this.proposalPerson != null) {
            result.put("{USER_NAME}", this.proposalPerson.getUserName());
            if (this.proposalPerson.getCertificationDetails() != null) {
                result.put("{PROPOSAL_CERTIFY_USER}", this.proposalPerson.getCertificationDetails().getCertifiedPersonName());
                result.put("{PROPOSAL_CERTIFY_TIME_STAMP}", this.proposalPerson.getCertificationDetails().getCertifiedTimeStamp());
            }
            result.put("{AGGREGATOR}", this.getAggregators());
            String certificatioPage = result.get("{APP_LINK_PREFIX}") + "/kc-pd-krad/proposalDevelopment?methodToCall=viewUtility&viewId=PropDev-CertificationView&docId=" + this.developmentProposal.getProposalDocument().getDocumentNumber() + "&userName=" + this.proposalPerson.getUserName();
            result.put("{CERT_PAGE}", certificatioPage);
            String coiLink = this.getKualiConfigurationService().getPropertyValueAsString(COI_URL);
            result.put("{LINK_TO_COI}", coiLink);
        }
        if ((userSession = this.globalVariableService.getUserSession()) != null && userSession.getPerson() != null) {
            result.put("{PROPOSAL_INITIATOR_NAME}", userSession.getPerson().getFirstName() + " " + userSession.getPerson().getLastName());
        }
        return result;
    }

    private String getAggregators() {
        List<ProposalUserRoles> proposalUserRoles = this.getProposalDevelopmentPermissionsService().getPermissions(this.developmentProposal.getProposalDocument());
        return proposalUserRoles.stream().filter(proposalUserRole -> proposalUserRole.getRoleNames().contains("Aggregator Document Level")).map(ProposalUserRoles::getUsername).collect(Collectors.joining(DELIMITER));
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public ProposalDevelopmentService getProposalDevelopmentService() {
        return this.proposalDevelopmentService;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }

    public ProposalChangedData getProposalChangedData() {
        return this.proposalChangedData;
    }

    public void setProposalChangedData(ProposalChangedData proposalChangedData) {
        this.proposalChangedData = proposalChangedData;
    }

    public BudgetChangedData getBudgetChangedData() {
        return this.budgetChangedData;
    }

    public void setBudgetChangedData(BudgetChangedData budgetChangedData) {
        this.budgetChangedData = budgetChangedData;
    }

    public Narrative getModifiedNarrative() {
        return this.modifiedNarrative;
    }

    public void setModifiedNarrative(Narrative modifiedNarrative) {
        this.modifiedNarrative = modifiedNarrative;
    }

    public ProposalPerson getProposalPerson() {
        return this.proposalPerson;
    }

    public void setProposalPerson(ProposalPerson proposalPerson) {
        this.proposalPerson = proposalPerson;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ProposalDevelopmentPermissionsService getProposalDevelopmentPermissionsService() {
        return this.proposalDevelopmentPermissionsService;
    }

    public void setProposalDevelopmentPermissionsService(ProposalDevelopmentPermissionsService proposalDevelopmentPermissionsService) {
        this.proposalDevelopmentPermissionsService = proposalDevelopmentPermissionsService;
    }
}

