/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.calculator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.rate.BudgetLaRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.impl.calculator.AbstractBudgetCalculator;
import org.kuali.coeus.common.budget.impl.calculator.Boundary;
import org.kuali.coeus.common.budget.impl.calculator.BreakUpInterval;
import org.kuali.coeus.common.budget.impl.calculator.RateAndCost;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class LineItemCalculator
extends AbstractBudgetCalculator {
    private Budget budget;
    private BudgetLineItem bli;
    private DateTimeService dateTimeService;
    private BudgetCalculationService budgetCalculationService;

    public LineItemCalculator(Budget budget, BudgetLineItem bli) {
        super(budget, bli);
        this.bli = bli;
        this.budget = budget;
        this.dateTimeService = this.getDateTimeService();
        this.budgetCalculationService = KcServiceLocator.getService(BudgetCalculationService.class);
    }

    private Map<String, Boolean> saveApplyRateFlagsForReset() {
        HashMap<String, Boolean> applyRateFlags = new HashMap<String, Boolean>();
        if (this.bli != null && CollectionUtils.isNotEmpty(this.bli.getBudgetLineItemCalculatedAmounts())) {
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : this.bli.getBudgetLineItemCalculatedAmounts()) {
                applyRateFlags.put(budgetLineItemCalculatedAmount.getRateClassCode() + budgetLineItemCalculatedAmount.getRateTypeCode(), budgetLineItemCalculatedAmount.getApplyRateFlag());
            }
        }
        return applyRateFlags;
    }

    @Override
    public void populateCalculatedAmountLineItems() {
        if (this.bli.getBudgetLineItemCalculatedAmounts().size() <= 0) {
            this.setCalculatedAmounts(this.bli);
        }
        if (this.performSync()) {
            Long versionNumber = null;
            if (CollectionUtils.isNotEmpty(this.bli.getBudgetLineItemCalculatedAmounts())) {
                versionNumber = this.bli.getBudgetLineItemCalculatedAmounts().get(0).getVersionNumber();
            }
            Map<String, Boolean> applyRateFlags = this.saveApplyRateFlagsForReset();
            this.setCalculatedAmounts(this.bli);
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : this.bli.getBudgetLineItemCalculatedAmounts()) {
                if (versionNumber != null) {
                    budgetLineItemCalculatedAmount.setVersionNumber(versionNumber);
                }
                if (applyRateFlags == null || applyRateFlags.get(budgetLineItemCalculatedAmount.getRateClassCode() + budgetLineItemCalculatedAmount.getRateTypeCode()) == null) continue;
                budgetLineItemCalculatedAmount.setApplyRateFlag(applyRateFlags.get(budgetLineItemCalculatedAmount.getRateClassCode() + budgetLineItemCalculatedAmount.getRateTypeCode()));
            }
        }
    }

    protected boolean performSync() {
        return this.getBudgetRateService().performSyncFlag(this.budget);
    }

    protected BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    @Override
    public void populateApplicableCosts(Boundary boundary) {
        int totalNumOfDays = this.dateTimeService.dateDiff((java.util.Date)this.bli.getStartDate(), (java.util.Date)this.bli.getEndDate(), true);
        int boundaryNumOfDays = boundary.getNumberOfDays();
        List<BudgetPersonnelDetails> personnelDetailsList = this.bli.getBudgetPersonnelDetailsList();
        ScaleTwoDecimal salaryRequested = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal costSharingRequested = ScaleTwoDecimal.ZERO;
        if (!personnelDetailsList.isEmpty()) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : personnelDetailsList) {
                this.getBudgetCalculationService().calculateBudgetLineItem(this.budget, budgetPersonnelDetails);
                salaryRequested = (ScaleTwoDecimal)salaryRequested.add((AbstractDecimal)budgetPersonnelDetails.getSalaryRequested());
                costSharingRequested = (ScaleTwoDecimal)costSharingRequested.add((AbstractDecimal)budgetPersonnelDetails.getCostSharingAmount());
            }
            this.bli.setLineItemCost(salaryRequested);
            this.bli.setCostSharingAmount(costSharingRequested);
        } else {
            ScaleTwoDecimal lineItemCost = this.bli.getLineItemCost();
            ScaleTwoDecimal lineItemCostSharing = this.bli.getCostSharingAmount();
            boundary.setApplicableCost(lineItemCost == null ? ScaleTwoDecimal.ZERO : new ScaleTwoDecimal(lineItemCost.bigDecimalValue().multiply(new BigDecimal(boundaryNumOfDays)).divide(new BigDecimal(totalNumOfDays), 2, RoundingMode.HALF_UP)));
            boundary.setApplicableCostSharing(lineItemCostSharing == null ? ScaleTwoDecimal.ZERO : new ScaleTwoDecimal(lineItemCostSharing.bigDecimalValue().multiply(new BigDecimal(boundaryNumOfDays)).divide(new BigDecimal(totalNumOfDays), 2, RoundingMode.HALF_UP)));
        }
    }

    @Override
    protected void addCalculatedAmount(AbstractBudgetCalculatedAmount budgetCalculatedAmount) {
        BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount = (BudgetLineItemCalculatedAmount)budgetCalculatedAmount;
        budgetLineItemCalculatedAmount.setBudgetLineItem(this.bli);
        this.bli.getBudgetLineItemCalculatedAmounts().add(budgetLineItemCalculatedAmount);
    }

    @Override
    protected void populateBudgetRateBaseList() {
        List<BudgetRateAndBase> budgetRateAndBaseList = this.bli.getBudgetRateAndBaseList();
        List<BreakUpInterval> breakupIntervals = this.getBreakupIntervals();
        if (!budgetRateAndBaseList.isEmpty()) {
            budgetRateAndBaseList.clear();
        }
        Integer rateNumber = 0;
        for (BreakUpInterval breakUpInterval : breakupIntervals) {
            QueryList<RateAndCost> vecAmountBean = breakUpInterval.getRateAndCosts();
            for (RateAndCost rateAndCost : vecAmountBean) {
                BudgetRateAndBase budgetRateBase = new BudgetRateAndBase();
                ScaleTwoDecimal appliedRate = rateAndCost.getAppliedRate();
                budgetRateBase.setAppliedRate(ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)appliedRate));
                ScaleTwoDecimal calculatedCost = rateAndCost.getCalculatedCost();
                ScaleTwoDecimal calculatedCostSharing = rateAndCost.getCalculatedCostSharing();
                budgetRateBase.setBaseCostSharing(rateAndCost.getBaseCostSharingAmount());
                budgetRateBase.setBaseCost(rateAndCost.getBaseAmount());
                budgetRateBase.setBudgetPeriod(this.bli.getBudgetPeriod());
                budgetRateBase.setCalculatedCost(calculatedCost);
                budgetRateBase.setCalculatedCostSharing(calculatedCostSharing);
                java.util.Date endDate = breakUpInterval.getBoundary().getEndDate();
                budgetRateBase.setEndDate(new Date(endDate.getTime()));
                budgetRateBase.setLineItemNumber(this.bli.getLineItemNumber());
                budgetRateBase.setOnOffCampusFlag(this.bli.getOnOffCampusFlag());
                budgetRateBase.setBudgetId(this.bli.getBudgetId());
                budgetRateBase.setRateClassCode(rateAndCost.getRateClassCode());
                rateNumber = rateNumber + 1;
                budgetRateBase.setRateNumber(rateNumber);
                budgetRateBase.setRateTypeCode(rateAndCost.getRateTypeCode());
                java.util.Date startDate = breakUpInterval.getBoundary().getStartDate();
                budgetRateBase.setStartDate(new Date(startDate.getTime()));
                budgetRateBase.setBudgetPeriodId(this.bli.getBudgetPeriodId());
                budgetRateBase.setBudgetLineItem(this.bli);
                budgetRateAndBaseList.add(budgetRateBase);
            }
        }
    }

    @Override
    protected AbstractBudgetCalculatedAmount getNewCalculatedAmountInstance() {
        return this.bli.getNewBudgetLineItemCalculatedAmount();
    }

    @Override
    protected List<BudgetRate> getBudgetRates() {
        if (StringUtils.isNotEmpty((CharSequence)this.bli.getHierarchyProposalNumber())) {
            return this.bli.getHierarchyProposal().getHierarchySummaryBudget().getBudgetRates();
        }
        return this.budget.getBudgetRates();
    }

    @Override
    protected List<BudgetLaRate> getBudgetLaRates() {
        if (StringUtils.isNotEmpty((CharSequence)this.bli.getHierarchyProposalNumber())) {
            return this.bli.getHierarchyProposal().getHierarchySummaryBudget().getBudgetLaRates();
        }
        return this.budget.getBudgetLaRates();
    }
}

