/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.view.wizard.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.person.PersonTypeConstants;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.view.wizard.framework.WizardControllerService;
import org.kuali.coeus.common.view.wizard.framework.WizardResultsDto;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.PredicateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleBoLite;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.metadata.MetadataCommon;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="wizardControllerService")
public class WizardControllerServiceImpl
implements WizardControllerService {
    private static final Collection<String> PEOPLE_CRITERIA = Arrays.asList("lastName", "firstName", "principalName", "emailAddress", "phoneNumber", "primaryDepartmentCode", "campusCode", "active");
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="roleService")
    private RoleService roleService;
    @Autowired
    @Qualifier(value="personService")
    private PersonService personService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public List<Object> performWizardSearch(Map<String, String> searchCriteria, String lineType) {
        if (StringUtils.equals((CharSequence)lineType, (CharSequence)PersonTypeConstants.EMPLOYEE.getCode())) {
            return this.preparePersonResults(searchCriteria);
        }
        if (StringUtils.equals((CharSequence)lineType, (CharSequence)PersonTypeConstants.NONEMPLOYEE.getCode())) {
            return this.prepareRolodexResults(searchCriteria);
        }
        return this.prepareRoleResults(searchCriteria);
    }

    protected List<Object> preparePersonResults(Map<String, String> searchCriteria) {
        ArrayList<Object> results = new ArrayList<Object>();
        this.getKcPersonService().modifyFieldValues(searchCriteria);
        searchCriteria.put("active", "Y");
        searchCriteria.remove("officePhone");
        List persons = this.getPersonService().findPeople(this.filterCriteria(searchCriteria, PEOPLE_CRITERIA), false);
        searchCriteria.put("officePhone", searchCriteria.get("phoneNumber"));
        searchCriteria.remove("phoneNumber");
        List<KcPerson> kcPersons = this.getKcPersonService().createKcPersonsFromPeople(persons);
        for (KcPerson person : kcPersons) {
            WizardResultsDto result = new WizardResultsDto();
            result.setKcPerson(person);
            results.add(result);
        }
        return results;
    }

    protected List<Object> prepareRolodexResults(Map<String, String> searchCriteria) {
        ArrayList<Object> results = new ArrayList<Object>();
        searchCriteria.put("active", "Y");
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        Set<String> attrs = this.getDataObjectService().getMetadataRepository().getMetadata(Rolodex.class).getAttributes().stream().map(MetadataCommon::getName).collect(Collectors.toSet());
        builder.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.isNotNull((String)"firstName"), PredicateFactory.isNotNull((String)"lastName")}), PredicateUtils.convertMapToPredicate(this.filterCriteria(searchCriteria, attrs))});
        builder.setMaxResults(Integer.valueOf(Integer.parseInt(this.getParameterService().getParameterValueAsString("KR-KRAD", "Lookup", "RESULTS_LIMIT"))));
        builder.setOrderByFields(new OrderByField[]{OrderByField.Builder.create((String)"lastName", (OrderDirection)OrderDirection.ASCENDING).build()});
        List rolodexes = this.getDataObjectService().findMatching(Rolodex.class, builder.build()).getResults();
        for (Rolodex rolodex : rolodexes) {
            WizardResultsDto result = new WizardResultsDto();
            result.setRolodex(rolodex);
            results.add(result);
        }
        return results;
    }

    protected List<Object> prepareRoleResults(Map<String, String> searchCriteria) {
        ArrayList<Object> results = new ArrayList<Object>();
        searchCriteria.put("active", "Y");
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        Set<String> attrs = this.getDataObjectService().getMetadataRepository().getMetadata(RoleBoLite.class).getAttributes().stream().map(MetadataCommon::getName).collect(Collectors.toSet());
        builder.setPredicates(new Predicate[]{PredicateUtils.convertMapToPredicate(this.filterCriteria(searchCriteria, attrs))});
        builder.setMaxResults(Integer.valueOf(Integer.parseInt(this.getParameterService().getParameterValueAsString("KR-KRAD", "Lookup", "RESULTS_LIMIT"))));
        List roles = this.getRoleService().findRoles(builder.build()).getResults();
        for (Role role : roles) {
            WizardResultsDto result = new WizardResultsDto();
            result.setRole(RoleBo.from((Role)role));
            results.add(result);
        }
        return results;
    }

    private Map<String, String> filterCriteria(Map<String, String> lookupCriteria, Collection<String> validAttributes) {
        HashMap<String, String> filteredCriteria = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : lookupCriteria.entrySet()) {
            if (!StringUtils.isNotEmpty((CharSequence)entry.getValue()) || !validAttributes.contains(entry.getKey())) continue;
            filteredCriteria.put(entry.getKey(), entry.getValue());
        }
        return filteredCriteria;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

