/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.proposallog.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogType;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogUtils;
import org.kuali.kra.institutionalproposal.proposallog.service.ProposalLogService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProposalLogServiceImpl
implements ProposalLogService {
    private BusinessObjectService businessObjectService;

    @Override
    public void mergeProposalLog(ProposalLog permanentProposalLog, String temporaryProposalNumber) {
        ProposalLog tempProposalLog = (ProposalLog)this.getBusinessObjectService().findBySinglePrimaryKey(ProposalLog.class, (Object)temporaryProposalNumber);
        if (tempProposalLog == null) {
            throw new IllegalArgumentException("Can't update proposal log status; proposal number " + temporaryProposalNumber + " not found.");
        }
        tempProposalLog.setMergedWith(permanentProposalLog.getProposalNumber());
        tempProposalLog.setLogStatus(ProposalLogUtils.getProposalLogMergedStatusCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)tempProposalLog);
    }

    @Override
    public void mergeProposalLog(String proposalNumber) {
        this.updateProposalLogStatus(proposalNumber, ProposalLogUtils.getProposalLogMergedStatusCode());
    }

    @Override
    public void promoteProposalLog(String proposalNumber) {
        this.updateProposalLogStatus(proposalNumber, ProposalLogUtils.getProposalLogSubmittedStatusCode());
    }

    protected void updateProposalLogStatus(String proposalNumber, String logStatus) {
        if (proposalNumber == null || proposalNumber.length() == 0) {
            throw new IllegalArgumentException("Can't update proposal log status; proposal number is null or empty!.");
        }
        ProposalLog proposalLog = (ProposalLog)this.getBusinessObjectService().findBySinglePrimaryKey(ProposalLog.class, (Object)proposalNumber);
        if (proposalLog == null) {
            throw new IllegalArgumentException("Can't update proposal log status; proposal number " + proposalNumber + " not found.");
        }
        proposalLog.setLogStatus(logStatus);
        this.getBusinessObjectService().save((PersistableBusinessObject)proposalLog);
    }

    @Override
    public void updateMergedInstProposal(Long proposalId, String proposalNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("proposalNumber", proposalNumber);
        ProposalLog proposalLog = (ProposalLog)this.getBusinessObjectService().findByPrimaryKey(ProposalLog.class, criteria);
        if (proposalLog != null) {
            proposalLog.setInstProposalNumber(proposalId.toString());
            this.getBusinessObjectService().save((PersistableBusinessObject)proposalLog);
        }
    }

    @Override
    public List<ProposalLog> getMatchingTemporaryProposalLogs(String proposalLogTypeCode, String piId, String rolodexId) {
        List<ProposalLog> matchedLogs = new ArrayList<ProposalLog>();
        if ((StringUtils.isNotBlank((CharSequence)piId) || StringUtils.isNotBlank((CharSequence)rolodexId)) && StringUtils.equals((CharSequence)proposalLogTypeCode, (CharSequence)ProposalLogUtils.getProposalLogPermanentTypeCode())) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)piId)) {
                criteria.put("piId", piId);
            } else if (StringUtils.isNotBlank((CharSequence)rolodexId)) {
                criteria.put("rolodexId", rolodexId);
            }
            criteria.put("proposalLogTypeCode", ProposalLogUtils.getProposalLogTemporaryTypeCode());
            matchedLogs = (List)this.getBusinessObjectService().findMatching(ProposalLog.class, criteria);
            this.purgeAlreadyMergedLogs(matchedLogs);
        }
        return matchedLogs;
    }

    @Override
    public ProposalLogType getProposalLogTypeFromDescription(String description) {
        return this.getBusinessObjectService().findMatching(ProposalLogType.class, Collections.singletonMap("description", description)).stream().findFirst().orElse(null);
    }

    private void purgeAlreadyMergedLogs(Collection<ProposalLog> pLogs) {
        Iterator<ProposalLog> iter = pLogs.iterator();
        while (iter.hasNext()) {
            ProposalLog pLog = iter.next();
            if (!pLog.getLogStatus().equals(ProposalLogUtils.getProposalLogMergedStatusCode())) continue;
            iter.remove();
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }
}

