/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.perm.DocumentLevelPermissionable;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationActivityAttachment;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.krad.util.ObjectUtils;

@ParameterConstants.NAMESPACE(namespace="KC-NEGOTIATION")
@ParameterConstants.COMPONENT(component="Document")
public class NegotiationDocument
extends KcTransactionalDocumentBase
implements Serializable,
DocumentLevelPermissionable {
    private static final long serialVersionUID = 2635757819118105L;
    public static final String DOCUMENT_TYPE_CODE = "NGT";
    private List<Negotiation> negotiationList = new ArrayList<Negotiation>();
    private String docStatusCode;

    public NegotiationDocument() {
        this.negotiationList.add(new Negotiation());
    }

    public NegotiationDocument newInstance() {
        return new NegotiationDocument();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public Negotiation getNegotiation() {
        if (this.getNegotiationList().isEmpty()) {
            this.getNegotiationList().add(new Negotiation());
        }
        return this.getNegotiationList().get(0);
    }

    public String getDocStatusCode() {
        return this.docStatusCode;
    }

    public void setDocStatusCode(String docStatusCode) {
        this.docStatusCode = docStatusCode;
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public void prepareForSave() {
        String routeStatusCode;
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
        if (StringUtils.isNotBlank((CharSequence)(routeStatusCode = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) && routeStatusCode.equals("I")) {
            this.setDocStatusCode("S");
        } else {
            this.setDocStatusCode(routeStatusCode);
        }
    }

    @Override
    public boolean isProcessComplete() {
        String docRouteStatus;
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && "F".equals(docRouteStatus = this.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) {
            isComplete = true;
        }
        return isComplete;
    }

    public void doActionTaken(ActionTakenEvent event) {
        this.afterWorkflowEngineProcess(true);
    }

    @Override
    public void afterWorkflowEngineProcess(boolean success) {
        if (CollectionUtils.isNotEmpty(this.getNegotiationList())) {
            this.getNegotiationList().get(0);
        }
        super.afterWorkflowEngineProcess(success);
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.negotiationList);
        managedLists.add(this.getNegotiation().getActivities());
        ArrayList<NegotiationActivityAttachment> attachments = new ArrayList<NegotiationActivityAttachment>();
        for (NegotiationActivity activity : this.getNegotiation().getActivities()) {
            attachments.addAll(activity.getAttachments());
        }
        managedLists.add(attachments);
        return managedLists;
    }

    public List<Negotiation> getNegotiationList() {
        return this.negotiationList;
    }

    public void setNegotiationList(List<Negotiation> negotiationList) {
        this.negotiationList = negotiationList;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getNegotiation().getNegotiationCustomDataList();
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getNegotiation().getNegotiationId().toString();
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getNegotiation().getDocumentNumberForPermission();
    }

    @Override
    public String getDocumentKey() {
        return this.getNegotiation().getDocumentKey();
    }

    @Override
    public List<String> getRoleNames() {
        return this.getNegotiation().getRoleNames();
    }

    @Override
    public String getNamespace() {
        return this.getNegotiation().getNamespace();
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getNegotiation().getLeadUnitNumber();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return this.getNegotiation().getDocumentRoleTypeCode();
    }
}

