/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.interceptor;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;

final class AuditMapSorter {
    public static final Map<String, Comparator<AuditError>> DEFAULT_PATTERN_COMPARATOR_MAP;
    private final Map<String, AuditCluster> auditErrorsMap;

    public AuditMapSorter(Map<String, AuditCluster> auditErrorsMap) {
        if (auditErrorsMap == null) {
            throw new NullPointerException("the auditErrorsMap is null");
        }
        this.auditErrorsMap = auditErrorsMap;
    }

    public void sort(Map<String, Comparator<AuditError>> patternComparatorMap) {
        if (patternComparatorMap == null) {
            throw new NullPointerException("the comparatorsForAuditErrors is null");
        }
        if (patternComparatorMap.isEmpty()) {
            throw new IllegalArgumentException("no comparator entries provided");
        }
        for (Map.Entry<String, AuditCluster> entryError : this.auditErrorsMap.entrySet()) {
            AuditCluster cluster = entryError.getValue();
            for (Map.Entry<String, Comparator<AuditError>> compEntry : patternComparatorMap.entrySet()) {
                if (!entryError.getKey().matches(compEntry.getKey())) continue;
                List errors = cluster.getAuditErrorList();
                Comparator<AuditError> comp = this.getComparator(compEntry.getValue());
                Collections.sort(errors, comp);
            }
        }
    }

    private Comparator<AuditError> getComparator(Comparator<AuditError> comp) {
        if (comp == null) {
            throw new NullPointerException("the comparator was null");
        }
        return comp;
    }

    static {
        LinkedHashMap<String, Comparator<AuditError>> tempComparators = new LinkedHashMap<String, Comparator<AuditError>>();
        tempComparators.put(".*ynq.*", YNQuestionByNumber.Q_NUM_ZERO_POSITION);
        DEFAULT_PATTERN_COMPARATOR_MAP = Collections.unmodifiableMap(tempComparators);
    }

    private static final class YNQuestionByNumber
    implements Comparator<AuditError>,
    Serializable {
        public static final Comparator<AuditError> Q_NUM_ZERO_POSITION = new YNQuestionByNumber(0);
        private static final long serialVersionUID = 7978642168434892454L;
        private final int questionNumberParamPosition;

        public YNQuestionByNumber(int questionNumberParamPosition) {
            if (questionNumberParamPosition < 0) {
                throw new IllegalArgumentException(questionNumberParamPosition + " is < 0");
            }
            this.questionNumberParamPosition = questionNumberParamPosition;
        }

        @Override
        public int compare(AuditError o1, AuditError o2) {
            if (o1 == null) {
                throw new NullPointerException("o1 is null");
            }
            if (o2 == null) {
                throw new NullPointerException("o2 is null");
            }
            String qNumber1 = this.getQuestonNumber(o1.getParams());
            String qNumber2 = this.getQuestonNumber(o2.getParams());
            if (!NumberUtils.isNumber((String)qNumber1)) {
                return -1;
            }
            if (!NumberUtils.isNumber((String)qNumber2)) {
                return 1;
            }
            return Integer.valueOf(qNumber1).compareTo(Integer.valueOf(qNumber2));
        }

        private String getQuestonNumber(String[] array) {
            if (ArrayUtils.getLength((Object)array) > this.questionNumberParamPosition) {
                return array[this.questionNumberParamPosition];
            }
            return null;
        }
    }
}

