/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.person;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.PropAwardPersonRole;
import org.kuali.coeus.common.framework.person.PropAwardPersonRoleService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.view.ViewModel;

public abstract class PropAwardPersonRoleValuesFinder
extends UifKeyValuesFinderBase {
    private PropAwardPersonRoleService propAwardPersonRoleService;

    public PropAwardPersonRoleValuesFinder() {
        this.setAddBlankOption(false);
    }

    protected abstract String getSponsorCodeFromModel(ViewModel var1);

    public List<KeyValue> getKeyValues(ViewModel model, InputField field) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.addAll(this.getKeyValues(this.getSponsorCodeFromModel(model)));
        if (this.piAlreadyExists(model, field)) {
            for (KeyValue keyValue : this.getKeyValues(this.getSponsorCodeFromModel(model))) {
                if (!keyValue.getKey().equals("PI")) continue;
                keyValues.remove(keyValue);
            }
        }
        return keyValues;
    }

    public List<KeyValue> getKeyValues(String sponsorCode) {
        ArrayList<PropAwardPersonRole> roles = new ArrayList<PropAwardPersonRole>();
        roles.addAll(this.getPropAwardPersonRoleService().getRolesByHierarchy(sponsorCode));
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        this.addKeyValue(keyValues, roles, "PI");
        this.addKeyValue(keyValues, roles, "MPI");
        this.addKeyValue(keyValues, roles, "COI");
        this.addKeyValue(keyValues, roles, "KP");
        for (PropAwardPersonRole role : roles) {
            this.addKeyValue(keyValues, role);
        }
        return keyValues;
    }

    protected void addKeyValue(List<KeyValue> keyValues, Collection<PropAwardPersonRole> roles, String roleId) {
        PropAwardPersonRole curRole = this.getRoleById(roles, roleId);
        if (curRole != null) {
            this.addKeyValue(keyValues, curRole);
            roles.remove(curRole);
        }
    }

    protected void addKeyValue(List<KeyValue> keyValues, PropAwardPersonRole role) {
        if (role != null) {
            keyValues.add((KeyValue)new ConcreteKeyValue(role.getCode(), role.getDescription()));
        }
    }

    protected PropAwardPersonRole getRoleById(Collection<PropAwardPersonRole> roles, String roleId) {
        for (PropAwardPersonRole role : roles) {
            if (!StringUtils.equals((CharSequence)role.getCode(), (CharSequence)roleId)) continue;
            return role;
        }
        return null;
    }

    protected PropAwardPersonRoleService getPropAwardPersonRoleService() {
        if (this.propAwardPersonRoleService == null) {
            this.propAwardPersonRoleService = KcServiceLocator.getService(PropAwardPersonRoleService.class);
        }
        return this.propAwardPersonRoleService;
    }

    protected abstract boolean piAlreadyExists(ViewModel var1, InputField var2);

    public void setPropAwardPersonRoleService(PropAwardPersonRoleService propAwardPersonRoleService) {
        this.propAwardPersonRoleService = propAwardPersonRoleService;
    }
}

