/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.custom.attr;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="customAttributeDocumentLookupableHelperService")
@Scope(value="prototype")
public class CustomAttributeLookupHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    @Autowired
    @Qualifier(value="customAttributeService")
    public transient CustomAttributeService customAttributeService;
    private static final String EQUAL_CHAR = "=";

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        List searchResults = super.getSearchResults(fieldValues);
        Map<String, String> documentTypes = this.getCustomAttributeService().getDocumentTypeMap();
        for (CustomAttributeDocument customAttributeDocument : searchResults) {
            customAttributeDocument.setDocumentTypeName(documentTypes.get(customAttributeDocument.getDocumentTypeName()));
        }
        return searchResults;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        Map<String, String> documentTypes = this.getCustomAttributeService().getReverseDocumentTypeMap();
        for (HtmlData htmlData : htmlDataList) {
            String formatedDocType;
            String docType;
            if (!StringUtils.isNotBlank((CharSequence)((HtmlData.AnchorHtmlData)htmlData).getHref()) || !StringUtils.isNotBlank((CharSequence)(docType = StringUtils.substringBetween((String)((HtmlData.AnchorHtmlData)htmlData).getHref(), (String)"documentTypeName=", (String)"&"))) || !documentTypes.containsKey(formatedDocType = StringUtils.replace((String)docType.toString(), (String)" ", (String)"+"))) continue;
            ((HtmlData.AnchorHtmlData)htmlData).setHref(((HtmlData.AnchorHtmlData)htmlData).getHref().replace(docType, documentTypes.get(formatedDocType)));
        }
        return htmlDataList;
    }

    public CustomAttributeService getCustomAttributeService() {
        return this.customAttributeService;
    }

    public void setCustomAttributeService(CustomAttributeService customAttributeService) {
        this.customAttributeService = customAttributeService;
    }
}

