/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.krms;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.krms.KcKrmsCacheManager;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.krms.api.engine.Engine;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.ResultEvent;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.repository.RuleRepositoryService;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.framework.engine.BasicRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="krmsRulesExecutionService")
public class KrmsRulesExecutionServiceImpl
implements KrmsRulesExecutionService {
    protected final Logger LOG = LogManager.getLogger(KrmsRulesExecutionServiceImpl.class);
    @Autowired
    @Qualifier(value="kcKrmsCacheManager")
    private KcKrmsCacheManager kcKrmsCacheManager;
    @Autowired
    @Qualifier(value="ruleRepositoryService")
    private RuleRepositoryService ruleRepositoryService;
    @Autowired
    @Qualifier(value="rice.krms.engine")
    private Engine engine;

    @Override
    public List<String> processUnitValidations(String unitNumber, KrmsRulesContext rulesContext) {
        this.kcKrmsCacheManager.clearCache();
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        rulesContext.populateContextQualifiers(contextQualifiers);
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Unit Number", unitNumber));
        Facts.Builder factsBuilder = Facts.Builder.create();
        rulesContext.addFacts(factsBuilder);
        if (this.engine == null) {
            this.LOG.error("Could not resolve KRMS Rules Engine - Unit Validations will not be evaluated!");
        } else {
            EngineResults results = this.engine.execute(selectionCriteria, factsBuilder.build(), null);
            if (results != null) {
                String errors = (String)results.getAttribute("validations");
                if (errors != null) {
                    String[] errorArray = StringUtils.split((String)errors, (String)",");
                    return Arrays.asList(errorArray);
                }
            } else {
                this.LOG.warn("Results returned from KRMS Rules Engine was null.");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, String>> processUnitKcValidations(String unitNumber, KrmsRulesContext rulesContext) {
        this.kcKrmsCacheManager.clearCache();
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        rulesContext.populateContextQualifiers(contextQualifiers);
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Unit Number", unitNumber));
        Facts.Builder factsBuilder = Facts.Builder.create();
        rulesContext.addFacts(factsBuilder);
        if (this.engine == null) {
            this.LOG.error("Could not resolve KRMS Rules Engine - Unit Validations will not be evaluated!");
        } else {
            EngineResults results = this.engine.execute(selectionCriteria, factsBuilder.build(), null);
            if (results != null) {
                List errors = (List)results.getAttribute("kcValidations");
                if (errors != null) {
                    return errors;
                }
            } else {
                this.LOG.warn("Results returned from KRMS Rules Engine was null.");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Boolean> runApplicableRules(List<String> ruleIds, KrmsRulesContext rulesContext, String agendaTypeId) {
        HashMap<String, Boolean> ruleResults = new HashMap<String, Boolean>();
        if (rulesContext != null) {
            String namespace = rulesContext.getClass().getAnnotation(ParameterConstants.NAMESPACE.class).namespace();
            HashMap<String, String> contextQualifiers = new HashMap<String, String>();
            rulesContext.populateContextQualifiers(contextQualifiers);
            HashMap<String, String> agendaQualifiers = new HashMap<String, String>();
            rulesContext.populateAgendaQualifiers(agendaQualifiers);
            agendaQualifiers.put("typeId", agendaTypeId);
            contextQualifiers.put("namespaceCode", namespace);
            SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, agendaQualifiers);
            Facts.Builder factsBuilder = Facts.Builder.create();
            rulesContext.addFacts(factsBuilder);
            ExecutionOptions xOptions = new ExecutionOptions();
            xOptions.setFlag(ExecutionFlag.LOG_EXECUTION, true);
            EngineResults results = this.engine.execute(selectionCriteria, factsBuilder.build(), xOptions);
            List ruleDefinitions = this.ruleRepositoryService.getRules(ruleIds);
            HashMap<String, RuleDefinition> ruleMap = new HashMap<String, RuleDefinition>();
            for (RuleDefinition rule : ruleDefinitions) {
                if (!rule.isActive()) continue;
                ruleMap.put(rule.getName(), rule);
            }
            if (results.getResultsOfType("Rule Evaluated") != null && results.getResultsOfType("Rule Evaluated").size() > 0) {
                for (ResultEvent resultEvent : results.getResultsOfType("Rule Evaluated")) {
                    String ruleName = ((BasicRule)resultEvent.getSource()).getName();
                    if (!ruleMap.containsKey(ruleName)) continue;
                    ruleResults.put(((RuleDefinition)ruleMap.get(ruleName)).getId(), resultEvent.getResult());
                }
            }
        }
        return ruleResults;
    }

    public KcKrmsCacheManager getKcKrmsCacheManager() {
        return this.kcKrmsCacheManager;
    }

    public void setKcKrmsCacheManager(KcKrmsCacheManager kcKrmsCacheManager) {
        this.kcKrmsCacheManager = kcKrmsCacheManager;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public RuleRepositoryService getRuleRepositoryService() {
        return this.ruleRepositoryService;
    }

    public void setRuleRepositoryService(RuleRepositoryService ruleRepositoryService) {
        this.ruleRepositoryService = ruleRepositoryService;
    }
}

