/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.modular;

import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalBudgetModularController
extends ProposalBudgetControllerBase {
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropBudget-ModularPage"})
    public ModelAndView navigateToModular(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetModular() != null) continue;
            this.getBudgetModularService().generateModularPeriod(budgetPeriod);
        }
        form.setBudgetModularSummary(this.getBudgetModularService().processModularSummary(budget, true));
        return super.navigate(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=synchModular"})
    public ModelAndView synchModular(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        this.getBudgetModularService().synchModularBudget(budget, false);
        form.setBudgetModularSummary(this.getBudgetModularService().processModularSummary(budget, true));
        super.saveBudget(form);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=recalculateModular"})
    public ModelAndView recalculateModular(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        if (!this.roundFandAbase()) {
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                this.getBudgetModularService().generateModularPeriod(budgetPeriod);
            }
        } else {
            this.getBudgetModularService().synchModularBudget(budget, true);
        }
        form.setBudgetModularSummary(this.getBudgetModularService().processModularSummary(budget, true));
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    public boolean roundFandAbase() {
        return this.parameterService.getParameterValueAsBoolean("KC-PD", "Document", "ModularBudget_Round_F_and_A_Base");
    }
}

