/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.util.NumberUtils;

public final class ControllerFileUtils {
    private ControllerFileUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static final void streamToResponse(KcFile attachmentDataSource, HttpServletResponse response) throws Exception {
        ControllerFileUtils.streamToResponse(attachmentDataSource.getData(), attachmentDataSource.getName(), attachmentDataSource.getType(), response);
    }

    public static final void streamToResponse(byte[] fileContents, String fileName, String fileContentType, HttpServletResponse response) throws Exception {
        long size = fileContents.length;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContents);){
            KRADUtils.addAttachmentToResponse((HttpServletResponse)response, (InputStream)inputStream, (String)fileContentType, (String)fileName, (long)size);
            response.flushBuffer();
        }
    }

    public static void streamOutputToResponse(HttpServletResponse response, ByteArrayOutputStream stream, String contentType, String fileName, long fileSize) throws IOException {
        String updateFileName = fileName.contains("\"") ? fileName.replaceAll("\"", "") : fileName;
        response.setContentType(contentType);
        response.setContentLength(((Integer)NumberUtils.convertNumberToTargetClass((Number)fileSize, Integer.class)).intValue());
        response.setHeader("Content-disposition", "attachment; filename=\"" + updateFileName + "\"");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        if (stream != null) {
            stream.writeTo((OutputStream)response.getOutputStream());
        }
    }
}

