/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.schedule;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmissionConstants;
import org.kuali.coeus.propdev.impl.s2s.S2sRequestConfigDto;
import org.kuali.coeus.propdev.impl.s2s.S2sSubmissionDao;
import org.kuali.coeus.propdev.impl.s2s.S2sSubmissionService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="s2SPollingTask")
public class S2SPollingTask {
    private static final Logger LOG = LogManager.getLogger(S2SPollingTask.class);
    private static final String KEY_STATUS = "status";
    private static final String TERMINAL_STATUS = S2sAppSubmissionConstants.STATUS_AGENCY_TRACKING_NUMBER_ASSIGNED;
    private static final int COMMENT_MAX_LENGTH = 2000;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="s2sSubmissionService")
    private S2sSubmissionService s2sSubmissionService;
    @Autowired
    @Qualifier(value="s2sSubmissionDao")
    private S2sSubmissionDao s2sSubmissionDao;

    public void execute() {
        LOG.info("Starting S2SPollingTask");
        List nonFinalizedSubmissions = this.dataObjectService.findMatching(S2sAppSubmission.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.notEqual((String)KEY_STATUS, (Object)TERMINAL_STATUS)})).getResults();
        Map<String, List<S2sAppSubmission>> submissionsByProposalNumber = nonFinalizedSubmissions.stream().collect(Collectors.groupingBy(S2sAppSubmission::getProposalNumber));
        if (LOG.isInfoEnabled()) {
            LOG.info("Found " + submissionsByProposalNumber.size() + " S2S App Submissions without a terminal status of " + TERMINAL_STATUS);
        }
        Map<S2sRequestConfigDto, List<S2sAppSubmission>> latestSubmissionsByDunsNumber = submissionsByProposalNumber.values().stream().flatMap(submissions -> Stream.of(submissions.stream().max(Comparator.comparing(S2sAppSubmission::getSubmissionNumber)))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.groupingBy(this.s2sSubmissionDao::getSubmissionRequestInfo));
        latestSubmissionsByDunsNumber.forEach((requestConfig, submissions) -> {
            try {
                this.s2sSubmissionService.refreshSubmissions((S2sRequestConfigDto)requestConfig, (Collection<S2sAppSubmission>)submissions);
            }
            catch (RuntimeException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        });
        LOG.info("Ending S2SPollingTask");
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public S2sSubmissionService getS2sSubmissionService() {
        return this.s2sSubmissionService;
    }

    public void setS2sSubmissionService(S2sSubmissionService s2sSubmissionService) {
        this.s2sSubmissionService = s2sSubmissionService;
    }
}

