/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.core;

import java.util.HashMap;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;

public class AccountDocumentAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    public static final String PERMISSION_MAINTAIN_ACCOUNT = "Create Account Document";
    public static final String KC_SYS = "KC-SYS";

    public boolean canInitiate(String documentTypeName, Person user) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", documentTypeName);
        boolean retVal = AccountDocumentAuthorizer.getPermissionService().isAuthorized(user.getPrincipalId(), "KC-PD", PERMISSION_MAINTAIN_ACCOUNT, permissionDetails);
        return retVal;
    }

    public boolean canMaintain(Object dataObject, Person user) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>(2);
        permissionDetails.put("documentTypeName", AccountDocumentAuthorizer.getDocumentDictionaryService().getMaintenanceDocumentTypeName(dataObject.getClass()));
        permissionDetails.put("maintenanceAction", KC_SYS);
        return !this.permissionExistsByTemplate(KC_SYS, "Initiate Document", permissionDetails) || this.isAuthorizedByTemplate(dataObject, KC_SYS, "Initiate Document", user.getPrincipalId(), permissionDetails, null);
    }

    public boolean canCopy(Document document, Person user) {
        return this.canInitiate(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName(), user);
    }
}

