/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.rate.RateClassType;
import org.kuali.coeus.common.budget.impl.struts.BudgetAction;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class BudgetRatesAction
extends BudgetAction {
    private static final String CONFIRM_SYNC_RATES = "confirmSyncRates";
    private static final String CONFIRM_SYNC_ALL_RATES = "confirmSyncAllRates";
    private static final String CONFIRM_RESET_RATES = "confirmResetRates";
    private static final String CONFIRM_RESET_ALL_RATES = "confirmResetAllRates";
    private static final String CONFIRM_RATE_CHANGE = "confirmRateChange";
    private static final String REJECT_RATE_CHANGE = "rejectRateChange";

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        if (KNSGlobalVariables.getKualiForm() == null) {
            KNSGlobalVariables.setKualiForm((KualiForm)((KualiForm)form));
        }
        budget.setRateSynced(false);
        if (this.haveRatesBeenChanged(budget)) {
            return this.askConfirmRateChange(mapping, (ActionForm)budgetForm, request, response);
        }
        ActionForward forward = super.save(mapping, form, request, response);
        if (!budgetForm.getMethodToCall().equals("save") && budgetForm.isAuditActivated()) {
            forward = mapping.findForward("rates_save");
        }
        return forward;
    }

    public ActionForward resetRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildResetRatesConfirmationQuestion(mapping, form, request, response), CONFIRM_RESET_RATES, "");
    }

    private StrutsConfirmation buildResetRatesConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_RESET_RATES, "document.question.resetRates.text", "");
    }

    public ActionForward confirmResetRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_RESET_RATES.equals(question)) {
            BudgetForm budgetForm = (BudgetForm)form;
            Budget budget = budgetForm.getBudget();
            RateClassType rateClassT = budget.getRateClassTypes().get(this.getSelectedLine(request));
            String rateClassType = rateClassT.getCode();
            budget.getBudgetRatesService().resetBudgetRatesForRateClassType(rateClassType, budget);
        }
        return mapping.findForward("basic");
    }

    public ActionForward syncRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildSyncRatesConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_RATES, "");
    }

    private StrutsConfirmation buildSyncRatesConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_RATES, "document.question.syncRates.text", "");
    }

    public ActionForward confirmSyncRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SYNC_RATES.equals(question)) {
            BudgetForm budgetForm = (BudgetForm)form;
            Budget budget = budgetForm.getBudget();
            RateClassType rateClassT = budget.getRateClassTypes().get(this.getSelectedLine(request));
            String rateClassType = rateClassT.getCode();
            this.getBudgetRatesService().syncBudgetRatesForRateClassType(rateClassType, budget);
            budget.setRateClassTypesReloaded(false);
            if (rateClassType.equals("O")) {
                budget.setRateSynced(true);
            }
        }
        return mapping.findForward("basic");
    }

    private BudgetRatesService getBudgetRatesService() {
        return KcServiceLocator.getService(BudgetRatesService.class);
    }

    public ActionForward syncAllRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildSyncAllRatesConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_ALL_RATES, "");
    }

    private StrutsConfirmation buildSyncAllRatesConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_ALL_RATES, "document.question.syncAllRates.text", "");
    }

    public ActionForward confirmSyncAllRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SYNC_ALL_RATES.equals(question)) {
            BudgetForm budgetForm = (BudgetForm)form;
            Budget budget = budgetForm.getBudget();
            budget.setRateClassTypesReloaded(true);
            budget.getBudgetRatesService().syncAllBudgetRates(budget);
            budget.setRateSynced(true);
            BudgetParentDocument<? extends BudgetParent> parentDocument = budget.getBudgetParent().getDocument();
            if (!budget.getActivityTypeCode().equals(parentDocument.getBudgetParent().getActivityTypeCode())) {
                budget.setActivityTypeCode(parentDocument.getBudgetParent().getActivityTypeCode());
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward resetAllRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildResetAllRatesConfirmationQuestion(mapping, form, request, response), CONFIRM_RESET_ALL_RATES, "");
    }

    private StrutsConfirmation buildResetAllRatesConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_RESET_ALL_RATES, "document.question.resetAllRates.text", "");
    }

    public ActionForward confirmResetAllRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_RESET_ALL_RATES.equals(question)) {
            BudgetForm budgetForm = (BudgetForm)form;
            Budget budget = budgetForm.getBudget();
            this.getBudgetRatesService().resetAllBudgetRates(budget);
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateRatesView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        this.getBudgetRatesService().viewLocation(budgetForm.getViewLocation(), budgetForm.getViewBudgetPeriod(), budget);
        return mapping.findForward("basic");
    }

    private boolean haveRatesBeenChanged(Budget budget) {
        for (BudgetRate rate : budget.getBudgetRates()) {
            if (!rate.isRateChanged()) continue;
            return true;
        }
        return false;
    }

    public ActionForward askConfirmRateChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_RATE_CHANGE, "document.question.saveRates.text", new String[0]), CONFIRM_RATE_CHANGE, REJECT_RATE_CHANGE);
    }

    public ActionForward confirmRateChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        for (BudgetRate rate : budget.getBudgetRates()) {
            rate.setRateChanged(false);
        }
        return this.save(mapping, (ActionForm)budgetForm, request, response);
    }

    public ActionForward rejectRateChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        for (BudgetRate rate : budget.getBudgetRates()) {
            rate.setRateChanged(false);
            rate.setExactApplicableRate(rate.getOldApplicableRate());
        }
        return mapping.findForward("basic");
    }
}

