/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.propdev.impl.person.creditsplit.CreditSplit;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplit;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.AwardService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardPersonCreditSplitAuditRule
implements DocumentAuditRule {
    private static final String PERSON_TOTALS_KEY = "personTotalsKey";
    private static final long serialVersionUID = 1330497293834315534L;
    private static final String YES = "Y";
    private static final String AWARD_CREDIT_SPLIT_PARM_NAME = "award.creditsplit.enabled";
    private static final ScaleTwoDecimal ZERO_VALUE = ScaleTwoDecimal.ZERO;
    private static final ScaleTwoDecimal MAX_VALUE = new ScaleTwoDecimal(100.0);
    private static final ScaleTwoDecimal MAX_TOTAL_VALUE = new ScaleTwoDecimal(100.0);
    public static final String AWARD_CREDIT_SPLIT_LIST_ERROR_KEY = "document.awardList[0].projectPersons.awardPersonCreditSplits";
    public static final String AWARD_PERSON_CREDIT_SPLIT_ERROR_MSG_KEY = "error.award.person.credit.split.error";
    public static final String AWARD_UNIT_CREDIT_SPLIT_LIST_ERROR_KEY = "document.awardList[0].projectPersons.awardPersonUnitCreditSplits";
    public static final String AWARD_PERSON_UNIT_CREDIT_SPLIT_ERROR_MSG_KEY = "error.award.person.unit.credit.split.error";
    private transient Collection<InvestigatorCreditType> investigatorCreditTypes;
    private transient ParameterService parameterService;
    private List<AuditError> auditErrors = new ArrayList<AuditError>();
    private transient AwardService awardService;

    public Collection<InvestigatorCreditType> getInvestigatorCreditTypes() {
        if (this.investigatorCreditTypes == null || this.investigatorCreditTypes.size() == 0) {
            this.investigatorCreditTypes = this.loadInvestigatorCreditTypes();
        }
        return this.investigatorCreditTypes;
    }

    public List<AwardPerson> getProjectPersons(AwardDocument awardDocument) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        List<AwardPerson> projectPersons = awardDocument.getAward().getProjectPersons();
        for (AwardPerson p : projectPersons) {
            this.createDefaultCreditSplitMapForProjectPerson(creditTypes, p);
            for (AwardPersonUnit apu : p.getUnits()) {
                this.createDefaultCreditSplitMapForPersonUnit(creditTypes, apu);
            }
        }
        return awardDocument.getAward().getProjectPersons();
    }

    public boolean isAwardCreditsLimitApplicable() {
        try {
            String parmValue = this.fetchParameterValue(AWARD_CREDIT_SPLIT_PARM_NAME);
            return parmValue.equalsIgnoreCase(YES);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean recalculateCreditSplit(AwardDocument awardDocument) {
        boolean noErrors = true;
        if (this.isAwardCreditsLimitApplicable()) {
            Map<String, Map<String, ScaleTwoDecimal>> totalsMap = this.calculateCreditSplitTotals(awardDocument);
            noErrors = this.checkIfPersonTotalsAreValid(totalsMap);
            noErrors &= this.checkIfPersonUnitsTotalsAreValid(awardDocument, totalsMap);
        }
        return noErrors;
    }

    protected String fetchParameterValue(String parmName) {
        return this.getParameterService().getParameterValueAsString(AwardDocument.class, parmName);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    Map<String, Map<String, ScaleTwoDecimal>> calculateCreditSplitTotals(AwardDocument awardDocument) {
        HashMap<String, Map<String, ScaleTwoDecimal>> allCreditSplitTotals = new HashMap<String, Map<String, ScaleTwoDecimal>>();
        this.calculatePersonTotals(awardDocument, allCreditSplitTotals);
        this.calculatePersonUnitTotals(awardDocument, allCreditSplitTotals);
        return allCreditSplitTotals;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }

    private void calculatePersonTotalForCreditSplitType(AwardPerson projectPerson, InvestigatorCreditType creditType, Map<String, ScaleTwoDecimal> personCreditSplitTotalMap) {
        String creditTypeCode = creditType.getCode();
        ScaleTwoDecimal personsTotalCredit = personCreditSplitTotalMap.get(creditTypeCode);
        if (personsTotalCredit == null) {
            personsTotalCredit = ZERO_VALUE;
        }
        for (CreditSplit creditSplit : projectPerson.getCreditSplits()) {
            if (!creditSplit.getInvCreditTypeCode().equals(creditTypeCode)) continue;
            personCreditSplitTotalMap.put(creditTypeCode, (ScaleTwoDecimal)personsTotalCredit.add((AbstractDecimal)creditSplit.getCredit()));
        }
    }

    private void calculatePersonTotals(AwardDocument awardDocument, Map<String, Map<String, ScaleTwoDecimal>> allCreditSplitTotals) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        Map<String, ScaleTwoDecimal> personCreditSplitTotalMap = this.initializePersonCreditSplitTotalMap(allCreditSplitTotals);
        for (AwardPerson projectPerson : this.getAwardService().getPersonsSelectedForCreditSplit(this.getProjectPersons(awardDocument))) {
            for (InvestigatorCreditType creditType : creditTypes) {
                this.calculatePersonTotalForCreditSplitType(projectPerson, creditType, personCreditSplitTotalMap);
            }
        }
    }

    private void calculatePersonUnitTotals(AwardDocument awardDocument, Map<String, Map<String, ScaleTwoDecimal>> allCreditSplitTotals) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        for (AwardPerson projectPerson : this.getProjectPersons(awardDocument)) {
            String personKey = this.getPersonKey(projectPerson);
            Map<String, ScaleTwoDecimal> personUnitCreditTotals = allCreditSplitTotals.get(personKey);
            if (personUnitCreditTotals == null) {
                personUnitCreditTotals = new HashMap<String, ScaleTwoDecimal>();
                allCreditSplitTotals.put(personKey, personUnitCreditTotals);
            }
            for (InvestigatorCreditType creditType : creditTypes) {
                String creditTypeCode;
                ScaleTwoDecimal totalCredit = personUnitCreditTotals.get(creditTypeCode = creditType.getCode());
                personUnitCreditTotals.put(creditTypeCode, totalCredit != null ? totalCredit : ZERO_VALUE);
            }
            this.calculateUnitCreditSplitTotals(projectPerson, personUnitCreditTotals);
        }
    }

    private void calculateUnitCreditSplitTotals(AwardPerson projectPerson, Map<String, ScaleTwoDecimal> personUnitCreditTotals) {
        if (projectPerson.isKeyPerson() && projectPerson.getUnits().size() == 0) {
            this.handleKeyPersonWithNoUnits(personUnitCreditTotals);
        } else {
            for (AwardPersonUnit unit : projectPerson.getUnits()) {
                for (CreditSplit creditSplit : unit.getCreditSplits()) {
                    ScaleTwoDecimal totalCredit = personUnitCreditTotals.get(creditSplit.getInvCreditTypeCode());
                    if (totalCredit == null) {
                        totalCredit = ZERO_VALUE;
                    }
                    personUnitCreditTotals.put(creditSplit.getInvCreditTypeCode(), (ScaleTwoDecimal)totalCredit.add((AbstractDecimal)creditSplit.getCredit()));
                }
            }
        }
    }

    private void handleKeyPersonWithNoUnits(Map<String, ScaleTwoDecimal> personUnitCreditTotals) {
        Collection<InvestigatorCreditType> creditTypes = this.getInvestigatorCreditTypes();
        for (InvestigatorCreditType creditType : creditTypes) {
            personUnitCreditTotals.put(creditType.getCode(), MAX_VALUE);
        }
    }

    private boolean checkIfPersonTotalsAreValid(Map<String, Map<String, ScaleTwoDecimal>> totalsMap) {
        int errorCount = 0;
        for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
            if (!creditType.addsToHundred().booleanValue()) continue;
            ScaleTwoDecimal value = totalsMap.get(PERSON_TOTALS_KEY).get(creditType.getCode());
            if (value == null) break;
            if (((ScaleTwoDecimal)MAX_TOTAL_VALUE.subtract((AbstractDecimal)value)).isZero()) continue;
            this.auditErrors.add(new AuditError(AWARD_CREDIT_SPLIT_LIST_ERROR_KEY, AWARD_PERSON_CREDIT_SPLIT_ERROR_MSG_KEY, "contacts.Contacts", new String[]{creditType.getDescription()}));
            ++errorCount;
        }
        return errorCount == 0;
    }

    private boolean checkIfPersonUnitsTotalsAreValid(AwardDocument awardDocument, Map<String, Map<String, ScaleTwoDecimal>> totalsMap) {
        boolean success = true;
        for (AwardPerson person : this.getAwardService().getPersonsSelectedForCreditSplit(awardDocument.getAward().getProjectPersons())) {
            int errorCount = 0;
            Map<String, ScaleTwoDecimal> totalsByCreditSplitType = totalsMap.get(this.getPersonKey(person));
            for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
                if (!creditType.addsToHundred().booleanValue()) continue;
                ScaleTwoDecimal value = totalsByCreditSplitType.get(creditType.getCode());
                if (value == null) break;
                if (((ScaleTwoDecimal)MAX_TOTAL_VALUE.subtract((AbstractDecimal)value)).isZero()) continue;
                this.auditErrors.add(new AuditError(AWARD_UNIT_CREDIT_SPLIT_LIST_ERROR_KEY, AWARD_PERSON_UNIT_CREDIT_SPLIT_ERROR_MSG_KEY, "contacts.Contacts", new String[]{creditType.getDescription(), person.getFullName()}));
                ++errorCount;
            }
            success &= errorCount == 0;
        }
        return success;
    }

    private void createDefaultCreditSplitMapForPersonUnit(Collection<InvestigatorCreditType> creditTypes, AwardPersonUnit apu) {
        HashMap<InvestigatorCreditType, AwardPersonUnitCreditSplit> personUnitCreditMap = new HashMap<InvestigatorCreditType, AwardPersonUnitCreditSplit>();
        for (AwardPersonUnitCreditSplit apuCreditSplit : apu.getCreditSplits()) {
            personUnitCreditMap.put(apuCreditSplit.getInvestigatorCreditType(), apuCreditSplit);
        }
        for (InvestigatorCreditType creditType : creditTypes) {
            if (personUnitCreditMap.get(creditType) != null) continue;
            apu.add(new AwardPersonUnitCreditSplit(creditType, ZERO_VALUE));
        }
    }

    private void createDefaultCreditSplitMapForProjectPerson(Collection<InvestigatorCreditType> creditTypes, AwardPerson projectPerson) {
        HashMap<InvestigatorCreditType, AwardPersonCreditSplit> personCreditMap = new HashMap<InvestigatorCreditType, AwardPersonCreditSplit>();
        for (AwardPersonCreditSplit creditSplit : projectPerson.getCreditSplits()) {
            personCreditMap.put(creditSplit.getInvestigatorCreditType(), creditSplit);
        }
        for (InvestigatorCreditType creditType : creditTypes) {
            if (personCreditMap.get(creditType) != null) continue;
            projectPerson.add(new AwardPersonCreditSplit(creditType, ZERO_VALUE));
        }
    }

    private String getPersonKey(AwardPerson projectPerson) {
        String personKey = "";
        if (projectPerson != null) {
            personKey = projectPerson.getIsRolodexPerson() ? projectPerson.getRolodex().getOrganization() : projectPerson.getFullName();
        }
        return personKey;
    }

    private Map<String, ScaleTwoDecimal> initializePersonCreditSplitTotalMap(Map<String, Map<String, ScaleTwoDecimal>> allCreditSplitTotals) {
        Map<String, ScaleTwoDecimal> personCreditTypeTotals = allCreditSplitTotals.get(PERSON_TOTALS_KEY);
        if (personCreditTypeTotals == null) {
            personCreditTypeTotals = new HashMap<String, ScaleTwoDecimal>();
            allCreditSplitTotals.put(PERSON_TOTALS_KEY, personCreditTypeTotals);
        }
        return personCreditTypeTotals;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        AwardDocument awardDocument = (AwardDocument)document;
        boolean valid = this.recalculateCreditSplit(awardDocument);
        this.reportAndCreateAuditCluster();
        return valid;
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            AuditCluster existingErrors = (AuditCluster)GlobalVariables.getAuditErrorMap().get("contactsAuditErrors");
            if (existingErrors == null) {
                GlobalVariables.getAuditErrorMap().put("contactsAuditErrors", new AuditCluster("Contacts", this.auditErrors, "Error"));
            } else {
                existingErrors.getAuditErrorList().addAll(this.auditErrors);
            }
        }
    }
}

