/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award.impl;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.kfs.integration.cg.dto.AccountCreationStatusDTO;
import org.kuali.kfs.integration.cg.dto.AccountParametersDTO;
import org.kuali.kfs.module.external.kc.service.AccountCreationService;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCfda;
import org.kuali.kra.external.award.AccountCreationClient;
import org.kuali.kra.external.award.FinancialIndirectCostRecoveryTypeCode;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class AccountCreationClientBase
implements AccountCreationClient {
    protected static final String SOAP_SERVICE_NAME = "accountCreationServiceSOAP";
    protected static final QName SERVICE_NAME = new QName("http://kfs.kuali.org/kc-kfs/v2_0", "accountCreationServiceSOAP");
    private static final String ERROR_MESSAGE = "Cannot connect to the service. The service may be down, please try again later.";
    private static final Logger LOG = LogManager.getLogger(AccountCreationClientBase.class);
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private ConfigurationService configurationService;

    protected abstract AccountCreationService getServiceHandle();

    @Override
    public String isValidAccountNumber(String accountNumber) {
        boolean isValidAccountNumber;
        try {
            AccountCreationService port = this.getServiceHandle();
            LOG.info("Connecting to financial system...");
            isValidAccountNumber = port.isValidAccount(accountNumber);
        }
        catch (Exception e) {
            LOG.error(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            return null;
        }
        return "" + isValidAccountNumber;
    }

    @Override
    public String isValidChartAccount(String chartOfAccountsCode, String accountNumber) {
        boolean isValidChartOfAccountsCode;
        try {
            AccountCreationService port = this.getServiceHandle();
            LOG.info("Connecting to financial system...");
            isValidChartOfAccountsCode = port.isValidChartAccount(chartOfAccountsCode, accountNumber);
        }
        catch (Exception e) {
            LOG.error(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            return null;
        }
        return "" + isValidChartOfAccountsCode;
    }

    @Override
    public void createAwardAccount(Award award) throws DatatypeConfigurationException, WorkflowException {
        AccountParametersDTO accountParameters = this.getAccountParameters(award);
        AccountCreationStatusDTO createAccountResult = null;
        try {
            AccountCreationService port = this.getServiceHandle();
            LOG.info("Connecting to financial system...");
            createAccountResult = port.createAccount(accountParameters);
        }
        catch (Exception e) {
            LOG.error(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            GlobalVariables.getMessageMap().putError("error.award.createAccount.cannotConnect", "error.award.createAccount.cannotConnect", new String[0]);
        }
        if (createAccountResult != null) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)createAccountResult.getStatus(), (CharSequence)"success")) {
                StringBuilder completeErrorMessage = new StringBuilder();
                List<String> errorMessages = createAccountResult.getErrorMessages();
                for (String errorMessage : errorMessages) {
                    completeErrorMessage.append(errorMessage);
                }
                GlobalVariables.getMessageMap().putError("error.award.createAccount.serviceErrors", "error.award.createAccount.serviceErrors", new String[]{completeErrorMessage.toString()});
            } else {
                String financialAccountDocumentNumber = createAccountResult.getDocumentNumber();
                if (financialAccountDocumentNumber == null) {
                    GlobalVariables.getMessageMap().putError("error.award.createAccount.nullDocumentNumber", "error.award.createAccount.nullDocumentNumber", new String[0]);
                    LOG.warn("Document number returned from KFS account creation service is null.");
                } else {
                    String accountNumber = award.getAccountNumber().toUpperCase();
                    award.setAccountNumber(accountNumber);
                    award.setFinancialAccountDocumentNumber(financialAccountDocumentNumber);
                    Calendar calendar = Calendar.getInstance();
                    award.setFinancialAccountCreationDate(new Date(calendar.getTime().getTime()));
                    award.setFinancialChartOfAccountsCode(createAccountResult.getChartOfAccountsCode());
                    AwardDocument awardDocument = award.getAwardDocument();
                    this.documentService.saveDocument((Document)awardDocument);
                }
                if (ObjectUtils.isNotNull(createAccountResult.getErrorMessages()) && !createAccountResult.getErrorMessages().isEmpty()) {
                    StringBuilder completeErrorMessage = new StringBuilder();
                    List<String> errorMessages = createAccountResult.getErrorMessages();
                    for (String errorMessage : errorMessages) {
                        completeErrorMessage.append(errorMessage);
                    }
                    GlobalVariables.getMessageMap().putError("error.award.createAccount.saved.with.errors", "error.award.createAccount.saved.with.errors", new String[]{completeErrorMessage.toString()});
                }
            }
        }
    }

    protected AccountParametersDTO getAccountParameters(Award award) throws DatatypeConfigurationException {
        String icrRateCode;
        AccountParametersDTO accountParameters = new AccountParametersDTO();
        this.setName(award, accountParameters);
        accountParameters.setAccountNumber(award.getAccountNumber());
        this.setDefaultAddress(award, accountParameters);
        this.setAdminAddress(award, accountParameters);
        if (CollectionUtils.isNotEmpty(award.getAwardCfdas())) {
            award.getAwardCfdas().stream().map(AwardCfda::getCfdaNumber).findFirst().ifPresent(accountParameters::setCfdaNumber);
        }
        Date effectiveDate = award.getAwardEffectiveDate();
        GregorianCalendar dateEffective = new GregorianCalendar();
        dateEffective.setTime(effectiveDate);
        XMLGregorianCalendar gregorianDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateEffective);
        accountParameters.setEffectiveDate(gregorianDate);
        Date expirationDate = award.getProjectEndDate();
        GregorianCalendar dateExpiration = new GregorianCalendar();
        dateExpiration.setTime(expirationDate);
        gregorianDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateExpiration);
        accountParameters.setExpirationDate(gregorianDate);
        String expenseGuidelineText = award.getAwardNumber();
        accountParameters.setExpenseGuidelineText(expenseGuidelineText);
        this.setIncomeGuidelineText(award, accountParameters);
        accountParameters.setPurposeText(award.getTitle());
        accountParameters.setUnit(award.getUnitNumber());
        accountParameters.setPrincipalId(GlobalVariables.getUserSession().getPrincipalId());
        AwardFandaRate currentFandaRate = award.getCurrentFandaRate();
        if (currentFandaRate != null) {
            String rateClassCode = currentFandaRate.getFandaRateType().getRateClassCode();
            String rateTypeCode = currentFandaRate.getFandaRateType().getRateTypeCode();
            String icrTypeCode = this.getIndirectCostTypeCode(rateClassCode, rateTypeCode);
            accountParameters.setIndirectCostTypeCode(icrTypeCode);
            accountParameters.setOffCampusIndicator(currentFandaRate.getOnOffCampusFlag() == false);
        }
        if ("ICRNONE".equals(icrRateCode = award.getIcrRateCode())) {
            accountParameters.setIndirectCostRate("");
        } else {
            accountParameters.setIndirectCostRate(icrRateCode);
        }
        accountParameters.setHigherEdFunctionCode(award.getActivityType().getHigherEducationFunctionCode());
        return accountParameters;
    }

    protected String getIndirectCostTypeCode(String rateClassCode, String rateTypeCode) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("rateClassCode", rateClassCode);
        criteria.put("rateTypeCode", rateTypeCode);
        FinancialIndirectCostRecoveryTypeCode icrCostTypeCode = (FinancialIndirectCostRecoveryTypeCode)this.businessObjectService.findByPrimaryKey(FinancialIndirectCostRecoveryTypeCode.class, criteria);
        return ObjectUtils.isNotNull((Object)icrCostTypeCode) ? icrCostTypeCode.getIcrTypeCode() : "";
    }

    protected void setName(Award award, AccountParametersDTO accountParameters) {
        int ACCOUNT_NAME_LENGTH = 40;
        Object accountName = "";
        if (ObjectUtils.isNotNull((Object)award.getSponsor().getAcronym())) {
            accountName = (String)accountName + award.getSponsor().getAcronym() + "-";
        }
        if (ObjectUtils.isNotNull((Object)award.getSponsorAwardNumber())) {
            accountName = (String)accountName + award.getSponsorAwardNumber() + "-";
        }
        if (ObjectUtils.isNotNull((Object)award.getPrincipalInvestigator()) && ObjectUtils.isNotNull((Object)award.getPrincipalInvestigator().getPerson())) {
            accountName = (String)accountName + award.getPrincipalInvestigator().getPerson().getLastName() + award.getPrincipalInvestigator().getPerson().getFirstName();
        }
        if (ObjectUtils.isNotNull((Object)accountName) && ((String)accountName).length() > 40) {
            accountName = ((String)accountName).substring(0, 39);
        }
        accountParameters.setAccountName((String)accountName);
    }

    protected void setDefaultAddress(Award award, AccountParametersDTO accountParameters) {
        KcPerson principalInvestigator = award.getPrincipalInvestigator().getPerson();
        if (ObjectUtils.isNotNull((Object)principalInvestigator)) {
            Object streetAddress = "";
            if (principalInvestigator.getAddressLine1() != null) {
                streetAddress = (String)streetAddress + principalInvestigator.getAddressLine1();
            }
            if (principalInvestigator.getAddressLine2() != null) {
                streetAddress = (String)streetAddress + principalInvestigator.getAddressLine2();
            }
            if (principalInvestigator.getAddressLine3() != null) {
                streetAddress = (String)streetAddress + principalInvestigator.getAddressLine3();
            }
            accountParameters.setDefaultAddressStreetAddress((String)streetAddress);
            accountParameters.setDefaultAddressCityName(principalInvestigator.getCity());
            accountParameters.setDefaultAddressStateCode(principalInvestigator.getState());
            accountParameters.setDefaultAddressZipCode(principalInvestigator.getPostalCode());
        }
    }

    protected void setAdminAddress(Award award, AccountParametersDTO accountParameters) {
        List<AwardUnitContact> unitContacts = award.getAwardUnitContacts();
        for (AwardUnitContact contact : unitContacts) {
            KcPerson adminPerson;
            contact.refreshReferenceObject("unitAdministratorType");
            UnitAdministratorType adminType = contact.getUnitAdministratorType();
            if (!ObjectUtils.isNotNull((Object)adminType) || !"Administrative Contact".equals(adminType.getDescription()) || !ObjectUtils.isNotNull((Object)(adminPerson = contact.getPerson()))) continue;
            Object adminStreetAddress = "";
            if (adminPerson.getAddressLine1() != null) {
                adminStreetAddress = (String)adminStreetAddress + adminPerson.getAddressLine1();
            }
            if (adminPerson.getAddressLine2() != null) {
                adminStreetAddress = (String)adminStreetAddress + adminPerson.getAddressLine2();
            }
            if (adminPerson.getAddressLine3() != null) {
                adminStreetAddress = (String)adminStreetAddress + adminPerson.getAddressLine3();
            }
            accountParameters.setAdminContactAddressStreetAddress((String)adminStreetAddress);
            accountParameters.setAdminContactAddressStreetAddress(adminPerson.getAddressLine1());
            accountParameters.setAdminContactAddressCityName(adminPerson.getCity());
            accountParameters.setAdminContactAddressStateCode(adminPerson.getState());
            accountParameters.setAdminContactAddressZipCode(adminPerson.getPostalCode());
        }
    }

    protected void setIncomeGuidelineText(Award award, AccountParametersDTO accountParameters) {
        award.refreshReferenceObject("awardBasisOfPayment");
        String paymentBasis = award.getAwardBasisOfPayment().getDescription();
        award.refreshReferenceObject("awardMethodOfPayment");
        String paymentMethod = award.getAwardMethodOfPayment().getDescription();
        Object incomeGuidelineText = "";
        if (paymentBasis != null) {
            incomeGuidelineText = (String)incomeGuidelineText + paymentBasis;
        }
        if (paymentMethod != null) {
            incomeGuidelineText = (String)incomeGuidelineText + " " + paymentMethod;
        }
        accountParameters.setIncomeGuidelineText((String)incomeGuidelineText);
    }

    @Override
    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

