/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.award.service.AwardPaymentAndInvoicesService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class ValidMethodOfPaymentValuesFinder
extends UifKeyValuesFinderBase {
    private String basisOfPaymentCode;
    private AwardPaymentAndInvoicesService awardPaymentAndInvoicesService;

    public ValidMethodOfPaymentValuesFinder() {
    }

    public ValidMethodOfPaymentValuesFinder(String basisOfPaymentCode) {
        this.basisOfPaymentCode = basisOfPaymentCode;
    }

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyLabels = new ArrayList<KeyValue>();
        keyLabels.add((KeyValue)new ConcreteKeyValue("", "select"));
        if (StringUtils.isNotBlank((CharSequence)this.basisOfPaymentCode)) {
            for (ValidBasisMethodPayment basisMethodPayment : this.getAwardPaymentAndInvoicesService().getValidBasisMethodPaymentByBasisCode(this.basisOfPaymentCode)) {
                basisMethodPayment.refresh();
                keyLabels.add((KeyValue)new ConcreteKeyValue(basisMethodPayment.getMethodOfPaymentCode(), basisMethodPayment.getMethodOfPayment().getDescription()));
            }
        }
        return keyLabels;
    }

    private AwardPaymentAndInvoicesService getAwardPaymentAndInvoicesService() {
        if (this.awardPaymentAndInvoicesService == null) {
            this.awardPaymentAndInvoicesService = KcServiceLocator.getService(AwardPaymentAndInvoicesService.class);
        }
        return this.awardPaymentAndInvoicesService;
    }

    public String getBasisOfPaymentCode() {
        return this.basisOfPaymentCode;
    }

    public void setBasisOfPaymentCode(String basisOfPaymentCode) {
        this.basisOfPaymentCode = basisOfPaymentCode;
    }
}

