/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.rate;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.And;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.query.operator.LesserThan;
import org.kuali.coeus.common.budget.framework.query.operator.Or;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.InstituteRate;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.budget.impl.rate.BudgetRatesServiceImpl;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetRatesService")
public class BudgetRateServiceDecorator
extends BudgetRatesServiceImpl {
    private static final String AWARD_EB_RATE_CLASS_CODE = "awardBudgetEbRateClassCode";
    private static final String AWARD_EB_RATE_TYPE_CODE = "awardBudgetEbRateTypeCode";
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;

    @Override
    protected Collection<InstituteRate> getInstituteRates(Budget budget) {
        Collection<InstituteRate> instituteRates = super.getInstituteRates(budget);
        if (this.isAwardBudget(budget)) {
            return this.syncRatesIfAward(budget, instituteRates);
        }
        return instituteRates;
    }

    private boolean isAwardBudget(Budget budget) {
        return budget.getBudgetParent().getDocument().getClass().equals(AwardDocument.class);
    }

    private Collection<InstituteRate> syncRatesIfAward(Budget budget, Collection<InstituteRate> institueRates) {
        Award award = (Award)budget.getBudgetParent();
        return this.filterInstituteRatesForAward(award, institueRates);
    }

    private Collection<InstituteRate> filterInstituteRatesForAward(Award award, Collection<InstituteRate> instituteRates) {
        List<AwardFandaRate> awardFnARates = award.getAwardFandaRate();
        ArrayList<InstituteRate> instituteRatesForAward = new ArrayList<InstituteRate>();
        List<InstituteRate> awardEbRates = this.createAwardEBInstituteRates(award);
        if (awardFnARates.isEmpty() && awardEbRates.isEmpty()) {
            return instituteRates;
        }
        for (AwardFandaRate awardFnARate : awardFnARates) {
            InstituteRate awardRate = this.createAwardFnAInstitueRate(awardFnARate, award, instituteRates);
            instituteRatesForAward.add(awardRate);
        }
        if (!instituteRatesForAward.isEmpty()) {
            QueryList qlInstituteRates = new QueryList(instituteRatesForAward);
            qlInstituteRates.sort("startDate");
            InstituteRate firstRate = (InstituteRate)qlInstituteRates.get(0);
            if (firstRate.getStartDate().after(award.getRequestedStartDateInitial())) {
                firstRate.setStartDate(award.getRequestedStartDateInitial());
            }
        }
        instituteRatesForAward.addAll(awardEbRates.stream().collect(Collectors.toList()));
        for (InstituteRate instituteRate : instituteRates) {
            if (!awardFnARates.isEmpty() && instituteRate.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType()) || !awardEbRates.isEmpty() & instituteRate.getRateClassType().equals(RateClassType.EMPLOYEE_BENEFITS.getRateClassType())) continue;
            instituteRatesForAward.add(instituteRate);
        }
        return instituteRatesForAward;
    }

    private List<InstituteRate> createAwardEBInstituteRates(Award award) {
        ScaleTwoDecimal specialEbRateOffCampus;
        ArrayList<InstituteRate> awardEBInstituteRates = new ArrayList<InstituteRate>();
        ScaleTwoDecimal specialEbRateOnCampus = award.getSpecialEbRateOnCampus();
        if (specialEbRateOnCampus != null) {
            awardEBInstituteRates.add(this.createEBInstituteRate(award, specialEbRateOnCampus, Boolean.TRUE));
        }
        if ((specialEbRateOffCampus = award.getSpecialEbRateOffCampus()) != null) {
            awardEBInstituteRates.add(this.createEBInstituteRate(award, specialEbRateOffCampus, Boolean.FALSE));
        }
        return awardEBInstituteRates;
    }

    private InstituteRate createEBInstituteRate(Award award, ScaleTwoDecimal specialEbRate, Boolean onCampusFlag) {
        InstituteRate awardInstituteRate = new InstituteRate();
        ScaleTwoDecimal applicableRate = new ScaleTwoDecimal(specialEbRate.bigDecimalValue());
        awardInstituteRate.setActivityTypeCode(award.getActivityTypeCode());
        awardInstituteRate.setStartDate(award.getRequestedStartDateInitial());
        Calendar cal = Calendar.getInstance();
        cal.setTime(award.getRequestedStartDateInitial());
        int year = cal.get(1);
        awardInstituteRate.setFiscalYear("" + year);
        awardInstituteRate.setInstituteRate(applicableRate);
        awardInstituteRate.setUnitNumber(award.getUnitNumber());
        String awardEBRateTypeCode = this.getDefaultEBRateTypeCode();
        String awardEBRateClassCode = this.getDefaultEBRateClassCode();
        awardInstituteRate.setRateTypeCode(awardEBRateTypeCode);
        awardInstituteRate.setRateType(this.createRateType(awardEBRateClassCode, awardEBRateTypeCode, "Special EB Rate"));
        awardInstituteRate.setRateClassCode(awardEBRateClassCode);
        awardInstituteRate.setOnOffCampusFlag(onCampusFlag);
        awardInstituteRate.setNonEditableRateFlag(true);
        awardInstituteRate.refreshReferenceObject("rateType");
        awardInstituteRate.refreshReferenceObject("rateClass");
        return awardInstituteRate;
    }

    private String getDefaultEBRateClassCode() {
        return this.getParameterService().getParameterValueAsString(Budget.class, AWARD_EB_RATE_CLASS_CODE);
    }

    private String getDefaultEBRateTypeCode() {
        return this.getParameterService().getParameterValueAsString(Budget.class, AWARD_EB_RATE_TYPE_CODE);
    }

    private InstituteRate createAwardFnAInstitueRate(AwardFandaRate awardFnARate, Award award, Collection<InstituteRate> instituteRates) {
        InstituteRate awardInstituteRate = this.filterInstituteRate(awardFnARate, award, instituteRates);
        ScaleTwoDecimal applicableRate = new ScaleTwoDecimal(awardFnARate.getApplicableFandaRate().bigDecimalValue());
        awardInstituteRate.setActivityTypeCode(award.getActivityTypeCode());
        awardInstituteRate.setStartDate(awardFnARate.getStartDate());
        awardInstituteRate.setFiscalYear(awardFnARate.getFiscalYear());
        awardInstituteRate.setExternalApplicableRate(applicableRate);
        if (awardInstituteRate.getInstituteRate() == null) {
            awardInstituteRate.setInstituteRate(applicableRate);
        }
        String awardFnArateTypeCode = awardFnARate.getFandaRateTypeCode();
        awardInstituteRate.setRateTypeCode(awardFnArateTypeCode);
        awardInstituteRate.setRateType(awardFnARate.getFandaRateType());
        awardInstituteRate.setRateClassCode(awardFnARate.getFandaRateType().getRateClassCode());
        Boolean onCampusFlag = awardFnARate.getOnCampusFlag().equals("N");
        awardInstituteRate.setOnOffCampusFlag(onCampusFlag);
        awardInstituteRate.setNonEditableRateFlag(true);
        awardInstituteRate.refreshReferenceObject("rateClass");
        return awardInstituteRate;
    }

    private InstituteRate filterInstituteRate(AwardFandaRate awardFnARate, Award award, Collection<InstituteRate> instituteRates) {
        QueryList<InstituteRate> qlInstituteRates = new QueryList<InstituteRate>(instituteRates);
        Equals eqActivityType = new Equals("activityTypeCode", (Comparable)((Object)award.getActivityTypeCode()));
        Equals eqCampusFlag = new Equals("onOffCampusFlag", awardFnARate.getOnCampusFlag().equals("N"));
        Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)awardFnARate.getFandaRateType().getRateClassCode()));
        Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)awardFnARate.getFandaRateTypeCode()));
        And campFlagAndActTypeAndUnitNum = new And(eqActivityType, eqCampusFlag);
        And rateClassAndRateType = new And(eqRateClassCode, eqRateTypeCode);
        And filterCondition = new And(campFlagAndActTypeAndUnitNum, rateClassAndRateType);
        QueryList<InstituteRate> qlfilteredList = qlInstituteRates.filter(filterCondition);
        Equals eqStartDate = new Equals("startDate", awardFnARate.getStartDate());
        LesserThan ltStartDate = new LesserThan("startDate", awardFnARate.getStartDate());
        Or ltOrEqStartDate = new Or(eqStartDate, ltStartDate);
        qlfilteredList = qlfilteredList.filter(ltOrEqStartDate);
        qlfilteredList.sort("startDate", false);
        return qlfilteredList.isEmpty() ? new InstituteRate() : qlfilteredList.get(0);
    }

    private RateType createRateType(String rateClassCode, String awardFnArateTypeCode, String rateTypeDesc) {
        RateType rateType = new RateType();
        rateType.setRateTypeCode(awardFnArateTypeCode);
        rateType.setRateClassCode(rateClassCode);
        rateType.setDescription(rateTypeDesc);
        return rateType;
    }

    @Override
    public void syncAllBudgetRates(Budget budget) {
        if (this.isAwardBudget(budget)) {
            if (this.isOutOfSyncAwardRates(budget)) {
                super.syncAllBudgetRates(budget);
                this.repopulateAllCalcAmounts(budget);
            }
        } else {
            super.syncAllBudgetRates(budget);
        }
    }

    @Override
    public void syncParentDocumentRates(Budget budget) {
        if (this.isAwardBudget(budget) && !this.hasNoRatesFromParent(budget) && this.isOutOfSyncAwardRates((Award)budget.getBudgetParent(), budget)) {
            this.syncBudgetRatesForRateClassType(RateClassType.OVERHEAD.getRateClassType(), budget);
            this.syncBudgetRatesForRateClassType(RateClassType.EMPLOYEE_BENEFITS.getRateClassType(), budget);
            this.repopulateAllCalcAmounts(budget);
        }
    }

    private void repopulateAllCalcAmounts(Budget budget) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                this.getBudgetCalculationService().rePopulateCalculatedAmount(budget, budgetLineItem);
                List<BudgetPersonnelDetails> personnelDetailList = budgetLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetails : personnelDetailList) {
                    budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
                    this.getBudgetCalculationService().rePopulateCalculatedAmount(budget, budgetPersonnelDetails);
                }
            }
        }
    }

    private boolean hasNoRatesFromParent(Budget budget) {
        Award award = (Award)budget.getBudgetParent();
        return award.getAwardFandaRate().isEmpty() && award.getSpecialEbRateOffCampus() == null && award.getSpecialEbRateOnCampus() == null;
    }

    private boolean isOutOfSyncAwardRates(Budget budget) {
        Award award = (Award)budget.getBudgetParent();
        if (budget.getInstituteRates().isEmpty()) {
            this.populateInstituteRates(budget);
        }
        if (this.hasNoRatesFromParent(budget)) {
            return this.isOutOfSync(budget);
        }
        return this.isOutOfSyncAwardRates(award, budget);
    }

    private boolean isOutOfSyncAwardRates(Award award, Budget budget) {
        List<AwardFandaRate> fnaRates = award.getAwardFandaRate();
        QueryList<BudgetRate> budgetRates = new QueryList<BudgetRate>(budget.getBudgetRates());
        boolean ratesOutOfSync = false;
        if (!fnaRates.isEmpty()) {
            Equals eqOhRateClassType = new Equals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            QueryList<BudgetRate> filteredOhRates = budgetRates.filter(eqOhRateClassType);
            boolean bl = ratesOutOfSync = fnaRates.size() != filteredOhRates.size();
            if (!ratesOutOfSync) {
                for (BudgetRate budgetRate : filteredOhRates) {
                    ratesOutOfSync = !this.fnaRatesContains(fnaRates, budgetRate);
                    if (!ratesOutOfSync) continue;
                    return ratesOutOfSync;
                }
            }
        }
        Equals eqEbRateClassType = new Equals("rateClassType", (Comparable)((Object)RateClassType.EMPLOYEE_BENEFITS.getRateClassType()));
        ScaleTwoDecimal specialEbRateOnCampus = award.getSpecialEbRateOnCampus();
        if (specialEbRateOnCampus != null) {
            Equals eqOnCampus = new Equals("onOffCampusFlag", Boolean.TRUE);
            And onCampusEbRateClassType = new And(eqEbRateClassType, eqOnCampus);
            QueryList<BudgetRate> filteredEbRates = budgetRates.filter(onCampusEbRateClassType);
            boolean bl = ratesOutOfSync = filteredEbRates.size() != 1;
            if (!ratesOutOfSync) {
                BudgetRate budgetEbOnCampusRate = (BudgetRate)filteredEbRates.get(0);
                ratesOutOfSync = !budgetEbOnCampusRate.getApplicableRate().bigDecimalValue().equals(specialEbRateOnCampus.bigDecimalValue());
            }
        }
        ScaleTwoDecimal specialEbRateOffCampus = award.getSpecialEbRateOffCampus();
        if (!ratesOutOfSync && specialEbRateOffCampus != null) {
            Equals eqOffCampus = new Equals("onOffCampusFlag", Boolean.FALSE);
            And offCampusEbRateClassType = new And(eqEbRateClassType, eqOffCampus);
            QueryList<BudgetRate> filteredOffCampusEbRates = budgetRates.filter(offCampusEbRateClassType);
            boolean bl = ratesOutOfSync = filteredOffCampusEbRates.size() != 1;
            if (!ratesOutOfSync) {
                BudgetRate budgetEbOnCampusRate = (BudgetRate)filteredOffCampusEbRates.get(0);
                ratesOutOfSync = !budgetEbOnCampusRate.getApplicableRate().bigDecimalValue().equals(specialEbRateOffCampus.bigDecimalValue());
            }
        }
        return ratesOutOfSync;
    }

    private boolean fnaRatesContains(List<AwardFandaRate> fnaRates, BudgetRate budgetRate) {
        for (AwardFandaRate awardFandaRate : fnaRates) {
            if (!awardFandaRate.equals(budgetRate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean performSyncFlag(Budget budget) {
        return this.isAwardBudget(budget) && this.isOutOfSyncAwardRates(budget);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }
}

