/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.keyword;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.framework.keyword.ScienceKeyword;
import org.kuali.coeus.propdev.api.keyword.PropScienceKeywordContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="EPS_PROP_SCIENCE_KEYWORD")
@IdClass(value=PropScienceKeywordId.class)
public class PropScienceKeyword
extends KcPersistableBusinessObjectBase
implements HierarchyMaintainable,
PropScienceKeywordContract {
    @Id
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PROPOSAL_NUMBER", insertable=true, updatable=true)
    private DevelopmentProposal developmentProposal;
    @Id
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="SCIENCE_KEYWORD_CODE", insertable=true, updatable=true)
    private ScienceKeyword scienceKeyword;
    @Transient
    private Boolean selectKeyword = false;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;

    public PropScienceKeyword() {
    }

    public PropScienceKeyword(DevelopmentProposal developmentProposal2, ScienceKeyword scienceKeyword) {
        this.developmentProposal = developmentProposal2;
        this.scienceKeyword = scienceKeyword;
    }

    public ScienceKeyword getScienceKeyword() {
        return this.scienceKeyword;
    }

    public void setScienceKeyword(ScienceKeyword scienceKeyword) {
        this.scienceKeyword = scienceKeyword;
    }

    public Boolean getSelectKeyword() {
        return this.selectKeyword;
    }

    public void setSelectKeyword(Boolean selectKeyword) {
        this.selectKeyword = selectKeyword;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public String getProposalNumber() {
        return this.getDevelopmentProposal().getProposalNumber();
    }

    public DevelopmentProposal getDevelopmentProposal() {
        return this.developmentProposal;
    }

    public void setDevelopmentProposal(DevelopmentProposal developmentProposal) {
        this.developmentProposal = developmentProposal;
    }

    public static final class PropScienceKeywordId
    implements Serializable,
    Comparable<PropScienceKeywordId> {
        private String developmentProposal;
        private String scienceKeyword;

        public String toString() {
            return new ToStringBuilder((Object)this).append("developmentProposal", (Object)this.developmentProposal).append("scienceKeyword", (Object)this.scienceKeyword).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            PropScienceKeywordId rhs = (PropScienceKeywordId)other;
            return new EqualsBuilder().append((Object)this.developmentProposal, (Object)rhs.developmentProposal).append((Object)this.scienceKeyword, (Object)rhs.scienceKeyword).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.developmentProposal).append((Object)this.scienceKeyword).toHashCode();
        }

        @Override
        public int compareTo(PropScienceKeywordId other) {
            return new CompareToBuilder().append((Object)this.developmentProposal, (Object)other.developmentProposal).append((Object)this.scienceKeyword, (Object)other.scienceKeyword).toComparison();
        }

        public String getDevelopmentProposal() {
            return this.developmentProposal;
        }

        public void setDevelopmentProposal(String developmentProposal) {
            this.developmentProposal = developmentProposal;
        }

        public String getScienceKeyword() {
            return this.scienceKeyword;
        }

        public void setScienceKeyword(String scienceKeyword) {
            this.scienceKeyword = scienceKeyword;
        }
    }
}

