/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.excon.customdata.ExconProjectCustomData;
import org.kuali.kra.excon.document.ExconProjectDocument;
import org.kuali.kra.excon.document.ExconProjectDocumentRule;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.ExconProjectForm;
import org.kuali.kra.excon.service.ExconProjectService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class ExconProjectAction
extends KcTransactionalDocumentActionBase {
    private static final String DOCUMENT_ROUTE_QUESTION = "DocRoute";
    private transient ExconProjectService exconProjectService;
    private transient AuditHelper auditHelper;
    private transient VersionHistoryService versionHistoryService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        if (GlobalVariables.getAuditErrorMap().isEmpty()) {
            this.getAuditHelper().auditConditionally((ExconProjectForm)form);
        }
        return actionForward;
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        ActionForward forward = this.handleDocument(mapping, form, request, response, exconProjectForm);
        exconProjectForm.initializeFormOrDocumentBasedOnCommand();
        ExconProject exconProject = exconProjectForm.getExconProject();
        exconProjectForm.getExconProjectDocument().setExconProject(exconProject);
        return forward;
    }

    ActionForward handleDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, ExconProjectForm exconProjectForm) throws Exception {
        ActionForward forward = null;
        String command = exconProjectForm.getCommand();
        if ("displayActionListInlineView".equals(command)) {
            this.loadDocumentInForm(request, exconProjectForm);
        } else if ("projectActions".equals(command)) {
            this.loadDocumentInForm(request, exconProjectForm);
            forward = this.exconProjectActions(mapping, (ActionForm)exconProjectForm, request, response);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        return forward;
    }

    protected void loadDocumentInForm(HttpServletRequest request, ExconProjectForm exconProjectForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        ExconProjectDocument retrievedDocument = (ExconProjectDocument)this.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        exconProjectForm.setDocument((Document)retrievedDocument);
        request.setAttribute("docId", (Object)docIdRequestParameter);
    }

    protected void loadDocument(KualiDocumentFormBase kualiForm) throws WorkflowException {
        super.loadDocument(kualiForm);
    }

    protected void checkExconProjectCode(ExconProject exconProject) {
        String exconProjectNumber = exconProject.getProjectNumber();
        if (exconProjectNumber == null || Integer.parseInt(exconProjectNumber) < 1) {
            exconProjectNumber = this.getExconProjectService().getNextExconProjectNumber();
            exconProject.setProjectNumber(exconProjectNumber);
        }
        for (ExconProjectCustomData customData : exconProject.getExconProjectCustomDataList()) {
            customData.setExconProject(exconProject);
        }
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        ExconProject exconProject = exconProjectForm.getExconProjectDocument().getExconProject();
        String userId = GlobalVariables.getUserSession().getPrincipalName();
        if (exconProject.getProjectId() == null) {
            this.getVersionHistoryService().updateVersionHistory(exconProject, VersionStatus.PENDING, userId);
        }
        this.checkExconProjectCode(exconProject);
        if (new ExconProjectDocumentRule().processAddExconProjectBusinessRules(exconProject)) {
            DocumentHeader docHeader = exconProjectForm.getExconProjectDocument().getDocumentHeader();
            if (StringUtils.isEmpty((CharSequence)docHeader.getDocumentDescription()) || !docHeader.getDocumentDescription().equals(exconProject.getTitle())) {
                docHeader.setDocumentDescription(exconProject.getTitle());
            }
            this.getExconProjectService().updateExconProjectSequenceStatus(exconProject, VersionStatus.PENDING);
            return super.save(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward home(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("home");
    }

    public ActionForward events(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("events");
    }

    public ActionForward contacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("contacts");
    }

    public ActionForward agreements(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("agreements");
    }

    public ActionForward destinations(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("destinations");
    }

    public ActionForward commentsAndAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("commentsAndAttachments");
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        exconProjectForm.getCustomDataHelper().prepareCustomData();
        return mapping.findForward("customData");
    }

    public ActionForward exconProjectActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("projectActions");
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        exconProjectForm.setAuditActivated(false);
        AuditHelper.ValidationState status = this.getAuditHelper().isValidSubmission(exconProjectForm, true);
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        if (status == AuditHelper.ValidationState.OK) {
            super.route(mapping, form, request, response);
            return this.sendNotification(mapping, exconProjectForm, "501", "Submit ExconProject");
        }
        if (status == AuditHelper.ValidationState.WARNING) {
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_ROUTE_QUESTION, "Validation Warning Exists. Are you sure want to submit to workflow routing.", "confirmationQuestion", methodToCall, "");
            }
            if (DOCUMENT_ROUTE_QUESTION.equals(question) && "0".equals(buttonClicked)) {
                super.route(mapping, form, request, response);
                return this.sendNotification(mapping, exconProjectForm, "501", "Submit ExconProject");
            }
            return mapping.findForward("basic");
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        exconProjectForm.setAuditActivated(true);
        return mapping.findForward("basic");
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        exconProjectForm.setAuditActivated(false);
        AuditHelper.ValidationState status = this.getAuditHelper().isValidSubmission(exconProjectForm, true);
        if (status == AuditHelper.ValidationState.OK || status == AuditHelper.ValidationState.WARNING) {
            super.blanketApprove(mapping, form, request, response);
            return this.sendNotification(mapping, exconProjectForm, "501", "Submit ExconProject");
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        exconProjectForm.setAuditActivated(true);
        return mapping.findForward("basic");
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconProjectForm exconProjectForm = (ExconProjectForm)form;
        ActionForward forward = mapping.findForward("basic");
        AuditHelper.ValidationState status = this.getAuditHelper().isValidSubmission(exconProjectForm, true);
        if (status == AuditHelper.ValidationState.OK || status == AuditHelper.ValidationState.WARNING) {
            return super.approve(mapping, form, request, response);
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        return forward;
    }

    protected final boolean applyRules(DocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    public ActionForward sendNotification(ActionMapping mapping, ExconProjectForm exconProjectForm, String notificationType, String notificationString) {
        return null;
    }

    protected AuditHelper getAuditHelper() {
        if (this.auditHelper == null) {
            this.auditHelper = KcServiceLocator.getService(AuditHelper.class);
        }
        return this.auditHelper;
    }

    public void setAuditHelper(AuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }

    protected VersionHistoryService getVersionHistoryService() {
        if (this.versionHistoryService == null) {
            this.versionHistoryService = KcServiceLocator.getService(VersionHistoryService.class);
        }
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public ExconProjectService getExconProjectService() {
        if (this.exconProjectService == null) {
            this.exconProjectService = KcServiceLocator.getService(ExconProjectService.class);
        }
        return this.exconProjectService;
    }

    public void setExconProjectService(ExconProjectService exconProjectService) {
        this.exconProjectService = exconProjectService;
    }
}

