/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.distribution;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.framework.distribution.BudgetDistributionService;
import org.kuali.coeus.common.budget.framework.distribution.BudgetUnrecoveredFandA;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.rate.AbstractBudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.framework.costshare.CostShareService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetDistributionService")
public class BudgetDistributionServiceImpl
implements BudgetDistributionService {
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="costShareService")
    private CostShareService costShareService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setCostShareService(CostShareService costShareService) {
        this.costShareService = costShareService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public CostShareService getCostShareService() {
        return this.costShareService;
    }

    protected boolean isBudgetFinalAndComplete(Budget budget) {
        return false;
    }

    @Override
    public void initializeCollectionDefaults(Budget budget) {
        if (!this.isBudgetFinalAndComplete(budget)) {
            this.initializeCostSharingCollectionDefaults(budget);
            this.initializeUnrecoveredFandACollectionDefaults(budget);
        }
    }

    @Override
    public void initializeCostSharingCollectionDefaults(Budget budget) {
        block2: {
            block3: {
                if (!budget.isCostSharingApplicable().booleanValue() || !budget.isCostSharingAvailable() || budget.getBudgetCostShares().size() != 0 || this.isBudgetFinalAndComplete(budget)) break block2;
                if (!this.costShareService.validateProjectPeriodAsFiscalYear()) break block3;
                for (Budget.FiscalYearSummary fiscalYearSummary : budget.getFiscalYearCostShareTotals()) {
                    budget.add(this.createBudgetCostShare(fiscalYearSummary));
                }
                break block2;
            }
            if (!this.costShareService.validateProjectPeriodAsProjectPeriod()) break block2;
            for (BudgetPeriod period : budget.getBudgetPeriods()) {
                budget.add(this.createBudgetCostShare(period.getBudgetPeriod(), period.getCostSharingAmount()));
            }
        }
    }

    @Override
    public void initializeUnrecoveredFandACollectionDefaults(Budget budget) {
        if (budget.isUnrecoveredFandAApplicable().booleanValue() && budget.isUnrecoveredFandAAvailable() && budget.getBudgetUnrecoveredFandAs().size() == 0 && !this.isBudgetFinalAndComplete(budget)) {
            for (Budget.FiscalYearSummary fiscalYearSummary : budget.getFiscalYearUnrecoveredFandATotals()) {
                budget.add(this.createBudgetUnrecoveredFandA(fiscalYearSummary, this.findApplicableRatesForFiscalYearUFAndA(budget, fiscalYearSummary, true), "Y"));
                budget.add(this.createBudgetUnrecoveredFandA(fiscalYearSummary, this.findApplicableRatesForFiscalYearUFAndA(budget, fiscalYearSummary, false), "N"));
            }
        }
    }

    protected ScaleTwoDecimal findApplicableRatesForFiscalYearUFAndA(Budget budget, Budget.FiscalYearSummary fiscalYearSummary, boolean onCampus) {
        String unrecoveredFandARateClassCode = budget.getOhRateClassCode();
        if (unrecoveredFandARateClassCode == null || unrecoveredFandARateClassCode.trim().length() == 0) {
            return ScaleTwoDecimal.ZERO;
        }
        return this.findApplicableRateForRateClassCodeUFAndA(budget, fiscalYearSummary.getFiscalYear(), unrecoveredFandARateClassCode, onCampus);
    }

    protected ScaleTwoDecimal findApplicableRateForRateClassCodeUFAndA(Budget budget, Integer fiscalYear, String unrecoveredFandARateClassCode, boolean findOnCampusRate) {
        ScaleTwoDecimal applicableRate = ScaleTwoDecimal.ZERO;
        AbstractBudgetRate appliedRate = null;
        for (BudgetRate budgetRate : budget.getBudgetRates()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)budgetRate.getRateClassCode(), (CharSequence)unrecoveredFandARateClassCode) || findOnCampusRate != budgetRate.getOnOffCampusFlag()) continue;
            if (appliedRate == null || Integer.valueOf(appliedRate.getFiscalYear()) < Integer.valueOf(budgetRate.getFiscalYear()) && Integer.valueOf(budgetRate.getFiscalYear()) <= Integer.valueOf(fiscalYear)) {
                appliedRate = budgetRate;
                continue;
            }
            if (!appliedRate.getFiscalYear().equals(budgetRate.getFiscalYear()) || Integer.valueOf(budgetRate.getFiscalYear()) > Integer.valueOf(fiscalYear)) continue;
            appliedRate = budgetRate;
            break;
        }
        if (appliedRate != null) {
            applicableRate = new ScaleTwoDecimal(appliedRate.getApplicableRate().bigDecimalValue());
        }
        return applicableRate;
    }

    protected BudgetCostShare createBudgetCostShare(Budget.FiscalYearSummary fiscalYearSummary) {
        return new BudgetCostShare(fiscalYearSummary.getFiscalYear(), fiscalYearSummary.getCostShare(), new ScaleTwoDecimal(0.0), null);
    }

    protected BudgetCostShare createBudgetCostShare(int projectPeriod, ScaleTwoDecimal costShare) {
        return new BudgetCostShare(projectPeriod, costShare, new ScaleTwoDecimal(0.0), null);
    }

    protected BudgetUnrecoveredFandA createBudgetUnrecoveredFandA(Budget.FiscalYearSummary fiscalYearSummary, ScaleTwoDecimal applicableRate, String onCampusFlag) {
        return new BudgetUnrecoveredFandA(fiscalYearSummary.getFiscalYear(), ScaleTwoDecimal.ZERO, applicableRate, onCampusFlag, null);
    }
}

