/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.auth.docperm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.docperm.DocumentAccess;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="documentAccessDerivedRoleTypeService")
public class DocumentAccessDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected List<String> requiredAttributes = Collections.singletonList("documentNumber");
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="roleService")
    private RoleService roleService;

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        if (StringUtils.isBlank((CharSequence)namespaceCode)) {
            throw new IllegalArgumentException("namespaceCode was null or blank");
        }
        if (roleName == null) {
            throw new IllegalArgumentException("roleName was null");
        }
        this.validateRequiredAttributesAgainstReceived(qualification);
        String documentNumber = qualification.get("documentNumber");
        if (StringUtils.isNotBlank((CharSequence)documentNumber)) {
            List accesses = this.dataObjectService.findMatching(DocumentAccess.class, QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"documentNumber", (Object)documentNumber), PredicateFactory.equal((String)"roleName", (Object)roleName), PredicateFactory.equal((String)"namespaceCode", (Object)namespaceCode)})).getResults();
            String roleId = this.roleService.getRoleIdByNamespaceCodeAndName(namespaceCode, roleName);
            ArrayList<RoleMembership> memberships = new ArrayList<RoleMembership>();
            if (StringUtils.isNotBlank((CharSequence)roleId)) {
                for (DocumentAccess access : accesses) {
                    memberships.add(RoleMembership.Builder.create((String)roleId, null, (String)access.getPrincipalId(), (MemberType)MemberType.PRINCIPAL, Collections.singletonMap("documentNumber", documentNumber)).build());
                }
            }
            return memberships;
        }
        return Collections.emptyList();
    }

    protected boolean isCheckRequiredAttributes() {
        return false;
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        return true;
    }

    public List<String> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}

