/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.editable;

import java.util.HashMap;
import java.util.Map;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.editable.ProposalColumnsToAlter;
import org.kuali.coeus.sys.framework.persistence.KcPersistenceStructureService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.fieldlevel.DateValidationPattern;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalColumnsToAlterMaintainableImpl
extends KraMaintainableImpl {
    private static Map<String, String> validationClassesMap = new HashMap<String, String>();

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        ProposalColumnsToAlter proposalCol = (ProposalColumnsToAlter)this.businessObject;
        KcPersistenceStructureService persistenceStructureService = KcServiceLocator.getService(KcPersistenceStructureService.class);
        Map<String, String> columnToAttrMap = persistenceStructureService.getDBColumnToObjectAttributeMap(DevelopmentProposal.class);
        DataDictionaryService dataDictionaryService = KcServiceLocator.getService(DataDictionaryService.class);
        AttributeDefinition attrDefinition = dataDictionaryService.getDataDictionary().getBusinessObjectEntry(DevelopmentProposal.class.getName()).getAttributeDefinition(columnToAttrMap.get(proposalCol.getColumnName()));
        if (attrDefinition == null) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.columnName", "error.proposalcolumnstoalter.attributeNotFound", new String[0]);
            return;
        }
        if (attrDefinition.getLabel().length() > 30) {
            proposalCol.setColumnLabel(attrDefinition.getLabel().substring(0, 29));
        } else {
            proposalCol.setColumnLabel(attrDefinition.getLabel());
        }
        proposalCol.setDataLength(attrDefinition.getMaxLength());
        String dataType = null;
        if (attrDefinition.getValidationPattern() != null) {
            String validationPattern = attrDefinition.getValidationPattern().getClass().getName();
            dataType = validationClassesMap.get(validationPattern);
            if (dataType == null) {
                dataType = "STRING";
            }
        } else {
            dataType = "STRING";
        }
        proposalCol.setDataType(dataType);
    }

    static {
        validationClassesMap.put(AnyCharacterValidationPattern.class.getName(), "STRING");
        validationClassesMap.put(AlphaNumericValidationPattern.class.getName(), "STRING");
        validationClassesMap.put(AlphaValidationPattern.class.getName(), "STRING");
        validationClassesMap.put(DateValidationPattern.class.getName(), "DATE");
        validationClassesMap.put(NumericValidationPattern.class.getName(), "NUMBER");
    }
}

