/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.sponsor;

import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.sponsor.AddProposalSponsorAndProgramInformationRule;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;

public class AddProposalSponsorAndProgramInformationRuleImpl
implements AddProposalSponsorAndProgramInformationRule {
    private GlobalVariableService globalVariableService;
    private ErrorReporter errorReporter;

    @Override
    public boolean processAddProposalSponsorAndProgramInformationRules(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        boolean valid = Boolean.TRUE;
        for (int i = 0; i < proposalDevelopmentDocument.getDevelopmentProposal().getProposalCfdas().size(); ++i) {
            String cfdaNumber = proposalDevelopmentDocument.getDevelopmentProposal().getProposalCfdas().get(i).getCfdaNumber();
            if (cfdaNumber.matches("(\\d{2})(\\.)(\\d{3})[a-zA-z]?") || this.getGlobalVariableService().getMessageMap().getMessages(String.format("document.developmentProposalList[0].proposalCfdas[%s].cfdaNumber", i)) != null) continue;
            this.getErrorReporter().reportWarning("developmentProposalList[0].proposalCfdas[%s].cfdaNumber", "error.format.cfda", cfdaNumber);
        }
        return valid;
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        }
        return this.errorReporter;
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }
}

