/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryTypeValuesFinder;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelBudgetService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.impl.struts.BudgetAction;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetPersonnelBudgetAction
extends BudgetAction {
    public ActionForward updatePersonnelBudgetView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("personnelBudget");
    }

    public ActionForward addBudgetPersonnelDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetPersonnelDetails newBudgetPersonnelDetails = budgetForm.getNewBudgetPersonnelDetails();
        boolean errorFound = false;
        if (newBudgetPersonnelDetails.getPercentEffort().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.percentEffort", "error.percentage", new String[]{"Percent Effort"});
            errorFound = true;
        }
        if (newBudgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.percentCharged", "error.percentage", new String[]{"Percent Charged"});
            errorFound = true;
        }
        if (newBudgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)newBudgetPersonnelDetails.getPercentEffort())) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
            errorFound = true;
        }
        if (StringUtils.isBlank((CharSequence)budgetForm.getNewBudgetPersonnelDetails().getPeriodTypeCode())) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.periodTypeCode", "error.required", new String[]{"Period Type (Period Type)"});
            errorFound = true;
        }
        if (budgetForm.getNewBudgetPersonnelDetails().getPersonSequenceNumber() == null) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.personSequenceNumber", "error.required", new String[]{"Person (Person)"});
            errorFound = true;
        }
        HashMap<Integer, String> uniqueBudgetPersonnelCount = new HashMap<Integer, String>();
        int qty = 0;
        if (!errorFound) {
            BudgetPersonnelBudgetService budgetPersonnelBudgetService = KcServiceLocator.getService(BudgetPersonnelBudgetService.class);
            for (BudgetPersonnelDetails budgetPersonnelDetails : budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).getBudgetPersonnelDetailsList()) {
                if (uniqueBudgetPersonnelCount.containsValue(budgetPersonnelDetails.getPersonId())) continue;
                uniqueBudgetPersonnelCount.put(qty, budgetPersonnelDetails.getPersonId());
                ++qty;
            }
            budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).setQuantity(new Integer(qty));
            this.updatePersonnelBudgetRate(budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex));
            this.getCalculationService().calculateBudgetPeriod(budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        ActionForward actionForward = super.reload(mapping, form, request, response);
        BusinessObjectService bos = KcServiceLocator.getService(BusinessObjectService.class);
        Budget budget = budgetForm.getBudget();
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("budgetId", budget.getBudgetId());
        Collection budgetPersons = bos.findMatching(BudgetPerson.class, queryMap);
        budget.setBudgetPersons(budgetPersons == null ? new ArrayList() : (List)budgetPersons);
        BudgetCategoryTypeValuesFinder budgetCategoryTypeValuesFinder = new BudgetCategoryTypeValuesFinder();
        List<Object> budgetCategoryTypes = new ArrayList();
        budgetCategoryTypes = budgetCategoryTypeValuesFinder.getKeyValues();
        for (int i = 0; i < budgetCategoryTypes.size(); ++i) {
            budgetForm.getNewBudgetLineItems().add(budget.getNewBudgetLineItem());
        }
        budget.setBudgetCategoryTypeCodes(budgetCategoryTypes);
        return actionForward;
    }

    public ActionForward deleteBudgetPersonnelDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetPersonnelBudgetService budgetPersonnelBudgetService = KcServiceLocator.getService(BudgetPersonnelBudgetService.class);
        budgetPersonnelBudgetService.deleteBudgetPersonnelDetails(budget, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, this.getLineToDelete(request));
        HashMap<Integer, String> uniqueBudgetPersonnelCount = new HashMap<Integer, String>();
        int qty = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).getBudgetPersonnelDetailsList()) {
            if (uniqueBudgetPersonnelCount.containsValue(budgetPersonnelDetails.getPersonId())) continue;
            uniqueBudgetPersonnelCount.put(qty, budgetPersonnelDetails.getPersonId());
            ++qty;
        }
        budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).setQuantity(new Integer(qty));
        this.getCalculationService().calculateBudgetPeriod(budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
        return mapping.findForward("basic");
    }

    public ActionForward returnToExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        int k = 0;
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        for (BudgetPersonnelDetails budgetPersonnelDetails : selectedBudgetLineItem.getBudgetPersonnelDetailsList()) {
            errorFound = errorFound || this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, k);
            ++k;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        if (errorFound) {
            return mapping.findForward("basic");
        }
        this.getCalculationService().calculateBudgetLineItem(budget, selectedBudgetLineItem);
        BudgetCategoryTypeValuesFinder budgetCategoryTypeValuesFinder = new BudgetCategoryTypeValuesFinder();
        List<Object> budgetCategoryTypes = new ArrayList();
        budgetCategoryTypes = budgetCategoryTypeValuesFinder.getKeyValues();
        for (int i = 0; i < budgetCategoryTypes.size(); ++i) {
            budgetForm.getNewBudgetLineItems().add(budget.getNewBudgetLineItem());
        }
        budget.setBudgetCategoryTypeCodes(budgetCategoryTypes);
        request.setAttribute("fromPersonnelBudget" + budgetForm.getViewBudgetPeriod() + selectedBudgetLineItemIndex, (Object)true);
        return mapping.findForward("expenses");
    }

    public ActionForward calculateLineItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        int k = 0;
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        for (BudgetPersonnelDetails budgetPersonnelDetails : selectedBudgetLineItem.getBudgetPersonnelDetailsList()) {
            if (budgetPersonnelDetails.getPercentEffort().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + k + "].percentEffort", "error.percentage", new String[]{"Percent Effort"});
                errorFound = true;
            }
            if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + k + "].percentCharged", "error.percentage", new String[]{"Percent Charged"});
                errorFound = true;
            }
            if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)budgetPersonnelDetails.getPercentEffort())) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + k + "].percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
                errorFound = true;
            }
            errorFound = errorFound || this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, k);
            ++k;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        if (!errorFound) {
            this.getCalculationService().calculateBudgetLineItem(budget, selectedBudgetLineItem);
        }
        return mapping.findForward("basic");
    }

    public ActionForward calculateSalary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        BudgetPersonnelDetails budgetPersonnelDetails = selectedBudgetLineItem.getBudgetPersonnelDetailsList().get(this.getLineToDelete(request));
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (budgetPersonnelDetails.getPercentEffort().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + this.getLineToDelete(request) + "].percentEffort", "error.percentage", new String[]{"Percent Effort"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + this.getLineToDelete(request) + "].percentCharged", "error.percentage", new String[]{"Percent Charged"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)budgetPersonnelDetails.getPercentEffort())) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + this.getLineToDelete(request) + "].percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
            errorFound = true;
        }
        boolean bl = errorFound = errorFound || this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, this.getLineToDelete(request));
        if (!errorFound) {
            BudgetPersonnelBudgetService budgetPersonnelBudgetService = KcServiceLocator.getService(BudgetPersonnelBudgetService.class);
            budgetPersonnelBudgetService.calculateBudgetPersonnelBudget(budget, selectedBudgetLineItem, budgetPersonnelDetails, this.getLineToDelete(request));
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        int k = 0;
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        for (BudgetPersonnelDetails budgetPersonnelDetails : selectedBudgetLineItem.getBudgetPersonnelDetailsList()) {
            errorFound |= this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, k);
            ++k;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        if (errorFound) {
            this.getCalculationService().calculateBudgetLineItem(budget, selectedBudgetLineItem);
            return mapping.findForward("basic");
        }
        ActionForward actionForward = super.save(mapping, form, request, response);
        selectedBudgetLineItem.setBudgetPersonnelLineItemDeleted(false);
        return actionForward;
    }

    private boolean personnelDatesCheck(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails, int selectedBudgetPeriodIndex, int selectedBudgetLineItemIndex, int detailIndex) {
        boolean errorFound = false;
        if (budgetPersonnelDetails.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.dates", new String[0]);
            errorFound = true;
        }
        if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getEndDate()) < 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.end.date", new String[]{"can not be after", "end date"});
            errorFound = true;
        }
        if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getEndDate()) > 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.end.date", new String[]{"can not be before", "start date"});
            errorFound = true;
        }
        if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getStartDate()) > 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.personnel.detail.start.date", new String[]{"can not be before", "start date"});
            errorFound = true;
        }
        if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.personnel.detail.start.date", new String[]{"can not be after", "end date"});
            errorFound = true;
        }
        return errorFound;
    }

    private void updatePersonnelBudgetRate(BudgetLineItem budgetLineItem) {
        int j = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            j = 0;
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts()) {
                budgetPersonnelCalculatedAmount.setApplyRateFlag(budgetLineItem.getBudgetLineItemCalculatedAmounts().get(j).getApplyRateFlag());
                ++j;
            }
        }
    }
}

