/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.nonpersonnel;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetFormulatedCostDetailContract;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.rate.FormulatedType;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="BUD_FORMULATED_COST_DETAIL")
public class BudgetFormulatedCostDetail
extends KcPersistableBusinessObjectBase
implements BudgetFormulatedCostDetailContract {
    private static final long serialVersionUID = -7218113007594733976L;
    @PortableSequenceGenerator(name="SEQ_BUD_FRMLTD_COST_DETAIL_ID")
    @GeneratedValue(generator="SEQ_BUD_FRMLTD_COST_DETAIL_ID")
    @Id
    @Column(name="BUD_FORMULATED_COST_DETAIL_ID")
    private Long budgetFormulatedCostDetailId;
    @Column(name="FORMULATED_NUMBER")
    private Integer formulatedNumber;
    @Column(name="FORMULATED_TYPE_CODE")
    private String formulatedTypeCode;
    @Column(name="UNIT_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal unitCost;
    @Column(name="COUNT")
    private Integer count;
    @Column(name="FREQUENCY")
    private Integer frequency;
    @Column(name="CALCULATED_EXPENSES")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal calculatedExpenses;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="FORMULATED_TYPE_CODE", referencedColumnName="FORMULATED_TYPE_CODE", insertable=false, updatable=false)
    private FormulatedType formulatedType;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_DETAILS_ID")
    private BudgetLineItem budgetLineItem;
    @Transient
    private transient int budgetLineItemNumber;
    @Transient
    private transient int budgetPeriod;

    public Long getBudgetFormulatedCostDetailId() {
        return this.budgetFormulatedCostDetailId;
    }

    public void setBudgetFormulatedCostDetailId(Long budgetFormulatedCostDetailId) {
        this.budgetFormulatedCostDetailId = budgetFormulatedCostDetailId;
    }

    public Long getBudgetLineItemId() {
        return this.getBudgetLineItem().getBudgetLineItemId();
    }

    public Integer getFormulatedNumber() {
        return this.formulatedNumber;
    }

    public void setFormulatedNumber(Integer formulatedNumber) {
        this.formulatedNumber = formulatedNumber;
    }

    public String getFormulatedTypeCode() {
        return this.formulatedTypeCode;
    }

    public void setFormulatedTypeCode(String formulatedTypeCode) {
        this.formulatedTypeCode = formulatedTypeCode;
    }

    public ScaleTwoDecimal getUnitCost() {
        return this.unitCost == null ? ScaleTwoDecimal.ZERO : this.unitCost;
    }

    public void setUnitCost(ScaleTwoDecimal unitCost) {
        this.unitCost = unitCost;
    }

    public Integer getCount() {
        return this.count == null ? 0 : this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getFrequency() {
        return this.frequency == null ? 0 : this.frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public ScaleTwoDecimal getCalculatedExpenses() {
        return this.calculatedExpenses;
    }

    public void setCalculatedExpenses(ScaleTwoDecimal calculatedExpenses) {
        this.calculatedExpenses = calculatedExpenses;
    }

    public FormulatedType getFormulatedType() {
        return this.formulatedType;
    }

    public void setFormulatedType(FormulatedType formulatedType) {
        this.formulatedType = formulatedType;
    }

    public int getBudgetLineItemNumber() {
        return this.budgetLineItemNumber;
    }

    public void setBudgetLineItemNumber(int budgetLineItemNumber) {
        this.budgetLineItemNumber = budgetLineItemNumber;
    }

    public int getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(int budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public BudgetLineItem getBudgetLineItem() {
        return this.budgetLineItem;
    }

    public void setBudgetLineItem(BudgetLineItem budgetLineItem) {
        this.budgetLineItem = budgetLineItem;
    }
}

