/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.impl.validation.DataValidationItem;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.uif.service.impl.ViewHelperServiceImpl;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class KcViewHelperServiceImpl
extends ViewHelperServiceImpl {
    private static final long serialVersionUID = 3335951799627228900L;
    private static final Logger LOG = LogManager.getLogger(KcViewHelperServiceImpl.class);
    private static final String FEEDBACK_LINK_PARAMETER_NAME = "feedback.link.url";
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    public List<DataValidationItem> populateDataValidation() {
        ArrayList<DataValidationItem> dataValidationItems = new ArrayList<DataValidationItem>();
        for (Map.Entry<String, AuditCluster> entry : this.getGlobalVariableService().getAuditErrorMap().entrySet()) {
            AuditCluster auditCluster = entry.getValue();
            List auditErrors = auditCluster.getAuditErrorList();
            String areaName = StringUtils.substringBefore((String)auditCluster.getLabel(), (String)".");
            String sectionName = StringUtils.substringAfter((String)auditCluster.getLabel(), (String)".");
            for (AuditError auditError : auditErrors) {
                DataValidationItem dataValidationItem = new DataValidationItem();
                String pageId = StringUtils.substringBefore((String)auditError.getLink(), (String)".");
                String sectionId = StringUtils.substringAfter((String)auditError.getLink(), (String)".");
                ErrorMessage errorMessage = new ErrorMessage();
                errorMessage.setErrorKey(auditError.getMessageKey());
                errorMessage.setMessageParameters(auditError.getParams());
                dataValidationItem.setArea(areaName);
                dataValidationItem.setSection(sectionName);
                dataValidationItem.setDescription(KRADUtils.getMessageText((ErrorMessage)errorMessage, (boolean)false));
                dataValidationItem.setSeverity(auditCluster.getCategory());
                dataValidationItem.setNavigateToPageId(pageId);
                dataValidationItem.setNavigateToSectionId(sectionId);
                dataValidationItems.add(dataValidationItem);
            }
        }
        dataValidationItems.sort(Comparator.comparing(DataValidationItem::getArea));
        return dataValidationItems;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public String getErrorCssClass(String severity) {
        if (severity.endsWith("Error")) {
            return "label-danger";
        }
        if (severity.endsWith("Warnings")) {
            return "label-warning";
        }
        return "label-info";
    }

    public String urlEncode(String s) throws UnsupportedEncodingException {
        if (s == null) {
            return "";
        }
        return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public boolean isDataValidationSectionEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "All", "Show_Section_In_Data_Validation");
    }

    public String getHelpLinkFromParameter(String parameterName) {
        String link = this.getParameterService().getParameterValueAsString(this.getParameterClass(), parameterName);
        String relativeLink = String.format("%s/%s", this.getConfigurationService().getPropertyValueAsString("application.url"), link);
        if (new UrlValidator().isValid(link)) {
            return link;
        }
        if (new UrlValidator(2L).isValid(relativeLink)) {
            return relativeLink;
        }
        LOG.warn(String.format("Help link \"%s\" for parameter \"%s\" does not exist or is not a valid URL", link, parameterName));
        String feedbackLink = this.getParameterService().getParameterValueAsString("KC-GEN", "All", FEEDBACK_LINK_PARAMETER_NAME);
        return StringUtils.isNotBlank((CharSequence)feedbackLink) ? feedbackLink : this.getConfigurationService().getPropertyValueAsString(FEEDBACK_LINK_PARAMETER_NAME);
    }

    protected abstract Class<?> getParameterClass();
}

