/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.connect.OpportunitySchemaParserService;
import org.kuali.coeus.propdev.impl.s2s.connect.S2sCommunicationException;
import org.kuali.coeus.sys.framework.keyvalue.FormViewAwareUifKeyValuesFinderBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class S2sComponentTypeValuesFinder
extends FormViewAwareUifKeyValuesFinderBase {
    private transient ProposalHierarchyService proposalHierarchyService;
    private transient OpportunitySchemaParserService opportunitySchemaParserService;

    public List<KeyValue> getKeyValues() {
        try {
            return Optional.of((ProposalDevelopmentDocument)this.getDocument()).filter(document -> document.getDevelopmentProposal().isChild()).map(childDocument -> this.getProposalHierarchyService().getParentDocument((ProposalDevelopmentDocument)childDocument)).map(parentDocument -> parentDocument.getDevelopmentProposal().getS2sOpportunity()).map(S2sOpportunity::getOpportunity).map(schema -> this.getOpportunitySchemaParserService().getAvailableComponentTypes((String)schema)).map(componentTypes -> componentTypes.stream().filter(compnentType -> !"Overall".equalsIgnoreCase((String)compnentType)).map(componentType -> new ConcreteKeyValue(componentType, componentType)).collect(Collectors.toList())).orElseGet(() -> Collections.emptyList());
        }
        catch (S2sCommunicationException e) {
            return Collections.emptyList();
        }
    }

    private OpportunitySchemaParserService getOpportunitySchemaParserService() {
        if (this.opportunitySchemaParserService == null) {
            this.opportunitySchemaParserService = KcServiceLocator.getService(OpportunitySchemaParserService.class);
        }
        return this.opportunitySchemaParserService;
    }

    private ProposalHierarchyService getProposalHierarchyService() {
        if (this.proposalHierarchyService == null) {
            this.proposalHierarchyService = KcServiceLocator.getService(ProposalHierarchyService.class);
        }
        return this.proposalHierarchyService;
    }
}

