/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.workflow;

import java.util.Arrays;
import java.util.List;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.rice.core.framework.persistence.platform.MySQLDatabasePlatform;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.stereotype.Repository;

@Repository(value="kewDocHeaderDao")
public class KewDocHeaderDaoImpl
extends LookupDaoOjb
implements KewDocHeaderDao {
    private static final List<String> INDEXABLE_DOC_TYPES = Arrays.asList("ProposalDevelopmentDocument", "InstitutionalProposalDocument", "AwardDocument", "SubAwardDocument", "NegotiationDocument");
    private static final String ALL_DOCUMENT_IDS_QUERY = "select doc_hdr_id from krew_doc_hdr_t where doc_typ_id in (select doc_typ_id from krew_doc_typ_t where doc_typ_nm in ('" + String.join((CharSequence)"', '", INDEXABLE_DOC_TYPES) + "'))and doc_hdr_stat_cd not in ('I', 'D', 'X') order by crte_dt desc";
    private static final String PAGED_DOCUMENT_IDS_QUERY_ORACLE = "select doc_hdr_id from (select doc_hdr_id, crte_dt, row_number() over (order by crte_dt desc) rn from krew_doc_hdr_t where doc_typ_id in (select doc_typ_id from krew_doc_typ_t where doc_typ_nm in ('" + String.join((CharSequence)"', '", INDEXABLE_DOC_TYPES) + "')) and doc_hdr_stat_cd not in ('I', 'D', 'X')) where rn between %d and %d order by crte_dt desc";
    @Autowired
    @Qualifier(value="riceJdbcOperations")
    private JdbcOperations jdbcOperations;

    @Override
    public List<String> getAllDocumentIds() {
        return this.getAllDocumentIds(null, null);
    }

    @Override
    public List<String> getAllDocumentIds(Integer limit, Integer skip) {
        String pagedQuery = this.getPagedAllDocumentIdsQuery(limit, skip);
        return this.jdbcOperations.query(c -> c.prepareStatement(pagedQuery), (rs, rowNum) -> rs.getString(1));
    }

    private String getPagedAllDocumentIdsQuery(Integer limit, Integer skip) {
        int start;
        String sql = ALL_DOCUMENT_IDS_QUERY;
        if (skip == null || skip <= 0) {
            skip = 0;
        }
        int n = start = skip == 0 ? skip : skip + 1;
        if (limit != null && limit >= 0) {
            if (this.getDbPlatform() instanceof MySQLDatabasePlatform) {
                return String.format("%s LIMIT %d,%d", sql, skip, limit);
            }
            return String.format(PAGED_DOCUMENT_IDS_QUERY_ORACLE, start, skip + limit);
        }
        return sql;
    }
}

