/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.service.AwardCommentService;
import org.kuali.kra.bo.CommentType;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AwardCommentServiceImpl
implements AwardCommentService {
    private static final String AWARD_COMMENT_SCREEN_FLAG = "awardCommentScreenFlag";
    private static final String AWARD_COMMENT_TYPE_CODE = "commentTypeCode";
    private static final String AWARD_ID = "awardId";
    private BusinessObjectService businessObjectService;

    @Override
    public List<CommentType> retrieveCommentTypes() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(AWARD_COMMENT_SCREEN_FLAG, "Y");
        return (List)this.getBusinessObjectService().findMatching(CommentType.class, queryMap);
    }

    @Override
    public List<String> retrieveCommentHistoryFlags(String awardNumber) {
        String tempCode;
        this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("awardNumber", awardNumber);
        List rawList = (List)this.getBusinessObjectService().findMatching(AwardComment.class, queryMap);
        HashMap<String, List> rawMap = new HashMap<String, List>();
        for (AwardComment awardComment : rawList) {
            tempCode = awardComment.getCommentTypeCode();
            List commentList = rawMap.computeIfAbsent(tempCode, k -> new ArrayList());
            if (commentList.size() != 0 && awardComment.sameText((AwardComment)commentList.get(commentList.size() - 1))) continue;
            commentList.add(awardComment);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        Iterator iterator = rawMap.keySet().iterator();
        block1: while (iterator.hasNext()) {
            String s;
            tempCode = s = (String)iterator.next();
            List awardCommentList = (List)rawMap.get(tempCode);
            String lastComment = null;
            for (AwardComment awardComment : awardCommentList) {
                String tempComment = awardComment.getComments();
                if (awardComment.isDisabled()) continue;
                if (awardComment.isEntered() && !awardComment.isDisabled()) {
                    if (lastComment == null) {
                        lastComment = awardComment.getComments();
                    } else if (!lastComment.equals(tempComment) && !resultList.contains(tempComment)) {
                        resultList.add(tempCode);
                        continue block1;
                    }
                } else if (lastComment != null && !resultList.contains(tempComment)) {
                    resultList.add(tempCode);
                    continue block1;
                }
                lastComment = awardComment.isEntered() ? tempComment : null;
            }
        }
        return resultList;
    }

    @Override
    public List<AwardComment> retrieveCommentHistoryByType(String awardCommentTypeCode, String awardId) {
        Award award = this.getAward(awardId);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(AWARD_COMMENT_TYPE_CODE, awardCommentTypeCode);
        queryMap.put("awardNumber", award.getAwardNumber());
        return this.filterAwardComment((List)this.getBusinessObjectService().findMatching(AwardComment.class, queryMap), award.getAwardNumber(), award.getSequenceNumber());
    }

    protected Award getAward(String awardId) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(AWARD_ID, awardId);
        return (Award)this.getBusinessObjectService().findByPrimaryKey(Award.class, queryMap);
    }

    protected List<AwardComment> filterAwardComment(List<AwardComment> results, String awardNumber, Integer sequenceNum) {
        ArrayList<AwardComment> returnList = new ArrayList<AwardComment>();
        ArrayList<String> comments = new ArrayList<String>();
        for (AwardComment awardComment : results) {
            if (sequenceNum < awardComment.getSequenceNumber() || !awardComment.isEntered() || awardComment.isDisabled() || !comments.isEmpty() && awardComment.getComments().equals(comments.get(comments.size() - 1))) continue;
            returnList.add(awardComment);
            comments.add(awardComment.getComments());
        }
        Collections.sort(returnList);
        return returnList;
    }

    public void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }
}

