/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.common.web.struts.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.print.CurrentReportBean;
import org.kuali.coeus.common.framework.print.PendingReportBean;
import org.kuali.coeus.common.framework.print.ReportBean;
import org.kuali.coeus.common.proposal.framework.report.CurrentAndPendingReportService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ReportHelperBean
implements Serializable {
    private KualiDocumentFormBase form;
    private String personId;
    private KcPerson targetPerson;
    private boolean institutionalProposalExists;
    private String proposalNumber;
    private static final String DEV_PROPOSAL_NUMBER_FIELD_NAME = "devProposalNumber";
    protected static final String PROP_NUMBER = "proposalNumber";
    public static final String PROP_SEQ_STATUS = "ACTIVE";
    public static final int PROP_PENDING_STATUS = 1;

    public ReportHelperBean(KualiDocumentFormBase form) {
        this.form = form;
        this.setTargetPerson(new KcPerson());
        if (form.getDocument() instanceof InstitutionalProposalDocument) {
            this.institutionalProposalExists = true;
            this.proposalNumber = this.findProposalNumberFromInstitutionalProposal();
        } else if (form.getDocument() instanceof ProposalDevelopmentDocument) {
            this.institutionalProposalExists = this.doesInstitutionalProposalExistForProposalNumber();
            this.proposalNumber = this.findProposalNumberFromDevelopmentProposal();
        }
    }

    public ReportHelperBean() {
        this.setTargetPerson(new KcPerson());
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public KcPerson getTargetPerson() {
        return this.targetPerson;
    }

    public boolean isInstituteProposalAvailable() {
        return this.institutionalProposalExists;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
        if (personId != null) {
            this.targetPerson = this.getKcPersonService().getKcPersonByPersonId(personId);
        }
    }

    public void setTargetPerson(KcPerson targetPerson) {
        this.targetPerson = targetPerson;
    }

    public List<ResultRow> prepareCurrentReport() {
        return new CurrentReportHelperBean().prepareCurrentReport();
    }

    public List<ResultRow> preparePendingReport() {
        return new PendingReportHelperBean().preparePendingReport();
    }

    public String getTargetPersonName() {
        return this.targetPerson.getFullName();
    }

    protected boolean doesInstitutionalProposalExistForProposalNumber() {
        Map<String, String> map = Collections.singletonMap(DEV_PROPOSAL_NUMBER_FIELD_NAME, this.findProposalNumberFromDevelopmentProposal());
        return this.getBusinessObjectService().findMatching(ProposalAdminDetails.class, map).stream().anyMatch(adminDetails -> adminDetails.getInstProposalId() != null);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    protected KcPersonService getKcPersonService() {
        return KcServiceLocator.getService(KcPersonService.class);
    }

    protected CurrentAndPendingReportService getCurrentAndPendingReportService() {
        return KcServiceLocator.getService(CurrentAndPendingReportService.class);
    }

    private String findProposalNumberFromDevelopmentProposal() {
        return ((ProposalDevelopmentDocument)this.form.getDocument()).getDevelopmentProposal().getProposalNumber();
    }

    private String findProposalNumberFromInstitutionalProposal() {
        return ((InstitutionalProposalDocument)this.form.getDocument()).getInstitutionalProposal().getProposalNumber();
    }

    private class CurrentReportHelperBean
    implements Serializable {
        private CurrentReportHelperBean() {
        }

        public List<ResultRow> prepareCurrentReport() {
            ArrayList<ResultRow> resultRows = new ArrayList<ResultRow>();
            for (CurrentReportBean bean : this.loadReportData()) {
                resultRows.add(bean.createResultRow());
            }
            return resultRows;
        }

        private List<CurrentReportBean> loadReportData() {
            return ReportHelperBean.this.getCurrentAndPendingReportService().loadCurrentReportData(ReportHelperBean.this.personId);
        }
    }

    private class PendingReportHelperBean
    implements Serializable {
        private PendingReportHelperBean() {
        }

        public List<ResultRow> preparePendingReport() {
            return this.loadReportData().stream().map(ReportBean::createResultRow).collect(Collectors.toList());
        }

        private List<PendingReportBean> loadReportData() {
            return ReportHelperBean.this.getCurrentAndPendingReportService().loadPendingReportData(ReportHelperBean.this.personId);
        }
    }
}

