/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.framework.version.history.VersionHistorySearchBo;
import org.kuali.coeus.common.framework.version.sequence.owner.SequenceOwner;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.project.ExconProjectAssociatedDocument;
import org.kuali.kra.excon.project.ExconProjectAttachment;
import org.kuali.kra.excon.project.ExconProjectComment;
import org.kuali.kra.excon.project.ExconProjectDestination;
import org.kuali.kra.excon.project.ExconProjectEvent;
import org.kuali.kra.excon.project.ExconProjectExternalInstitution;
import org.kuali.kra.excon.project.ExconProjectPerson;
import org.kuali.kra.excon.project.ExconProjectRPSEntity;
import org.kuali.kra.excon.project.ExconProjectRPSResult;
import org.kuali.kra.excon.project.ExconProjectRestrictedUnit;
import org.kuali.kra.excon.project.ExconProjectReview;
import org.kuali.kra.excon.project.ExconProjectStatusType;
import org.kuali.kra.excon.project.ExconProjectTravelerCommunication;
import org.kuali.kra.excon.project.ExconProjectType;
import org.kuali.kra.excon.project.ExconProjectUnitPerson;
import org.kuali.kra.excon.project.customdata.ExconProjectCustomData;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ExconProject
extends KcPersistableBusinessObjectBase
implements Permissionable,
SequenceOwner<ExconProject> {
    private static final long serialVersionUID = 18919289567474574L;
    public static final String NOTIFICATION_TYPE_SUBMIT = "501";
    public static String EXCON_SEQUENCE_STATUS_PROPERTY_STRING = "exconProjectSequenceStatus";
    private Long projectId;
    private String projectNumber;
    private String documentNumber;
    private ExconProjectDocument exconProjectDocument;
    private String title;
    private String projectTypeCode;
    private ExconProjectType projectType;
    private String unitNumber;
    private String unitName;
    private Unit unit;
    private String sponsorCode;
    private String sponsorName;
    private Sponsor sponsor;
    private Boolean fundamentalResearch;
    private Boolean internationalResearch;
    private Boolean classifiedResearch;
    private Boolean restrictedResearch;
    private Date projectStartDate;
    private Date projectEndDate;
    private String projectStatusCode = "DON";
    private String projectStatusDescription;
    private ExconProjectStatusType projectStatus;
    private String exconProjectSequenceStatus;
    private String documentStatus;
    private List<ExconProjectTravelerCommunication> travelerCommunications;
    private List<ExconProjectRPSEntity> exconProjectRPSEntities;
    private List<ExconProjectRPSResult> exconProjectRPSResults;
    private List<ExconProjectPerson> exconProjectPersons;
    private List<ExconProjectUnitPerson> exconProjectUnitPersons;
    private List<ExconProjectEvent> exconProjectEvents;
    private List<ExconProjectDestination> exconProjectDestinations;
    private List<ExconProjectComment> exconProjectComments;
    private List<ExconProjectAttachment> exconProjectAttachments;
    private List<ExconProjectCustomData> exconProjectCustomDataList;
    private List<ExconProjectExternalInstitution> exconProjectExternalInstitutions;
    private List<ExconProjectReview> exconProjectReviews;
    private List<ExconProjectAssociatedDocument> exconProjectAssociatedDocuments;
    private Integer sequenceNumber;
    private boolean allowUpdateTimestampToBeReset = true;
    private String agreementRole;
    private String responsibleParty;
    private String respPartyUsername;
    private String respPartyFullname;
    private transient VersionHistorySearchBo versionHistory;
    private transient KcPersonService kcPersonService;
    private transient UnitService unitService;
    private transient BusinessObjectService businessObjectService;
    private transient SystemAuthorizationService systemAuthorizationService;

    public ExconProjectType getProjectType() {
        if (!StringUtils.isEmpty((CharSequence)this.projectTypeCode)) {
            this.refreshReferenceObject("projectType");
        }
        return this.projectType;
    }

    public void setProjectType(ExconProjectType projectType) {
        this.projectType = projectType;
    }

    public Unit getUnit() {
        if (!StringUtils.isEmpty((CharSequence)this.unitNumber)) {
            this.refreshReferenceObject("unit");
        }
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Sponsor getSponsor() {
        if (!StringUtils.isEmpty((CharSequence)this.sponsorCode)) {
            this.refreshReferenceObject("sponsor");
        }
        return this.sponsor;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
    }

    public ExconProjectStatusType getProjectStatus() {
        if (!StringUtils.isEmpty((CharSequence)this.projectStatusCode)) {
            this.refreshReferenceObject("projectStatus");
        }
        return this.projectStatus;
    }

    public void setProjectStatus(ExconProjectStatusType projectStatus) {
        this.projectStatus = projectStatus;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public ExconProjectDocument getExconProjectDocument() {
        if (this.exconProjectDocument == null) {
            this.refreshReferenceObject("exconProjectDocument");
        }
        return this.exconProjectDocument;
    }

    public String getExconProjectDocumentUrl() {
        return this.getExconProjectDocument().buildForwardUrl();
    }

    public void setExconProjectDocument(ExconProjectDocument exconProjectDocument) {
        this.exconProjectDocument = exconProjectDocument;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getProjectTypeCode() {
        return this.projectTypeCode;
    }

    public void setProjectTypeCode(String projectTypeCode) {
        this.projectTypeCode = projectTypeCode;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Boolean getFundamentalResearch() {
        return this.fundamentalResearch;
    }

    public void setFundamentalResearch(Boolean fundamentalResearch) {
        this.fundamentalResearch = fundamentalResearch;
    }

    public Boolean getInternationalResearch() {
        return this.internationalResearch;
    }

    public void setInternationalResearch(Boolean internationalResearch) {
        this.internationalResearch = internationalResearch;
    }

    public Boolean getClassifiedResearch() {
        return this.classifiedResearch;
    }

    public void setClassifiedResearch(Boolean classifiedResearch) {
        this.classifiedResearch = classifiedResearch;
    }

    public Boolean getRestrictedResearch() {
        return this.restrictedResearch;
    }

    public void setRestrictedResearch(Boolean restrictedResearch) {
        this.restrictedResearch = restrictedResearch;
    }

    public Date getProjectStartDate() {
        return this.projectStartDate;
    }

    public String getProjectStartDateStr() {
        return ExconProject.formattedDate(this.getProjectStartDate());
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    public Date getProjectEndDate() {
        return this.projectEndDate;
    }

    public String getProjectEndDateStr() {
        return ExconProject.formattedDate(this.getProjectEndDate());
    }

    public void setProjectEndDate(Date projectEndDate) {
        this.projectEndDate = projectEndDate;
    }

    public String getProjectStatusCode() {
        return this.projectStatusCode;
    }

    public void setProjectStatusCode(String projectStatusCode) {
        this.projectStatusCode = projectStatusCode;
    }

    public String getProjectStatusDescription() {
        return this.projectStatusDescription;
    }

    public void setProjectStatusDescription(String projectStatusDescription) {
        this.projectStatusDescription = projectStatusDescription;
    }

    public List<ExconProjectPerson> getExconProjectPersons() {
        if (this.exconProjectPersons == null) {
            this.exconProjectPersons = new ArrayList<ExconProjectPerson>();
        }
        return this.exconProjectPersons;
    }

    public void setExconProjectPersons(List<ExconProjectPerson> exconProjectPersons) {
        this.exconProjectPersons = exconProjectPersons;
    }

    public List<ExconProjectRPSEntity> getExconProjectRPSEntities() {
        if (this.exconProjectRPSEntities == null) {
            this.exconProjectRPSEntities = new ArrayList<ExconProjectRPSEntity>();
        }
        return this.exconProjectRPSEntities;
    }

    public void setExconProjectRPSEntities(List<ExconProjectRPSEntity> exconProjectRPSEntities) {
        this.exconProjectRPSEntities = exconProjectRPSEntities;
    }

    public ExconProjectRPSEntity getRpsEntity() {
        if (!this.getExconProjectRPSEntities().isEmpty()) {
            return this.getExconProjectRPSEntities().get(0);
        }
        return null;
    }

    public List<ExconProjectRPSResult> getExconProjectRPSResults() {
        if (this.exconProjectRPSResults == null) {
            this.exconProjectRPSResults = new ArrayList<ExconProjectRPSResult>();
        }
        return this.exconProjectRPSResults;
    }

    public void setExconProjectRPSResults(List<ExconProjectRPSResult> exconProjectRPSResults) {
        this.exconProjectRPSResults = exconProjectRPSResults;
    }

    public List<ExconProjectUnitPerson> getExconProjectUnitPersons() {
        if (this.exconProjectUnitPersons == null) {
            this.exconProjectUnitPersons = new ArrayList<ExconProjectUnitPerson>();
        }
        return this.exconProjectUnitPersons;
    }

    public void setExconProjectUnitPersons(List<ExconProjectUnitPerson> exconProjectUnitPersons) {
        this.exconProjectUnitPersons = exconProjectUnitPersons;
    }

    public List<ExconProjectEvent> getExconProjectEvents() {
        if (this.exconProjectEvents == null) {
            this.exconProjectEvents = new ArrayList<ExconProjectEvent>();
        }
        return this.exconProjectEvents;
    }

    public void setExconProjectEvents(List<ExconProjectEvent> exconProjectEvents) {
        this.exconProjectEvents = exconProjectEvents;
    }

    public List<ExconProjectDestination> getExconProjectDestinations() {
        if (this.exconProjectDestinations == null) {
            this.exconProjectDestinations = new ArrayList<ExconProjectDestination>();
        }
        return this.exconProjectDestinations;
    }

    public void setExconProjectDestinations(List<ExconProjectDestination> exconProjectDestinations) {
        this.exconProjectDestinations = exconProjectDestinations;
    }

    public List<ExconProjectComment> getExconProjectComments() {
        if (this.exconProjectComments == null) {
            this.exconProjectComments = new ArrayList<ExconProjectComment>();
        }
        return this.exconProjectComments;
    }

    public void setExconProjectComments(List<ExconProjectComment> exconProjectComments) {
        this.exconProjectComments = exconProjectComments;
    }

    public List<ExconProjectExternalInstitution> getExconProjectExternalInstitutions() {
        if (this.exconProjectExternalInstitutions == null) {
            this.exconProjectExternalInstitutions = new ArrayList<ExconProjectExternalInstitution>();
        }
        return this.exconProjectExternalInstitutions;
    }

    public void setExconProjectExternalInstitutions(List<ExconProjectExternalInstitution> exconProjectExternalInstitutions) {
        this.exconProjectExternalInstitutions = exconProjectExternalInstitutions;
    }

    public List<ExconProjectReview> getExconProjectReviews() {
        if (this.exconProjectReviews == null) {
            this.exconProjectReviews = new ArrayList<ExconProjectReview>();
        }
        return this.exconProjectReviews;
    }

    public void setExconProjectReviews(List<ExconProjectReview> exconProjectReviews) {
        this.exconProjectReviews = exconProjectReviews;
    }

    public List<ExconProjectAssociatedDocument> getExconProjectAssociatedDocuments() {
        if (this.exconProjectAssociatedDocuments == null) {
            this.exconProjectAssociatedDocuments = new ArrayList<ExconProjectAssociatedDocument>();
        }
        return this.exconProjectAssociatedDocuments;
    }

    public void setExconProjectAssociatedDocuments(List<ExconProjectAssociatedDocument> exconProjectAssociatedDocuments) {
        this.exconProjectAssociatedDocuments = exconProjectAssociatedDocuments;
    }

    public ExconProjectPerson getTraveler() {
        ExconProjectPerson traveler = null;
        for (ExconProjectPerson person : this.getExconProjectPersons()) {
            if (!"TVR".equals(person.getRoleTypeCode())) continue;
            traveler = person;
        }
        return traveler;
    }

    public List<ExconProjectTravelerCommunication> getTravelerCommunications() {
        ExconProjectPerson traveler = this.getTraveler();
        this.travelerCommunications = traveler != null ? traveler.getTravelerCommunications() : new AutoPopulatingList(ExconProjectTravelerCommunication.class);
        return this.travelerCommunications;
    }

    public String getSponsorCode() {
        return this.sponsorCode;
    }

    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public void setSponsorName(String sponsorName) {
        this.sponsorName = sponsorName;
    }

    public String getAgreementRole() {
        return this.agreementRole;
    }

    public void setAgreementRole(String agreementRole) {
        this.agreementRole = agreementRole;
    }

    public String getResponsibleParty() {
        return this.responsibleParty;
    }

    public void setResponsibleParty(String responsibleParty) {
        this.responsibleParty = responsibleParty;
        if (responsibleParty == null) {
            this.respPartyUsername = null;
        }
    }

    public String getRespPartyUsername() {
        return this.respPartyUsername;
    }

    public void setRespPartyUsername(String respPartyUsername) {
        this.respPartyUsername = respPartyUsername;
        if (respPartyUsername == null) {
            this.responsibleParty = null;
        }
    }

    public String getRespPartyFullname() {
        return this.respPartyFullname;
    }

    public void setRespPartyFullname(String respPartyFullname) {
        this.respPartyFullname = respPartyFullname;
    }

    public KcPerson getRespPartyPerson() {
        KcPerson person = null;
        if (this.respPartyUsername != null) {
            person = this.getKcPersonService().getKcPersonByUserName(this.respPartyUsername);
            if (person != null) {
                this.responsibleParty = person.getPersonId();
            }
        } else if (this.responsibleParty != null && (person = this.getKcPersonService().getKcPersonByPersonId(this.responsibleParty)) != null) {
            this.respPartyUsername = person.getUserName();
        }
        return person;
    }

    public List<ExconProjectAttachment> getExconProjectAttachments() {
        if (this.exconProjectAttachments == null) {
            this.exconProjectAttachments = new ArrayList<ExconProjectAttachment>();
        }
        return this.exconProjectAttachments;
    }

    public void setExconProjectAttachments(List<ExconProjectAttachment> exconProjectAttachments) {
        this.exconProjectAttachments = exconProjectAttachments;
    }

    public List<ExconProjectCustomData> getExconProjectCustomDataList() {
        if (this.exconProjectCustomDataList == null) {
            this.exconProjectCustomDataList = new ArrayList<ExconProjectCustomData>();
        }
        return this.exconProjectCustomDataList;
    }

    public void setExconProjectCustomDataList(List<ExconProjectCustomData> exconProjectCustomDataList) {
        this.exconProjectCustomDataList = exconProjectCustomDataList;
    }

    public void add(ExconProjectEvent newExconProjectEvent) {
        this.exconProjectEvents.add(newExconProjectEvent);
        newExconProjectEvent.setExconProject(this);
    }

    public void add(ExconProjectDestination newExconProjectDestination) {
        this.exconProjectDestinations.add(newExconProjectDestination);
        newExconProjectDestination.setExconProject(this);
    }

    public void add(ExconProjectPerson newExconProjectPerson) {
        this.exconProjectPersons.add(newExconProjectPerson);
        newExconProjectPerson.setExconProject(this);
    }

    public void add(ExconProjectUnitPerson newExconProjectUnitPerson) {
        this.exconProjectUnitPersons.add(newExconProjectUnitPerson);
        newExconProjectUnitPerson.setExconProject(this);
    }

    public void add(ExconProjectRPSEntity newExconProjectRPSEntity) {
        this.exconProjectRPSEntities.add(newExconProjectRPSEntity);
        newExconProjectRPSEntity.setExconProject(this);
        newExconProjectRPSEntity.setConcatNames(newExconProjectRPSEntity.getFirstName() + " " + newExconProjectRPSEntity.getOtherNames() + " " + newExconProjectRPSEntity.getLastName() + " " + newExconProjectRPSEntity.getCompanyName());
    }

    public void add(ExconProjectRPSResult newExconProjectRPSResult) {
        this.exconProjectRPSResults.add(newExconProjectRPSResult);
        newExconProjectRPSResult.setExconProject(this);
        newExconProjectRPSResult.setSearchingUser(GlobalVariables.getUserSession().getPrincipalName());
        newExconProjectRPSResult.setRpsSearchDate(new Date(System.currentTimeMillis()));
    }

    public void deleteRPSEntity() {
        if (this.exconProjectRPSEntities != null && !this.exconProjectRPSEntities.isEmpty()) {
            this.exconProjectRPSEntities.remove(0);
        }
    }

    public void add(ExconProjectComment newExconProjectComment) {
        this.exconProjectComments.add(newExconProjectComment);
        newExconProjectComment.setExconProject(this);
        newExconProjectComment.setCommentAuthor(GlobalVariables.getUserSession().getPrincipalName());
        newExconProjectComment.setCommentDate(new Date(System.currentTimeMillis()));
    }

    public void add(ExconProjectAttachment newExconProjectAttachment) {
        this.exconProjectAttachments.add(newExconProjectAttachment);
        newExconProjectAttachment.setExconProject(this);
        newExconProjectAttachment.setAttachUser(GlobalVariables.getUserSession().getPrincipalName());
        newExconProjectAttachment.setAttachDate(new Date(System.currentTimeMillis()));
    }

    public void add(ExconProjectExternalInstitution newExconProjectExternalInstitution) {
        this.exconProjectExternalInstitutions.add(newExconProjectExternalInstitution);
        newExconProjectExternalInstitution.setExconProject(this);
    }

    public void add(ExconProjectReview newExconProjectReview) {
        this.exconProjectReviews.add(newExconProjectReview);
        newExconProjectReview.setExconProject(this);
    }

    public void add(ExconProjectAssociatedDocument newExconProjectAssociatedDocument) {
        this.exconProjectAssociatedDocuments.add(newExconProjectAssociatedDocument);
        newExconProjectAssociatedDocument.setExconProject(this);
    }

    public VersionHistorySearchBo getVersionHistory() {
        return this.versionHistory;
    }

    public void setVersionHistory(VersionHistorySearchBo versionHistory) {
        this.versionHistory = versionHistory;
    }

    public String getDocumentStatus() {
        return this.documentStatus;
    }

    public void setDocumentStatus(String documentStatus) {
        this.documentStatus = documentStatus;
    }

    public ExconProject() {
        this.initializeCollections();
        this.initialize();
    }

    protected void initialize() {
        this.setProjectNumber("000000");
        this.setSequenceNumber(1);
    }

    protected void initializeCollections() {
        this.exconProjectPersons = new AutoPopulatingList(ExconProjectPerson.class);
        this.exconProjectUnitPersons = new AutoPopulatingList(ExconProjectUnitPerson.class);
        this.exconProjectRPSEntities = new AutoPopulatingList(ExconProjectRPSEntity.class);
        this.exconProjectRPSResults = new AutoPopulatingList(ExconProjectRPSResult.class);
        this.exconProjectEvents = new AutoPopulatingList(ExconProjectEvent.class);
        this.exconProjectDestinations = new AutoPopulatingList(ExconProjectDestination.class);
        this.exconProjectComments = new AutoPopulatingList(ExconProjectComment.class);
        this.exconProjectAttachments = new AutoPopulatingList(ExconProjectAttachment.class);
        this.exconProjectCustomDataList = new AutoPopulatingList(ExconProjectCustomData.class);
        this.exconProjectExternalInstitutions = new AutoPopulatingList(ExconProjectExternalInstitution.class);
        this.exconProjectReviews = new AutoPopulatingList(ExconProjectReview.class);
        this.exconProjectAssociatedDocuments = new AutoPopulatingList(ExconProjectAssociatedDocument.class);
    }

    public boolean isLeadUnitRestricted() {
        if (StringUtils.isEmpty((CharSequence)this.unitNumber)) {
            return false;
        }
        return this.isUnitRestricted(this.unitNumber);
    }

    public boolean isUnitRestricted(String unitNumber) {
        Collection restrictedUnits = this.getBusinessObjectService().findAll(ExconProjectRestrictedUnit.class);
        for (Unit unit : this.getUnitService().getUnitHierarchyForUnit(unitNumber)) {
            for (ExconProjectRestrictedUnit restrictedUnit : restrictedUnits) {
                if (!restrictedUnit.getUnitNumber().equals(unit.getUnitNumber())) continue;
                return true;
            }
        }
        return false;
    }

    public static String formattedDate(Date inDate) {
        String outStr = "";
        if (inDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
            outStr = sdf.format(inDate);
        }
        return outStr;
    }

    @Override
    public String getDocumentKey() {
        return "ExconProjectDocument";
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.projectId != null ? this.projectId.toString() : "";
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-EXCON";
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getUnitNumber();
    }

    @Override
    public String getNamespace() {
        return "KC-EXCON";
    }

    @Override
    public List<String> getRoleNames() {
        ArrayList<String> roles = new ArrayList<String>();
        List<Role> roleBOs = this.getSystemAuthorizationService().getRoles(this.getNamespace());
        for (Role role : roleBOs) {
            roles.add(role.getName());
        }
        return roles;
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        String documentNumber = this.getExconProjectDocument() != null ? this.getExconProjectDocument().getDocumentNumber() : "";
        qualifiedRoleAttributes.put("documentNumber", documentNumber);
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public Integer getOwnerSequenceNumber() {
        return null;
    }

    @Override
    public void incrementSequenceNumber() {
        Integer n = this.sequenceNumber;
        Integer n2 = this.sequenceNumber = Integer.valueOf(this.sequenceNumber + 1);
    }

    @Override
    public ExconProject getSequenceOwner() {
        return this;
    }

    @Override
    public void setSequenceOwner(ExconProject newOwner) {
    }

    @Override
    public void resetPersistenceState() {
        this.projectId = null;
    }

    @Override
    public String getVersionNameField() {
        return "projectNumber";
    }

    @Override
    public String getVersionNameFieldValue() {
        return this.getProjectNumber();
    }

    public void setExconProjectSequenceStatus(String exconProjectSequenceStatus) {
        this.exconProjectSequenceStatus = exconProjectSequenceStatus;
    }

    public String getExconProjectSequenceStatus() {
        return this.exconProjectSequenceStatus;
    }

    public boolean isAllowUpdateTimestampToBeReset() {
        return this.allowUpdateTimestampToBeReset;
    }

    public void setAllowUpdateTimestampToBeReset(boolean allowUpdateTimestampToBeReset) {
        this.allowUpdateTimestampToBeReset = allowUpdateTimestampToBeReset;
    }

    public void setTravelerCommunications(List<ExconProjectTravelerCommunication> travelerCommunications) {
        this.travelerCommunications = travelerCommunications;
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        if (this.isAllowUpdateTimestampToBeReset()) {
            super.setUpdateTimestamp(updateTimestamp);
        } else {
            this.setAllowUpdateTimestampToBeReset(true);
        }
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getExconProjectPersons());
        managedLists.add(this.getExconProjectUnitPersons());
        managedLists.add(this.getExconProjectRPSEntities());
        managedLists.add(this.getExconProjectRPSResults());
        managedLists.add(this.getExconProjectEvents());
        managedLists.add(this.getExconProjectDestinations());
        managedLists.add(this.getExconProjectComments());
        managedLists.add(this.getExconProjectAttachments());
        managedLists.add(this.getExconProjectExternalInstitutions());
        managedLists.add(this.getExconProjectReviews());
        managedLists.add(this.getExconProjectAssociatedDocuments());
        return managedLists;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public SystemAuthorizationService getSystemAuthorizationService() {
        if (this.systemAuthorizationService == null) {
            this.systemAuthorizationService = KcServiceLocator.getService(SystemAuthorizationService.class);
        }
        return this.systemAuthorizationService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }
}

