/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.calculator;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.calculator.BreakupIntervalService;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.And;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.query.operator.NotEquals;
import org.kuali.coeus.common.budget.framework.query.operator.Operator;
import org.kuali.coeus.common.budget.framework.rate.AbstractBudgetRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetLaRate;
import org.kuali.coeus.common.budget.framework.rate.BudgetRate;
import org.kuali.coeus.common.budget.framework.rate.RateClassBaseExclusion;
import org.kuali.coeus.common.budget.framework.rate.RateClassBaseInclusion;
import org.kuali.coeus.common.budget.impl.calculator.BreakUpInterval;
import org.kuali.coeus.common.budget.impl.calculator.Node;
import org.kuali.coeus.common.budget.impl.calculator.RateAndCost;
import org.kuali.coeus.common.budget.impl.calculator.Tree;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="breakupIntervalService")
public class BreakupIntervalServiceImpl
implements BreakupIntervalService {
    static final String BREAKUP_SERVICE_USE_NEW_CALCULATION_PARAM = "breakupServiceUseNewCalculation";
    public static final String RATE_CLASS_CODE = "rateClassCode";
    public static final String RATE_TYPE_CODE = "rateTypeCode";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    private List<RateClassBaseInclusion> rateClassBaseInclusions;
    private List<RateClassBaseExclusion> rateClassBaseExclusions;

    public List<RateClassBaseInclusion> getRateClassBaseInclusions() {
        return this.rateClassBaseInclusions;
    }

    public void setRateClassBaseInclusions(List<RateClassBaseInclusion> rateClassBaseInclusions) {
        this.rateClassBaseInclusions = rateClassBaseInclusions;
    }

    public List<RateClassBaseExclusion> getRateClassBaseExclusions() {
        return this.rateClassBaseExclusions;
    }

    public void setRateClassBaseExclusions(List<RateClassBaseExclusion> rateClassBaseExclusions) {
        this.rateClassBaseExclusions = rateClassBaseExclusions;
    }

    private void initializeRateClassBases() {
        this.setRateClassBaseInclusions((List)this.getBusinessObjectService().findAll(RateClassBaseInclusion.class));
        this.setRateClassBaseExclusions((List)this.getBusinessObjectService().findAll(RateClassBaseExclusion.class));
    }

    @Override
    public void calculate(BreakUpInterval breakupInterval) {
        if (this.parameterService.parameterExists("KC-B", "Document", BREAKUP_SERVICE_USE_NEW_CALCULATION_PARAM).booleanValue() && this.parameterService.getParameterValueAsBoolean("KC-B", "Document", BREAKUP_SERVICE_USE_NEW_CALCULATION_PARAM).booleanValue()) {
            this.calculateNew(breakupInterval);
        } else {
            this.calculateOld(breakupInterval);
        }
    }

    protected void calculateNew(BreakUpInterval breakupInterval) {
        ArrayList<RateClassBaseInclusion> rateClassBaseInclusions = new ArrayList<RateClassBaseInclusion>(this.getBusinessObjectService().findAll(RateClassBaseInclusion.class));
        ArrayList<RateClassBaseExclusion> rateClassBaseExclusions = new ArrayList<RateClassBaseExclusion>(this.getBusinessObjectService().findAll(RateClassBaseExclusion.class));
        QueryList<RateAndCost> rateAndCosts = breakupInterval.getRateAndCosts();
        for (RateAndCost rateAndCost : rateAndCosts) {
            this.calculateRateAndCost(rateAndCost, breakupInterval, rateAndCosts, rateClassBaseInclusions, rateClassBaseExclusions);
        }
        breakupInterval.setUnderRecovery(rateAndCosts.sumObjects("underRecovery"));
    }

    protected void calculateOld(BreakUpInterval breakupInterval) {
        this.initializeRateClassBases();
        QueryList<RateAndCost> rateAndCosts = breakupInterval.getRateAndCosts();
        List rateClassInclusions = (List)this.getBusinessObjectService().findAll(RateClassBaseInclusion.class);
        for (RateClassBaseInclusion rateClassBaseInclusion : rateClassInclusions) {
            if (!this.canApplyRate(rateClassBaseInclusion, rateAndCosts)) continue;
            this.findAndApplyRateRecursively(breakupInterval, rateClassBaseInclusion, rateAndCosts);
        }
        breakupInterval.setUnderRecovery(rateAndCosts.sumObjects("underRecovery"));
    }

    private boolean canApplyRate(RateClassBaseInclusion rateClassBaseInclusion, QueryList<RateAndCost> rateAndCosts) {
        Equals eqRateClassCode = new Equals(RATE_CLASS_CODE, (Comparable)((Object)rateClassBaseInclusion.getRateClassCode()));
        Equals eqRateTypeCode = new Equals(RATE_TYPE_CODE, (Comparable)((Object)rateClassBaseInclusion.getRateTypeCode()));
        QueryList<RateAndCost> applicableRateList = rateAndCosts.filter(rateClassBaseInclusion.getRateTypeCode() == null ? eqRateClassCode : new And(eqRateClassCode, eqRateTypeCode));
        return !applicableRateList.isEmpty();
    }

    protected RateAndCost calculateRateAndCost(RateAndCost rateAndCost, BreakUpInterval breakupInterval, List<RateAndCost> allRateAndCosts, List<RateClassBaseInclusion> inclusions, List<RateClassBaseExclusion> exclusions) {
        List<RateClassBaseInclusion> rateInclusions = this.getRelatedInclusions(rateAndCost, inclusions);
        ScaleTwoDecimal rateBaseAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal rateCostShareAmount = ScaleTwoDecimal.ZERO;
        for (RateClassBaseInclusion inclusion : rateInclusions) {
            if ("0".equals(inclusion.getRateClassCodeIncl()) && !this.isExcluded(rateAndCost.getRateClassCode(), rateAndCost.getRateTypeCode(), "0", null, exclusions)) {
                rateBaseAmount = (ScaleTwoDecimal)rateBaseAmount.add((AbstractDecimal)breakupInterval.getApplicableAmt());
                rateCostShareAmount = (ScaleTwoDecimal)rateCostShareAmount.add((AbstractDecimal)breakupInterval.getApplicableAmtCostSharing());
                continue;
            }
            List<RateAndCost> applicableRates = this.getApplicableRateAndCostsForInclusion(inclusion, allRateAndCosts, breakupInterval, inclusions, exclusions);
            rateBaseAmount = this.calculateNewAmountBasedOnApplicableRates(rateBaseAmount, rateAndCost, exclusions, RateAndCost::getCalculatedCost, applicableRates);
            rateCostShareAmount = this.calculateNewAmountBasedOnApplicableRates(rateCostShareAmount, rateAndCost, exclusions, RateAndCost::getCalculatedCostSharing, applicableRates);
        }
        if (rateAndCost.isApplyRateFlag().booleanValue() || rateAndCost.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType())) {
            this.calculateRateAndCostCalculatedAmounts(rateAndCost, rateBaseAmount, rateCostShareAmount, this.getAppliedRate(breakupInterval, rateAndCost));
        }
        if (rateAndCost.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType())) {
            this.calculateUnderRecovery(breakupInterval, rateAndCost);
        }
        return rateAndCost;
    }

    protected List<RateAndCost> getApplicableRateAndCostsForInclusion(RateClassBaseInclusion inclusion, List<RateAndCost> allRateAndCosts, BreakUpInterval breakupInterval, List<RateClassBaseInclusion> inclusions, List<RateClassBaseExclusion> exclusions) {
        List<RateAndCost> applicableRates = this.getApplicableRates(inclusion, allRateAndCosts);
        applicableRates = applicableRates.stream().map(currentRateAndCost -> this.calculateRateAndCost((RateAndCost)currentRateAndCost, breakupInterval, allRateAndCosts, inclusions, exclusions)).collect(Collectors.toList());
        return applicableRates;
    }

    protected ScaleTwoDecimal calculateNewAmountBasedOnApplicableRates(ScaleTwoDecimal rateBaseAmount, RateAndCost rateAndCost, List<RateClassBaseExclusion> exclusions, Function<RateAndCost, ScaleTwoDecimal> costMapper, List<RateAndCost> applicableRates) {
        rateBaseAmount = applicableRates.stream().filter(RateAndCost::isApplyRateFlag).filter(currentRateAndCost -> !this.isExcluded(rateAndCost, (RateAndCost)currentRateAndCost, exclusions)).map(costMapper).reduce(rateBaseAmount, AbstractDecimal::add);
        return rateBaseAmount;
    }

    protected void calculateRateAndCostCalculatedAmounts(RateAndCost rateAndCost, ScaleTwoDecimal rateBaseAmount, ScaleTwoDecimal rateCostShareAmount, ScaleTwoDecimal rate) {
        rateAndCost.setBaseAmount(rateBaseAmount);
        rateAndCost.setBaseCostSharingAmount(rateCostShareAmount);
        rateAndCost.setAppliedRate(rate);
        rateAndCost.setCalculated(true);
        rateAndCost.setCalculatedCost((ScaleTwoDecimal)rateAndCost.getBaseAmount().percentage((AbstractDecimal)rate));
        rateAndCost.setCalculatedCostSharing((ScaleTwoDecimal)rateAndCost.getBaseCostSharingAmount().percentage((AbstractDecimal)rate));
    }

    protected List<RateClassBaseInclusion> getRelatedInclusions(RateAndCost rateAndCost, List<RateClassBaseInclusion> inclusions) {
        List<RateClassBaseInclusion> rateInclusions = inclusions.stream().filter(inclusion -> StringUtils.equals((CharSequence)rateAndCost.getRateClassCode(), (CharSequence)inclusion.getRateClassCode()) && (inclusion.getRateTypeCode() == null || StringUtils.equals((CharSequence)rateAndCost.getRateTypeCode(), (CharSequence)inclusion.getRateTypeCode()))).collect(Collectors.toList());
        return rateInclusions;
    }

    protected List<RateAndCost> getApplicableRates(RateClassBaseInclusion inclusion, List<RateAndCost> allRateAndCosts) {
        return allRateAndCosts.stream().filter(rateAndCost -> StringUtils.equals((CharSequence)inclusion.getRateClassCodeIncl(), (CharSequence)rateAndCost.getRateClassCode()) && (inclusion.getRateTypeCodeIncl() == null || StringUtils.equals((CharSequence)inclusion.getRateTypeCodeIncl(), (CharSequence)rateAndCost.getRateTypeCode()))).collect(Collectors.toList());
    }

    protected boolean isExcluded(RateAndCost rateAndCost, RateAndCost excludableRateAndCost, List<RateClassBaseExclusion> exclusions) {
        return this.isExcluded(rateAndCost.getRateClassCode(), rateAndCost.getRateTypeCode(), excludableRateAndCost.getRateClassCode(), excludableRateAndCost.getRateTypeCode(), exclusions);
    }

    protected boolean isExcluded(String rateClassCode, String rateTypeCode, String excludableRateClassCode, String excludableRateTypeCode, List<RateClassBaseExclusion> exclusions) {
        return exclusions.stream().anyMatch(exclusion -> StringUtils.equals((CharSequence)rateClassCode, (CharSequence)exclusion.getRateClassCode()) && (exclusion.getRateTypeCode() == null || StringUtils.equals((CharSequence)rateTypeCode, (CharSequence)exclusion.getRateTypeCode())) && StringUtils.equals((CharSequence)excludableRateClassCode, (CharSequence)exclusion.getRateClassCodeExcl()) && StringUtils.equals((CharSequence)excludableRateTypeCode, (CharSequence)exclusion.getRateTypeCodeExcl()));
    }

    protected void findAndApplyRateRecursively(BreakUpInterval breakupInterval, RateClassBaseInclusion rateClassBaseInclusion, QueryList<RateAndCost> rateAndCosts) {
        RateClassInclusionTree rateClassInclusionTree = this.getRateClassInclusionTree(rateClassBaseInclusion.getRateClassBaseInclusionId());
        List rateClassInclusions = rateClassInclusionTree.toList();
        int numberOfNodes = rateClassInclusions.size();
        ScaleTwoDecimal baseCost = breakupInterval.getApplicableAmt();
        ScaleTwoDecimal baseCostSharing = breakupInterval.getApplicableAmtCostSharing();
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedCostSharing = ScaleTwoDecimal.ZERO;
        for (int i = numberOfNodes - 1; i >= 0; --i) {
            Node rateClassInclusionNode = rateClassInclusions.get(i);
            RateClassBaseInclusion rcbi = (RateClassBaseInclusion)rateClassInclusionNode.getData();
            QueryList<RateAndCost> applicableRateList = this.filterApplicableRates(rateAndCosts, rcbi);
            if (!applicableRateList.isEmpty()) {
                for (RateAndCost rateAndCost : applicableRateList) {
                    if (!rateAndCost.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType()) && !rateAndCost.isApplyRateFlag().booleanValue()) continue;
                    ScaleTwoDecimal rate = this.getAppliedRate(breakupInterval, rateAndCost);
                    calculatedCost = (ScaleTwoDecimal)baseCost.percentage((AbstractDecimal)rate);
                    if (baseCostSharing == null) {
                        baseCostSharing = ScaleTwoDecimal.ZERO;
                    }
                    calculatedCostSharing = (ScaleTwoDecimal)baseCostSharing.percentage((AbstractDecimal)rate);
                    if (i != 0) continue;
                    rateAndCost.setAppliedRate(rate);
                    rateAndCost.setCalculatedCost((ScaleTwoDecimal)rateAndCost.getCalculatedCost().add((AbstractDecimal)calculatedCost));
                    rateAndCost.setCalculatedCostSharing((ScaleTwoDecimal)rateAndCost.getCalculatedCostSharing().add((AbstractDecimal)calculatedCostSharing));
                    rateAndCost.setBaseAmount((ScaleTwoDecimal)rateAndCost.getBaseAmount().add((AbstractDecimal)baseCost));
                    rateAndCost.setBaseCostSharingAmount((ScaleTwoDecimal)rateAndCost.getBaseCostSharingAmount().add((AbstractDecimal)baseCostSharing));
                    rateAndCost.setCalculated(true);
                    if (!rateAndCost.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType())) continue;
                    this.calculateUnderRecovery(breakupInterval, rateAndCost);
                }
                baseCost = calculatedCost;
                baseCostSharing = calculatedCostSharing;
                continue;
            }
            baseCost = ScaleTwoDecimal.ZERO;
            baseCostSharing = ScaleTwoDecimal.ZERO;
        }
    }

    protected ScaleTwoDecimal getAppliedRate(BreakUpInterval breakupInterval, RateAndCost rateAndCost) {
        Equals eqRateClassCode = new Equals(RATE_CLASS_CODE, (Comparable)((Object)rateAndCost.getRateClassCode()));
        Equals eqRateTypeCode = new Equals(RATE_TYPE_CODE, (Comparable)((Object)rateAndCost.getRateTypeCode()));
        And rcAndRt = new And(eqRateClassCode, eqRateTypeCode);
        QueryList<BudgetRate> breakupIntervalRates = breakupInterval.getBudgetProposalRates();
        QueryList<BudgetLaRate> breakupIntervalLaRates = breakupInterval.getBudgetProposalLaRates();
        QueryList<AbstractBudgetRate> applicableRates = breakupIntervalRates.filter(rcAndRt);
        if (applicableRates.isEmpty()) {
            applicableRates = breakupIntervalLaRates.filter(rcAndRt);
        }
        return applicableRates.isEmpty() ? ScaleTwoDecimal.ZERO : applicableRates.get(0).getApplicableRate();
    }

    public void calculateUnderRecovery(BreakUpInterval breakupInterval, RateAndCost rateAndCost) {
        ScaleTwoDecimal underRecoveryRate;
        ScaleTwoDecimal instituteRate = breakupInterval.getURRatesBean() != null ? breakupInterval.getURRatesBean().getApplicableRate() : this.filterInstituteRate(breakupInterval, rateAndCost);
        if (!rateAndCost.isApplyRateFlag().booleanValue()) {
            underRecoveryRate = instituteRate;
            rateAndCost.setCalculatedCost(ScaleTwoDecimal.ZERO);
            rateAndCost.setCalculatedCostSharing(ScaleTwoDecimal.ZERO);
        } else {
            underRecoveryRate = (ScaleTwoDecimal)instituteRate.subtract((AbstractDecimal)this.getAppliedRate(breakupInterval, rateAndCost));
        }
        ScaleTwoDecimal underRecovery = (ScaleTwoDecimal)rateAndCost.getBaseAmount().percentage((AbstractDecimal)underRecoveryRate);
        ScaleTwoDecimal underRecoveryCostShare = (ScaleTwoDecimal)rateAndCost.getBaseCostSharingAmount().percentage((AbstractDecimal)underRecoveryRate);
        rateAndCost.setUnderRecovery((ScaleTwoDecimal)underRecovery.add((AbstractDecimal)underRecoveryCostShare));
    }

    protected ScaleTwoDecimal filterInstituteRate(BreakUpInterval breakupInterval, RateAndCost rateAndCost) {
        Equals eqRateClassCode = new Equals(RATE_CLASS_CODE, (Comparable)((Object)rateAndCost.getRateClassCode()));
        Equals eqRateTypeCode = new Equals(RATE_TYPE_CODE, (Comparable)((Object)rateAndCost.getRateTypeCode()));
        And rcAndRt = new And(eqRateClassCode, eqRateTypeCode);
        QueryList<BudgetRate> breakupIntervalRates = breakupInterval.getBudgetProposalRates();
        QueryList<BudgetRate> applicableRates = breakupIntervalRates.filter(rcAndRt);
        return applicableRates.isEmpty() ? ScaleTwoDecimal.ZERO : applicableRates.get(0).getInstituteRate();
    }

    protected QueryList<RateAndCost> filterApplicableRates(QueryList<RateAndCost> rateAndCosts, RateClassBaseInclusion rcbi) {
        Equals eqRateClassCode = new Equals(RATE_CLASS_CODE, (Comparable)((Object)rcbi.getRateClassCode()));
        Equals eqRateTypeCode = new Equals(RATE_TYPE_CODE, (Comparable)((Object)rcbi.getRateTypeCode()));
        Operator rcAndRt = rcbi.getRateTypeCode() == null ? eqRateClassCode : new And(eqRateClassCode, eqRateTypeCode);
        QueryList<RateAndCost> applicableRateList = rateAndCosts.filter(rcAndRt);
        List rateClassInclusions = (List)this.getBusinessObjectService().findAll(RateClassBaseInclusion.class);
        for (RateClassBaseInclusion rateClassInclusion : rateClassInclusions) {
            if (!rcbi.getRateClassCode().equals(rateClassInclusion.getRateClassCode()) || rcbi.getRateTypeCode() != null || rateClassInclusion.getRateTypeCode() == null) continue;
            NotEquals neRateTypeCode = new NotEquals(RATE_TYPE_CODE, (Comparable)((Object)rateClassInclusion.getRateTypeCode()));
            applicableRateList = applicableRateList.filter(neRateTypeCode);
        }
        return applicableRateList;
    }

    public RateClassInclusionTree getRateClassInclusionTree(Long id) {
        RateClassInclusionTree taskTree = new RateClassInclusionTree();
        Node<RateClassBaseInclusion> rootElement = new Node<RateClassBaseInclusion>((RateClassBaseInclusion)this.getBusinessObjectService().findBySinglePrimaryKey(RateClassBaseInclusion.class, (Object)id));
        this.getRecursive(rootElement, taskTree);
        taskTree.setRootElement(rootElement);
        return taskTree;
    }

    private void getRecursive(Node<RateClassBaseInclusion> taskElement, RateClassInclusionTree tree) {
        List<RateClassBaseInclusion> children = this.findRateClassInclusions(taskElement.getData().getRateClassCodeIncl(), taskElement.getData().getRateTypeCodeIncl());
        ArrayList childElements = new ArrayList();
        for (RateClassBaseInclusion childTask : children) {
            Node<RateClassBaseInclusion> childElement = new Node<RateClassBaseInclusion>(childTask);
            if (this.isExcluded(taskElement.getData().getRateClassCode(), taskElement.getData().getRateTypeCode(), childElement)) continue;
            childElements.add(childElement);
            this.getRecursive(childElement, tree);
        }
        taskElement.setChildren(childElements);
    }

    private boolean isExcluded(String rateClassCode, String rateTypeCode, Node<RateClassBaseInclusion> childElement) {
        Equals eqRateClassCode = new Equals(RATE_CLASS_CODE, (Comparable)((Object)rateClassCode));
        Equals eqRateTypeCode = new Equals(RATE_TYPE_CODE, (Comparable)((Object)rateTypeCode));
        Operator rcAndRt = rateTypeCode == null ? eqRateClassCode : new And(eqRateClassCode, eqRateTypeCode);
        Equals eqRateClassCodeExcl = new Equals("rateClassCodeExcl", (Comparable)((Object)childElement.getData().getRateClassCode()));
        Equals eqRateTypeCodeExcl = new Equals("rateTypeCodeExcl", (Comparable)((Object)childElement.getData().getRateTypeCode()));
        Operator rcExclAndRtExcl = eqRateTypeCodeExcl == null ? eqRateClassCodeExcl : new And(eqRateClassCodeExcl, eqRateTypeCodeExcl);
        And rcAndRcExcl = new And(rcAndRt, rcExclAndRtExcl);
        QueryList<RateClassBaseExclusion> rateClassQueryList = new QueryList<RateClassBaseExclusion>(this.getRateClassBaseExclusions());
        QueryList<RateClassBaseExclusion> filteredRateClasses = rateClassQueryList.filter(rcAndRcExcl);
        return !filteredRateClasses.isEmpty();
    }

    private List<RateClassBaseInclusion> findRateClassInclusions(String rateClassCode, String rateTypeCode) {
        QueryList<RateClassBaseInclusion> rateInclusions = new QueryList<RateClassBaseInclusion>(this.getRateClassBaseInclusions());
        rateInclusions.sort("rateClassCodeIncl");
        Equals eqRateClassCode = new Equals(RATE_CLASS_CODE, (Comparable)((Object)rateClassCode));
        Equals eqRateTypeCode = new Equals(RATE_TYPE_CODE, (Comparable)((Object)rateTypeCode));
        Operator rcAndRt = rateTypeCode == null ? eqRateClassCode : new And(eqRateClassCode, eqRateTypeCode);
        QueryList<RateClassBaseInclusion> inclusions = rateInclusions.filter(rcAndRt);
        for (RateClassBaseInclusion rateClassBaseInclusion : inclusions) {
            List<RateClassBaseInclusion> dependentInclusions = this.findRateClassInclusions(rateClassBaseInclusion.getRateClassCodeIncl(), rateClassBaseInclusion.getRateTypeCodeIncl());
            for (RateClassBaseInclusion rateClassBaseInclusion2 : dependentInclusions) {
                rateClassBaseInclusion2.setParentRateClassBaseInclusionId(rateClassBaseInclusion.getRateClassBaseInclusionId());
            }
        }
        return inclusions;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public class RateClassInclusionTree
    extends Tree<RateClassBaseInclusion> {
    }
}

