/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.org.kuali.rice.krad.uif.container;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.notification.impl.NotificationHelper;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.DialogGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.web.form.UifFormBase;

public class WizardGroup
extends DialogGroup {
    private static final Logger LOG = LogManager.getLogger(WizardGroup.class);

    public void performApplyModel(Object model, LifecycleElement parent) {
        UifFormBase form = (UifFormBase)model;
        String stepStr = (String)form.getActionParameters().get(this.getId() + ".step");
        Integer step = 0;
        if (stepStr != null && stepStr.matches("\\d")) {
            step = Integer.valueOf(stepStr);
        } else {
            try {
                Object notificationHelper = PropertyUtils.getProperty((Object)form, (String)"notificationHelper");
                if (notificationHelper != null && ((NotificationHelper)notificationHelper).getNotificationStep() != null) {
                    step = ((NotificationHelper)notificationHelper).getNotificationStep();
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.info("Property notification helper was not found on the form." + e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<Component> currentItems = new ArrayList<Component>();
        int len = this.getItems().size();
        for (int i = 0; i < len; ++i) {
            Group group;
            Component component = (Component)this.getItems().get(i);
            if (i != step) continue;
            Component componentCopy = ComponentUtils.copy((Component)component);
            if (componentCopy instanceof Group && (group = (Group)componentCopy).getFooter() != null) {
                this.setFooter(group.getFooter());
                group.setFooter(null);
            }
            currentItems.add(componentCopy);
        }
        this.setItems(currentItems);
        super.performApplyModel(model, parent);
    }
}

