/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.basic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.SaveDocumentSpecialReviewEvent;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyCriteria;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.docperm.ProposalUserRoles;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotification;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationRenderer;
import org.kuali.coeus.propdev.impl.person.AddEmployeePiHelper;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.exception.DocumentAuthorizationException;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentHomeController
extends ProposalDevelopmentControllerBase {
    private static final String PROPOSAL_TYPE = "proposalType";
    private static final String PROPOSAL_STATE = "proposalState";
    private static final String KC_SEND_NOTIFICATION_WIZARD = "Kc-SendNotification-Wizard";
    private static final String ADD_EMPLOYEE_PI_HELPER_PERSON_ID = "addEmployeePiHelper.personId";
    private static final String ERROR_PROPOSAL_DEVELOPMENT_CREATE_PI = "error.proposalDevelopment.create.pi";
    private static final String PROPOSAL_CREATED_ACTION_TYPE_CODE = "910";
    private static final String PROPOSAL_CREATED_NOTIFICATION = "Proposal created notification";
    private static final String USER_NAME = "userName";
    @Autowired
    @Qualifier(value="dataDictionaryService")
    private DataDictionaryService dataDictionaryService;
    @Autowired
    @Qualifier(value="documentDictionaryService")
    private DocumentDictionaryService documentDictionaryService;
    @Autowired
    @Qualifier(value="kcEntityManager")
    private EntityManager entityManager;
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=createProposal"})
    public ModelAndView createProposal(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = form.getProposalDevelopmentDocument();
        boolean valid = this.getKualiRuleService().applyRules((DocumentEvent)new SaveDocumentEvent((Document)proposalDevelopmentDocument));
        if (StringUtils.isNotBlank((CharSequence)form.getAddEmployeePiHelper().getPersonId())) {
            if (StringUtils.isBlank((CharSequence)form.getAddEmployeePiHelper().getKcPerson().getUserName())) {
                valid = false;
                this.getGlobalVariableService().getMessageMap().putError(ADD_EMPLOYEE_PI_HELPER_PERSON_ID, ERROR_PROPOSAL_DEVELOPMENT_CREATE_PI, new String[0]);
            } else {
                ProposalPerson pi = this.createNewPrincipalInvestigator(form.getAddEmployeePiHelper());
                form.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons().clear();
                this.getKeyPersonnelService().addProposalPerson(pi, form.getProposalDevelopmentDocument());
            }
        }
        if (!valid) {
            return this.getModelAndViewService().getModelAndView((UifFormBase)form);
        }
        this.addCreateDetails(proposalDevelopmentDocument);
        this.initialSave(proposalDevelopmentDocument);
        this.generateOpportunity(proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity());
        this.save(form, result, request, response);
        this.initializeProposalUsers(form.getProposalDevelopmentDocument());
        form.setWorkingUserRoles(this.getProposalDevelopmentPermissionsService().getPermissions(form.getProposalDevelopmentDocument()));
        this.getDataObjectService().wrap((Object)form.getDevelopmentProposal()).fetchRelationship(PROPOSAL_TYPE);
        form.setPageId(null);
        form.getDevelopmentProposal().setProposalStateTypeCode("1");
        this.getDataObjectService().wrap((Object)form.getDevelopmentProposal()).fetchRelationship(PROPOSAL_STATE);
        this.releaseLocksForLoggedInUser(form);
        form.getDocument().refreshPessimisticLocks();
        this.setAndValidateMandatoryForms(form.getDevelopmentProposal());
        this.getModelAndViewService().getModelAndViewWithInit((UifFormBase)form, "PropDev-DefaultView");
        return this.sendCreateProposalNotification(form);
    }

    protected ModelAndView sendCreateProposalNotification(ProposalDevelopmentDocumentForm proposalDevelopmentDocumentForm) {
        ProposalDevelopmentDocument proposalDevelopmentDocument = proposalDevelopmentDocumentForm.getProposalDevelopmentDocument();
        ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(proposalDevelopmentDocument.getDevelopmentProposal(), PROPOSAL_CREATED_ACTION_TYPE_CODE, PROPOSAL_CREATED_NOTIFICATION);
        context.getRenderer().setDevelopmentProposal(proposalDevelopmentDocumentForm.getDevelopmentProposal());
        if (proposalDevelopmentDocumentForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            proposalDevelopmentDocumentForm.getNotificationHelper().initializeDefaultValues(context);
            proposalDevelopmentDocumentForm.getNotificationHelper().setNotificationStep(2);
            return this.getModelAndViewService().showDialog(KC_SEND_NOTIFICATION_WIZARD, true, (UifFormBase)proposalDevelopmentDocumentForm);
        }
        this.getKcNotificationService().sendNotificationAndPersist(context, new ProposalDevelopmentNotification(), proposalDevelopmentDocument.getDevelopmentProposal());
        return this.getModelAndViewService().getModelAndView((UifFormBase)proposalDevelopmentDocumentForm);
    }

    private void addCreateDetails(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        proposalDevelopmentDocument.getDevelopmentProposal().setCreateTimestamp(new Timestamp(System.currentTimeMillis()));
        proposalDevelopmentDocument.getDevelopmentProposal().setCreateUser(this.getGlobalVariableService().getUserSession().getLoggedInUserPrincipalName());
    }

    private ProposalPerson createNewPrincipalInvestigator(AddEmployeePiHelper helper) {
        ProposalPerson pi = new ProposalPerson();
        pi.setPersonId(helper.getKcPerson().getPersonId());
        pi.setFullName(helper.getKcPerson().getFullName());
        pi.setUserName(helper.getKcPerson().getUserName());
        pi.setProposalPersonRoleId("PI");
        return pi;
    }

    protected void generateOpportunity(S2sOpportunity opportunity) {
        if (ObjectUtils.isNotNull((Object)opportunity)) {
            this.getS2sSubmissionService().setOpportunityContent(opportunity);
        }
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=viewUtility"})
    public ModelAndView viewUtility(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam(value="userName", required=false) String userName) throws Exception {
        ProposalDevelopmentDocument document = null;
        boolean isDeleted = false;
        if (Objects.nonNull(form.getDocId())) {
            document = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(form.getDocId());
            isDeleted = document.isProposalDeleted();
        }
        if (isDeleted) {
            Properties props = new Properties();
            props.put("methodToCall", "start");
            props.put("viewId", "PropDev-DeletedView");
            return this.getModelAndViewService().performRedirect((UifFormBase)form, "proposalDevelopment", props);
        }
        form.initialize();
        form.setDocument((Document)document);
        if (form.getViewId() != null && StringUtils.equalsIgnoreCase((CharSequence)form.getViewId(), (CharSequence)"PropDev-CertificationView")) {
            ProposalPerson personToCertify = document.getDevelopmentProposal().getProposalPersons().stream().filter(person -> StringUtils.equals((CharSequence)person.getUserName(), (CharSequence)userName)).findFirst().orElse(null);
            if (personToCertify == null) {
                return this.showErrorPage(form, "Certification Not Needed", "Sorry, this proposal no longer lists you as a participant. If you have further questions, ask the Principal Investigator listed in the email notification.");
            }
            boolean lockAlreadyExists = this.getProposalLockService().getPersonnelLocks(document.getDocumentNumber()).stream().anyMatch(lock -> lock.isOwnedByUser(this.getLoggedInUser()));
            if (!lockAlreadyExists) {
                this.getProposalLockService().generatePersonnelLock((Document)document, personToCertify.getProposalPersonNumber());
            }
            form.setProposalPersonQuestionnaireHelper(personToCertify.getQuestionnaireHelper());
        }
        form.setDocTypeName(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        form.setProposalCopyCriteria(new ProposalCopyCriteria(document));
        if (form.getView().getViewHelperService() instanceof ProposalDevelopmentViewHelperServiceImpl) {
            ((ProposalDevelopmentViewHelperServiceImpl)form.getView().getViewHelperService()).populateQuestionnaires(form);
        }
        try {
            String[] certUserName = (String[])form.getInitialRequestParameters().get(USER_NAME);
            this.checkAuthorization(document, form.getViewId(), certUserName);
        }
        catch (AuthorizationException e) {
            return this.showAuthorizationPage(form, e.getMessage());
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    public ModelAndView showAuthorizationPage(ProposalDevelopmentDocumentForm form, String message) {
        return this.showErrorPage(form, "Authorization Exception Report", message);
    }

    public ModelAndView showErrorPage(ProposalDevelopmentDocumentForm form, String header, String message) {
        return this.getModelAndViewService().getMessageView((UifFormBase)form, header, "Error Message: [color=red]" + message + "[/color]");
    }

    public void checkAuthorization(ProposalDevelopmentDocument document, String viewId, String[] userName) {
        Person loggedInUser = this.getLoggedInUser();
        if (viewId != null && StringUtils.equalsIgnoreCase((CharSequence)viewId, (CharSequence)"PropDev-CertificationView") && (userName == null || this.selfCertifyOnly().booleanValue() && !loggedInUser.getPrincipalName().equalsIgnoreCase(userName[0]))) {
            throw new DocumentAuthorizationException(loggedInUser.getPrincipalName(), "open", document.getDocumentNumber());
        }
        if (!this.getDocumentDictionaryService().getDocumentAuthorizer((Document)document).canOpen((Document)document, loggedInUser)) {
            throw new DocumentAuthorizationException(loggedInUser.getPrincipalName(), "open", document.getDocumentNumber());
        }
    }

    public Person getLoggedInUser() {
        return this.getGlobalVariableService().getUserSession().getPerson();
    }

    @Override
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=save"})
    public ModelAndView save(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return super.save(form);
    }

    @Override
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=navigate"})
    public ModelAndView navigate(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        this.refreshDocumentLevelPermissions(form);
        return super.navigate(form, result, request, response);
    }

    protected void refreshDocumentLevelPermissions(ProposalDevelopmentDocumentForm form) {
        List<ProposalUserRoles> newRoles;
        List<ProposalUserRoles> currentRoles = form.getWorkingUserRoles();
        if (this.isDocumentLevelRolesDirty(currentRoles, newRoles = this.getProposalDevelopmentPermissionsService().getPermissions(form.getProposalDevelopmentDocument()))) {
            form.setEvaluateFlagsAndModes(true);
        }
    }

    protected boolean isDocumentLevelRolesDirty(List<ProposalUserRoles> currentRoles, List<ProposalUserRoles> newRoles) {
        return !currentRoles.equals(newRoles);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=getSponsor"})
    @ResponseBody
    public Sponsor sponsorByCode(@RequestParam(value="sponsorCode") String sponsorCode) {
        Sponsor sponsor = (Sponsor)this.getDataObjectService().find(Sponsor.class, (Object)sponsorCode);
        if (sponsor != null) {
            this.entityManager.detach((Object)sponsor);
            sponsor.setUnit(null);
            sponsor.setRolodex(null);
        }
        return sponsor;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveDetails"})
    public ModelAndView saveDetails(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return super.save(form, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveOpportunity"})
    public ModelAndView saveOpportunity(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return super.save(form, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveCompliance"})
    public ModelAndView saveComplaince(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        return super.save((DocumentFormBase)pdForm, result, request, response, SaveDocumentSpecialReviewEvent.class);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveProposalAttachments"})
    public ModelAndView saveProposalAttachments(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        return super.save(pdForm, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveInternalAttachments"})
    public ModelAndView saveInternalAttachments(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        return super.save(pdForm, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=savePersonnelAttachments"})
    public ModelAndView savePersonnelAttachments(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        return super.save(pdForm, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveAbstracts"})
    public ModelAndView saveAbstracts(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        return super.save(pdForm, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveNotes"})
    public ModelAndView saveNotes(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        return super.save(pdForm, result, request, response);
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=docHandler"})
    public ModelAndView docHandler(@ModelAttribute(value="KualiForm") DocumentFormBase form, @RequestParam(required=false) String auditActivated, @RequestParam(required=false) String viewOnly, @RequestParam(required=false) String navigateToPageId, @RequestParam(required=false) String defaultOpenTab, @RequestParam(required=false, defaultValue="false") boolean isCopiedProposal) throws Exception {
        boolean isDeleted = false;
        if (Objects.nonNull(form.getDocId())) {
            ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)this.getDocumentService().getByDocumentHeaderId(form.getDocId());
            isDeleted = document.isProposalDeleted();
        }
        if (auditActivated != null) {
            ((ProposalDevelopmentDocumentForm)form).setAuditActivated(Boolean.parseBoolean(auditActivated));
        }
        if (isDeleted) {
            Properties props = new Properties();
            props.put("methodToCall", "start");
            props.put("viewId", "PropDev-DeletedView");
            return this.getModelAndViewService().performRedirect((UifFormBase)form, "proposalDevelopment", props);
        }
        boolean summaryView = false;
        if (form.getCommand().equals("displayActionListInlineView")) {
            summaryView = true;
            form.setCommand("displayActionListView");
        }
        ProposalDevelopmentDocumentForm propDevForm = (ProposalDevelopmentDocumentForm)form;
        try {
            ModelAndView modelAndView = this.getTransactionalDocumentControllerService().docHandler(form);
            propDevForm.initialize();
            propDevForm.getCustomDataHelper().prepareCustomData();
            this.setS2sOpportunityFromLookup(form, propDevForm);
            propDevForm.getDevelopmentProposal().refreshNihOpportunity();
            propDevForm.setWorkingUserRoles(this.getProposalDevelopmentPermissionsService().getPermissions(propDevForm.getProposalDevelopmentDocument()));
            if (summaryView) {
                form.setView(this.getDataDictionaryService().getViewById("PropDev-SummaryView"));
                form.setViewId("PropDev-SummaryView");
                return modelAndView;
            }
            if (CollectionUtils.isNotEmpty(propDevForm.getDevelopmentProposal().getProposalChangedDataList())) {
                this.getGlobalVariableService().getMessageMap().putInfoForSectionId("PropDev-DetailsPage", "info.dataoverride.occured", new String[0]);
            }
            if (propDevForm.getDocument().getDocumentHeader().getWorkflowDocument().isEnroute()) {
                ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).prepareSummaryPage(propDevForm, true);
                propDevForm.getView().setEntryPageId("PropDev-SubmitPage");
            }
            if (StringUtils.isNotBlank((CharSequence)navigateToPageId)) {
                propDevForm.getView().setEntryPageId(navigateToPageId);
            }
            if (StringUtils.isNotBlank((CharSequence)defaultOpenTab)) {
                propDevForm.setDefaultOpenTab(defaultOpenTab);
            }
            if (!propDevForm.getDocument().getDocumentHeader().getWorkflowDocument().isEnroute() && (StringUtils.equals((CharSequence)form.getRequest().getParameter("viewDocument"), (CharSequence)"true") || StringUtils.equals((CharSequence)viewOnly, (CharSequence)"true"))) {
                propDevForm.setViewOnly(true);
            }
            if (isCopiedProposal) {
                return this.sendCreateProposalNotification(propDevForm);
            }
            return modelAndView;
        }
        catch (AuthorizationException e) {
            return this.showAuthorizationPage(propDevForm, e.getMessage());
        }
    }

    protected void setS2sOpportunityFromLookup(DocumentFormBase form, ProposalDevelopmentDocumentForm propDevForm) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)form.getRequest().getParameter("opportunityId"))) {
            DevelopmentProposal developmentProposal = propDevForm.getProposalDevelopmentDocument().getDevelopmentProposal();
            S2sOpportunity opportunity = new S2sOpportunity();
            Calendar openingDate = Calendar.getInstance();
            if (Objects.nonNull(form.getRequest().getParameter("openingDate"))) {
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm a");
                openingDate.setTime(sdf.parse(form.getRequest().getParameter("openingDate")));
            }
            opportunity.setOpeningDate(openingDate);
            opportunity.setPackageId(form.getRequest().getParameter("packageId"));
            opportunity.setCompetitionId(form.getRequest().getParameter("competitionId"));
            opportunity.setCompetitionTitle(form.getRequest().getParameter("competitionTitle"));
            opportunity.setInstructionUrl(form.getRequest().getParameter("instructionUrl"));
            opportunity.setS2sOpportunityCfdasSerialized(form.getRequest().getParameter("s2sOpportunityCfdasSerialized"));
            opportunity.getS2sOpportunityCfdas().forEach(cfda -> cfda.setProposalNumber(developmentProposal.getProposalNumber()));
            opportunity.setOpportunityId(form.getRequest().getParameter("opportunityId"));
            String opportunityTitle = form.getRequest().getParameter("opportunityTitle");
            String trimmedTitle = StringUtils.substring((String)opportunityTitle, (int)0, (int)119);
            opportunity.setOpportunityTitle(trimmedTitle);
            opportunity.setProviderCode(form.getRequest().getParameter("providerCode"));
            opportunity.setSchemaUrl(form.getRequest().getParameter("schemaUrl"));
            opportunity.setDevelopmentProposal(developmentProposal);
            developmentProposal.setS2sOpportunity(opportunity);
            developmentProposal.setProgramAnnouncementTitle(opportunityTitle);
            developmentProposal.setProgramAnnouncementNumber(opportunity.getOpportunityId());
            developmentProposal.setProposalCfdas(opportunity.getS2sOpportunityCfdas().stream().map(cfda -> {
                ProposalCfda proposalCfda = new ProposalCfda();
                proposalCfda.setCfdaNumber(cfda.getCfdaNumber());
                proposalCfda.setCfdaDescription(cfda.getCfdaDescription());
                proposalCfda.setProposalNumber(developmentProposal.getProposalNumber());
                return proposalCfda;
            }).collect(Collectors.toList()));
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=editCollectionLine"})
    public ModelAndView editCollectionLine(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (form.getEditableCollectionLines().containsKey(selectedCollectionPath)) {
            form.getEditableCollectionLines().get(selectedCollectionPath).add(selectedLine);
        } else {
            ArrayList<String> newKeyList = new ArrayList<String>();
            newKeyList.add(selectedLine);
            form.getEditableCollectionLines().put(selectedCollectionPath, newKeyList);
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setRenderer(ProposalDevelopmentNotificationRenderer renderer) {
        this.renderer = renderer;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }
}

