/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.basic;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.api.core.SubmissionInfoService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentProposalRequiredFieldsAuditRule
implements DocumentAuditRule {
    private ParameterService parameterService;
    private SubmissionInfoService submissionInfoService;
    private ProposalTypeService proposalTypeService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        DevelopmentProposal proposal = proposalDevelopmentDocument.getDevelopmentProposal();
        Long proposalId = null;
        if (StringUtils.isNotEmpty((CharSequence)proposal.getContinuedFrom())) {
            proposalId = this.getSubmissionInfoService().getProposalContinuedFromVersionProposalId(proposal.getContinuedFrom());
        }
        String changeCorrectedType = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2s.submissiontype.changedCorrected");
        if (proposal.hasS2sOpportunity() && this.isProposalTypeNew(proposal.getProposalTypeCode()) && StringUtils.equals((CharSequence)proposal.getS2sOpportunity().getS2sSubmissionTypeCode(), (CharSequence)changeCorrectedType)) {
            String ggTrackingId = null;
            if (proposalId != null) {
                ggTrackingId = this.getSubmissionInfoService().getGgTrackingIdFromProposal(proposalId);
            }
            if (StringUtils.isBlank((CharSequence)proposal.getSponsorProposalNumber()) && StringUtils.isBlank((CharSequence)ggTrackingId)) {
                valid = false;
                this.getAuditErrors("Proposal Details", "").add(new AuditError("document.developmentProposal.continuedFrom", "error.proposal.require.id.changeapp", "PropDev-DetailsPage"));
            }
        }
        return valid;
    }

    private boolean isProposalTypeNew(String proposalTypeCode) {
        return !StringUtils.isEmpty((CharSequence)proposalTypeCode) && proposalTypeCode.equals(this.getProposalTypeService().getNewProposalTypeCode());
    }

    private List<AuditError> getAuditErrors(String areaName, String sectionName) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        String clusterKey = areaName + "." + sectionName;
        if (!GlobalVariables.getAuditErrorMap().containsKey(clusterKey)) {
            GlobalVariables.getAuditErrorMap().put(clusterKey, new AuditCluster(clusterKey, auditErrors, "Error"));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(clusterKey)).getAuditErrorList();
        }
        return auditErrors;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected SubmissionInfoService getSubmissionInfoService() {
        if (this.submissionInfoService == null) {
            this.submissionInfoService = KcServiceLocator.getService(SubmissionInfoService.class);
        }
        return this.submissionInfoService;
    }

    public void setSubmissionInfoService(SubmissionInfoService submissionInfoService) {
        this.submissionInfoService = submissionInfoService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ProposalTypeService getProposalTypeService() {
        if (this.proposalTypeService == null) {
            this.proposalTypeService = KcServiceLocator.getService(ProposalTypeService.class);
        }
        return this.proposalTypeService;
    }

    public void setProposalTypeService(ProposalTypeService proposalTypeService) {
        this.proposalTypeService = proposalTypeService;
    }
}

