/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.override;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PostRemove;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.common.framework.attachment.KcAttachmentService;
import org.kuali.coeus.common.framework.print.KcAttachmentDataSource;
import org.kuali.coeus.propdev.api.s2s.override.S2sOverrideAttachmentContract;
import org.kuali.coeus.propdev.impl.s2s.FormUtilityService;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverrideApplicationData;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.file.FileMeta;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Entity
@Table(name="S2S_OVERRIDE_ATT")
public class S2sOverrideAttachment
extends KcAttachmentDataSource
implements S2sOverrideAttachmentContract,
FileMeta {
    private static final Logger LOG = LogManager.getLogger(S2sOverrideAttachment.class);
    @PortableSequenceGenerator(name="SEQ_S2S_OVERRIDE_ATT_ID")
    @GeneratedValue(generator="SEQ_S2S_OVERRIDE_ATT_ID")
    @Id
    @Column(name="ID")
    private String attachmentId;
    @Column(name="CONTENT_ID")
    private String contentId;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="S2S_OVERRIDE_APPL_DATA_ID", referencedColumnName="ID")
    private S2sOverrideApplicationData application;
    @Transient
    private String url;
    @Transient
    private String id;
    @Transient
    private transient DateTimeService dateTimeService;
    @Transient
    private transient KcAttachmentService kcAttachmentService;
    @Transient
    private transient KcAttachmentDataDao kcAttachmentDataDao;
    @Transient
    private transient GrantApplicationHashService grantApplicationHashService;
    @Transient
    private transient FormUtilityService formUtilityService;

    public S2sOverrideApplicationData getApplication() {
        return this.application;
    }

    public void setApplication(S2sOverrideApplicationData application) {
        this.application = application;
    }

    public void init(MultipartFile multipartFile) throws IOException {
        this.setData(multipartFile.getBytes());
        this.setName(multipartFile.getOriginalFilename());
        this.setType(multipartFile.getContentType());
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getContentType() {
        return this.getType();
    }

    public void setContentType(String contentType) {
        this.setType(contentType);
    }

    public Long getSize() {
        return this.getData().length;
    }

    public void setSize(Long size) {
    }

    public String getSizeFormatted() {
        return this.getKcAttachmentService().formatFileSizeString(this.getSize());
    }

    public Date getDateUploaded() {
        return this.getUploadTimestamp();
    }

    public void setDateUploaded(Date dateUploaded) {
        this.setUploadTimestamp(new Timestamp(dateUploaded.getTime()));
    }

    public String getDateUploadedFormatted() {
        if (this.getUpdateTimestamp() != null) {
            return this.getDateTimeService().toString(new Date(this.getUpdateTimestamp().getTime()), "MM/dd/yyyy hh:mm a");
        }
        return "";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSha1Hash() {
        return this.getGrantApplicationHashService().computeAttachmentHash(this.getData());
    }

    public String getSha1HashInXml() {
        Node sha1HashInXmlNode = this.getSha1HashInXmlNode();
        if (sha1HashInXmlNode != null && StringUtils.isNotBlank((CharSequence)sha1HashInXmlNode.getTextContent())) {
            return sha1HashInXmlNode.getTextContent();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node getSha1HashInXmlNode() {
        String applicationXml = this.getApplication().getApplication();
        if (!StringUtils.isNotBlank((CharSequence)applicationXml)) return null;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(applicationXml.getBytes(StandardCharsets.UTF_8));){
            Document appDoc = this.getFormUtilityService().createDomBuilder().parse(byteArrayInputStream);
            Node hashValueNode = this.getHashValueFromLocations(appDoc.getElementsByTagNameNS("http://apply.grants.gov/system/Attachments-V1.0", "FileLocation"));
            if (hashValueNode != null) {
                Node node = hashValueNode;
                return node;
            }
            Node hashValueNodeNoNs = this.getHashValueFromLocations(appDoc.getElementsByTagName("FileLocation"));
            if (hashValueNodeNoNs == null) return null;
            Node node = hashValueNodeNoNs;
            return node;
        }
        catch (IOException | RuntimeException | ParserConfigurationException | SAXException e) {
            if (!LOG.isInfoEnabled()) return null;
            LOG.info((Object)e);
        }
        return null;
    }

    private Node getHashValueFromLocations(NodeList fileLocations) {
        for (int i = 0; i < fileLocations.getLength(); ++i) {
            Node hashValueNode;
            Node location = fileLocations.item(i);
            NamedNodeMap locationAttrs = location.getAttributes();
            if (locationAttrs == null) continue;
            Node href = locationAttrs.getNamedItemNS("http://apply.grants.gov/system/Attachments-V1.0", "href");
            if (href != null) {
                Node hashValueNode2;
                if (!href.getNodeValue().equals(this.contentId) || (hashValueNode2 = this.getFormUtilityService().getHashValueFromParent(location.getParentNode())) == null) continue;
                return hashValueNode2;
            }
            Node hrefNoNS = locationAttrs.getNamedItem("href");
            if (hrefNoNS == null || !hrefNoNS.getNodeValue().equals(this.contentId) || (hashValueNode = this.getFormUtilityService().getHashValueFromParent(location.getParentNode())) == null) continue;
            return hashValueNode;
        }
        return null;
    }

    public boolean updateSha1HashInXml() {
        block3: {
            Node xmlHash;
            String actualHash = this.getSha1Hash();
            if (StringUtils.isNotBlank((CharSequence)actualHash) && (xmlHash = this.getSha1HashInXmlNode()) != null && !actualHash.equals(xmlHash.getTextContent())) {
                xmlHash.setTextContent(actualHash);
                try {
                    this.application.setApplication(this.getFormUtilityService().docToString(xmlHash.getOwnerDocument()));
                    return true;
                }
                catch (TransformerException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    @PostRemove
    public void removeData() {
        if (this.getFileDataId() != null) {
            this.getKcAttachmentDataDao().removeData(this.getFileDataId());
        }
    }

    public DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = KcServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public KcAttachmentService getKcAttachmentService() {
        if (this.kcAttachmentService == null) {
            this.kcAttachmentService = KcServiceLocator.getService(KcAttachmentService.class);
        }
        return this.kcAttachmentService;
    }

    public void setKcAttachmentService(KcAttachmentService kcAttachmentService) {
        this.kcAttachmentService = kcAttachmentService;
    }

    public KcAttachmentDataDao getKcAttachmentDataDao() {
        if (this.kcAttachmentDataDao == null) {
            this.kcAttachmentDataDao = KcServiceLocator.getService(KcAttachmentDataDao.class);
        }
        return this.kcAttachmentDataDao;
    }

    public void setKcAttachmentDataDao(KcAttachmentDataDao kcAttachmentDataDao) {
        this.kcAttachmentDataDao = kcAttachmentDataDao;
    }

    public GrantApplicationHashService getGrantApplicationHashService() {
        if (this.grantApplicationHashService == null) {
            this.grantApplicationHashService = KcServiceLocator.getService(GrantApplicationHashService.class);
        }
        return this.grantApplicationHashService;
    }

    public void setGrantApplicationHashService(GrantApplicationHashService grantApplicationHashService) {
        this.grantApplicationHashService = grantApplicationHashService;
    }

    public FormUtilityService getFormUtilityService() {
        if (this.formUtilityService == null) {
            this.formUtilityService = KcServiceLocator.getService(FormUtilityService.class);
        }
        return this.formUtilityService;
    }

    public void setFormUtilityService(FormUtilityService formUtilityService) {
        this.formUtilityService = formUtilityService;
    }
}

