/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.common.service.impl;

import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.ArrayOfresult;
import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.ObjectFactory;
import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.RPSMSService;
import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.RPSMSWS;
import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.Search;
import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.Searches;
import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.Searchrequest;
import com.visualcompliance.eim.wcf.rpsmanifoldservice._2010._12.Searchresult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.excon.common.service.RPSRetrievalService;
import org.kuali.kra.excon.project.ExconProjectRPSEntity;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class VisualComplianceRPSRetrievalServiceImpl
implements RPSRetrievalService {
    private static final Logger LOG = LogManager.getLogger(VisualComplianceRPSRetrievalServiceImpl.class);
    protected String serviceName;
    protected ConfigurationService configurationService;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public String retrieveRpsResults(ExconProjectRPSEntity rpsEntity) {
        String secno = this.getConfigurationService().getPropertyValueAsString("excon.visualcompliance.secno");
        String password = this.getConfigurationService().getPropertyValueAsString("excon.visualcompliance.password");
        if (StringUtils.isEmpty((CharSequence)secno) || StringUtils.isEmpty((CharSequence)password)) {
            return "Must set security id and password for Visual Compliance web service.";
        }
        String modes = this.getConfigurationService().getPropertyValueAsString("excon.visualcompliance.modes");
        ObjectFactory objectFactory = new ObjectFactory();
        RPSMSService rpsService = new RPSMSWS().getBasicHttpBindingRPSMSService();
        Searchrequest rpsSearchRequest = objectFactory.createSearchrequest();
        Searches rpsSearches = objectFactory.createSearches();
        Search rpsSearch = objectFactory.createSearch();
        String searchName = rpsEntity.getConcatNames();
        rpsSearch.setSname(objectFactory.createSearchSname(searchName));
        rpsSearch.setScompany(objectFactory.createSearchScompany(rpsEntity.getCompanyName()));
        rpsSearch.setSaddress(objectFactory.createSearchSaddress(rpsEntity.getStreetAddress()));
        rpsSearch.setScountry(objectFactory.createSearchScountry(rpsEntity.getShortCountryCode()));
        rpsSearches.getSearch().add(rpsSearch);
        rpsSearchRequest.setSearches(objectFactory.createSearchrequestSearches(rpsSearches));
        rpsSearchRequest.setSsecno(objectFactory.createSearchrequestSsecno(secno));
        rpsSearchRequest.setSpassword(objectFactory.createSearchrequestSpassword(password));
        rpsSearchRequest.setSmodes(objectFactory.createSearchrequestSmodes(modes));
        rpsSearchRequest.setSrpsgroupbypass(objectFactory.createSearchrequestSrpsgroupbypass(""));
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Searchrequest.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal(objectFactory.createSearchrequest(rpsSearchRequest), (OutputStream)System.err);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        Searchresult rpsResult = null;
        String resultString = "";
        try {
            rpsResult = rpsService.manifoldSearchPOST(rpsSearchRequest);
        }
        catch (Exception e) {
            LOG.error(e.getMessage() + " [" + rpsSearchRequest + "]", (Throwable)e);
        }
        if (rpsResult != null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Searchresult.class});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                jaxbMarshaller.marshal(objectFactory.createSearchresult(rpsResult), (OutputStream)baos);
                resultString = baos.toString();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return resultString;
    }

    @Override
    public Search getRpsResults(String rpsResultsPayload) {
        Search rpsSearch = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Searchresult.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StreamSource source = new StreamSource(new ByteArrayInputStream(rpsResultsPayload.getBytes()));
            JAXBElement root = jaxbUnmarshaller.unmarshal((Source)source, Searchresult.class);
            rpsSearch = ((Searches)((Searchresult)root.getValue()).getSearches().getValue()).getSearch().get(0);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return rpsSearch;
    }

    @Override
    public int getNumMatches(String rpsResultsPayload) {
        Search results = this.getRpsResults(rpsResultsPayload);
        if (results != null && results.getResults().getValue() != null) {
            return ((ArrayOfresult)results.getResults().getValue()).getResult().size();
        }
        return 0;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

