/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.query;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.query.operator.GreaterThan;
import org.kuali.coeus.common.budget.framework.query.operator.LesserThan;
import org.kuali.coeus.common.budget.framework.query.operator.Operator;
import org.kuali.coeus.common.budget.framework.query.operator.RelationalOperator;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

public final class QueryList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3215265492607686197L;
    private static final Logger LOG = LogManager.getLogger(QueryList.class);
    private ArrayList<E> backingList;

    public QueryList() {
        this.backingList = new ArrayList();
    }

    public QueryList(Collection<E> dataList) {
        this.backingList = new ArrayList<E>(dataList);
    }

    public boolean sort(String fieldName) {
        return this.sort(fieldName, true);
    }

    public boolean sort(String fieldName, boolean ascending) {
        return this.sort(fieldName, ascending, false);
    }

    public boolean sort(String fieldName, boolean ascending, boolean ignoreCase) {
        int compareValue = 0;
        Field field = null;
        Method method = null;
        if (this.size() == 0) {
            return false;
        }
        Class<?> dataClass = this.get(0).getClass();
        String methodName = null;
        try {
            field = dataClass.getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                throw new NoSuchFieldException();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                methodName = "get" + ("" + fieldName.charAt(0)).toUpperCase() + fieldName.substring(1);
                method = dataClass.getMethod(methodName, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOG.error(noSuchMethodException.getMessage(), (Throwable)noSuchMethodException);
                return false;
            }
        }
        for (int index = 0; index < this.size() - 1; ++index) {
            for (int nextIndex = index + 1; nextIndex < this.size(); ++nextIndex) {
                E temp;
                E current = this.get(index);
                E next = this.get(nextIndex);
                try {
                    Comparable otherObj;
                    Comparable thisObj;
                    if (field != null && field.isAccessible()) {
                        thisObj = (Comparable)field.get(current);
                        otherObj = (Comparable)field.get(next);
                        compareValue = thisObj == null ? -1 : (otherObj == null ? 1 : (thisObj instanceof String && ignoreCase ? ((String)((Object)thisObj)).compareToIgnoreCase((String)((Object)otherObj)) : thisObj.compareTo(otherObj)));
                    } else {
                        thisObj = null;
                        otherObj = null;
                        if (methodName != null) {
                            Method thisObjMethod = current.getClass().getMethod(methodName, null);
                            Method otherObjMethod = next.getClass().getMethod(methodName, null);
                            thisObj = (Comparable)thisObjMethod.invoke(current, null);
                            otherObj = (Comparable)otherObjMethod.invoke(next, null);
                        } else {
                            thisObj = (Comparable)method.invoke(current, null);
                            otherObj = (Comparable)method.invoke(next, null);
                        }
                        compareValue = thisObj == null ? -1 : (otherObj == null ? 1 : (thisObj instanceof String && ignoreCase ? ((String)((Object)thisObj)).compareToIgnoreCase((String)((Object)otherObj)) : thisObj.compareTo(otherObj)));
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOG.warn(illegalAccessException.getMessage());
                    return false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    LOG.warn(invocationTargetException.getMessage(), (Throwable)invocationTargetException);
                    return false;
                }
                catch (SecurityException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                    return false;
                }
                catch (NoSuchMethodException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                    return false;
                }
                if (ascending && compareValue > 0) {
                    temp = this.get(index);
                    this.set(index, this.get(nextIndex));
                    this.set(nextIndex, temp);
                    continue;
                }
                if (ascending || compareValue >= 0) continue;
                temp = this.get(index);
                this.set(index, this.get(nextIndex));
                this.set(nextIndex, temp);
            }
        }
        return true;
    }

    public boolean sort(String[] fieldNames, boolean[] ascending) {
        for (int index = 1; index < this.size(); ++index) {
            int nextIndex;
            E current = this.get(index);
            Operator[] relOperator = this.getRelationalOperators(fieldNames, current, ascending);
            Operator[] eqOperator = this.getEqualsOperators(fieldNames, current);
            for (nextIndex = index; nextIndex > 0; --nextIndex) {
                E other = this.get(nextIndex - 1);
                boolean swap = false;
                for (int operatorIndex = 0; operatorIndex < relOperator.length; ++operatorIndex) {
                    Operator operator = relOperator[operatorIndex];
                    if (operator.getResult(other)) {
                        swap = true;
                        break;
                    }
                    operator = eqOperator[operatorIndex];
                    if (!operator.getResult(other)) break;
                }
                if (!swap) break;
                this.set(nextIndex, this.get(nextIndex - 1));
            }
            this.set(nextIndex, current);
        }
        return true;
    }

    private Operator[] getRelationalOperators(String[] field, Object baseBean, boolean[] ascending) {
        Operator[] relationalOperator = new RelationalOperator[field.length];
        boolean isascending = !ascending[0];
        for (int index = 0; index < field.length; ++index) {
            if (ascending.length > 1) {
                boolean bl = isascending = !ascending[index];
            }
            if (!isascending) {
                GreaterThan gt = new GreaterThan(field[index], (Comparable)this.getFieldValue(field[index], baseBean));
                relationalOperator[index] = gt;
                continue;
            }
            if (!isascending) continue;
            LesserThan lt = new LesserThan(field[index], (Comparable)this.getFieldValue(field[index], baseBean));
            relationalOperator[index] = lt;
        }
        return relationalOperator;
    }

    private Operator[] getEqualsOperators(String[] field, Object baseBean) {
        Operator[] equals = new Equals[field.length];
        for (int index = 0; index < equals.length; ++index) {
            Equals eq = new Equals(field[index], (Comparable)this.getFieldValue(field[index], baseBean));
            equals[index] = eq;
        }
        return equals;
    }

    public QueryList<E> filter(Operator operator) {
        QueryList<Object> filterResult = new QueryList<Object>();
        if (this.size() > 0) {
            E baseBean = null;
            for (int index = 0; index < this.size(); ++index) {
                baseBean = this.get(index);
                if (!operator.getResult(baseBean)) continue;
                filterResult.add(baseBean);
            }
        }
        return filterResult;
    }

    public double sum(String fieldName) {
        return this.sum(fieldName, null, null);
    }

    public ScaleTwoDecimal sumObjects(String fieldName) {
        return new ScaleTwoDecimal(this.sum(fieldName, null, null));
    }

    public double sum(String fieldName, Class arg, Object value) {
        if (this.size() == 0) {
            return 0.0;
        }
        Field field = null;
        Method method = null;
        Class<?> dataClass = this.get(0).getClass();
        double sum = 0.0;
        try {
            field = dataClass.getDeclaredField(fieldName);
            Class<?> fieldClass = field.getType();
            if (!(fieldClass.equals(Integer.class) || fieldClass.equals(Long.class) || fieldClass.equals(Double.class) || fieldClass.equals(Float.class) || fieldClass.equals(BigDecimal.class) || fieldClass.equals(BigInteger.class) || fieldClass.equals(ScaleTwoDecimal.class) || fieldClass.equals(ScaleTwoDecimal.class) || fieldClass.equals(Integer.TYPE) || fieldClass.equals(Long.TYPE) || fieldClass.equals(Float.TYPE) || fieldClass.equals(Double.TYPE))) {
                throw new UnsupportedOperationException("Data Type not numeric");
            }
            if (!field.isAccessible()) {
                throw new NoSuchFieldException();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                String methodName = "get" + ("" + fieldName.charAt(0)).toUpperCase() + fieldName.substring(1);
                if (arg != null) {
                    Class[] args = new Class[]{arg};
                    method = dataClass.getMethod(methodName, args);
                } else {
                    method = dataClass.getMethod(methodName, null);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOG.error(noSuchMethodException.getMessage(), (Throwable)noSuchMethodException);
            }
        }
        for (int index = 0; index < this.size(); ++index) {
            E current = this.get(index);
            try {
                Comparable dataValue;
                if (field != null && field.isAccessible()) {
                    sum += Double.parseDouble(((Comparable)field.get(current)).toString());
                    continue;
                }
                if (value != null) {
                    Object[] values = new Object[]{value};
                    dataValue = (Comparable)method.invoke(current, values);
                } else {
                    dataValue = (Comparable)method.invoke(current, null);
                }
                if (dataValue == null) continue;
                sum += Double.parseDouble(dataValue.toString());
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                LOG.error(illegalAccessException.getMessage(), (Throwable)illegalAccessException);
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.error(invocationTargetException.getMessage(), (Throwable)invocationTargetException);
            }
        }
        return sum;
    }

    public double sum(String fieldName, Operator operator) {
        return this.filter(operator).sum(fieldName);
    }

    public ScaleTwoDecimal sumObjects(String fieldName, Operator operator) {
        return this.filter(operator).sumObjects(fieldName);
    }

    private Object getFieldValue(String fieldName, Object baseBean) {
        Field field = null;
        Method method = null;
        Class<?> dataClass = baseBean.getClass();
        Object value = null;
        try {
            field = dataClass.getDeclaredField(fieldName);
            if (!field.isAccessible()) {
                throw new NoSuchFieldException();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                String methodName = "get" + ("" + fieldName.charAt(0)).toUpperCase() + fieldName.substring(1);
                method = dataClass.getMethod(methodName, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOG.error(noSuchMethodException.getMessage(), (Throwable)noSuchMethodException);
            }
        }
        try {
            value = field != null && field.isAccessible() ? field.get(baseBean) : method.invoke(baseBean, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error(illegalAccessException.getMessage(), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.error(invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
        return value;
    }

    public QueryList<E> clone() {
        QueryList ql;
        try {
            ql = (QueryList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("not Cloneable", e);
        }
        ArrayList bl = (ArrayList)this.backingList.clone();
        ql.backingList = new ArrayList(bl);
        return ql;
    }

    @Override
    public boolean add(E o) {
        return this.backingList.add(o);
    }

    @Override
    public void add(int index, E element) {
        this.backingList.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.backingList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.backingList.addAll(index, c);
    }

    @Override
    public void clear() {
        this.backingList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingList.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.backingList.equals(o);
    }

    @Override
    public E get(int index) {
        return this.backingList.get(index);
    }

    @Override
    public int hashCode() {
        return this.backingList.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.backingList.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.backingList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingList.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.backingList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.backingList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.backingList.listIterator(index);
    }

    @Override
    public E remove(int index) {
        return this.backingList.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.backingList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.backingList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.backingList.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return this.backingList.set(index, element);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.backingList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.backingList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backingList.toArray(a);
    }

    public String toString() {
        return this.backingList.toString();
    }
}

