/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import java.util.Calendar;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.person.KcPersonContract;
import org.kuali.coeus.common.api.person.KcPersonRepositoryService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.instprop.api.admin.ProposalAdminDetailsContract;
import org.kuali.coeus.instprop.api.admin.ProposalAdminDetailsService;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.impl.s2s.map.Address;
import org.kuali.coeus.propdev.impl.s2s.map.KeyPerson;
import org.kuali.coeus.propdev.impl.s2s.map.MappingConstants;
import org.kuali.coeus.propdev.impl.s2s.map.PersonMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.PersonName;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="personMappingService")
public class PersonMappingServiceImpl
implements PersonMappingService {
    private static final String DUMMY_NSF_ID = "000000000";
    private static final String US = "US";
    @Autowired
    @Qualifier(value="proposalAdminDetailsService")
    private ProposalAdminDetailsService proposalAdminDetailsService;
    @Autowired
    @Qualifier(value="kcPersonRepositoryService")
    private KcPersonRepositoryService kcPersonRepositoryService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="countryService")
    private CountryService countryService;

    @Override
    public Optional<KeyPerson> fromRolodex(Integer rolodexId) {
        return Optional.ofNullable(rolodexId).map(arg_0 -> ((RolodexService)this.rolodexService).getRolodex(arg_0)).map(this::fromRolodex);
    }

    @Override
    public KeyPerson getAor(DevelopmentProposalContract proposal) {
        ProposalAdminDetailsContract proposalAdminDetails;
        KeyPerson person = this.isOverrideWithSignedBy(proposal) ? this.overridePerson(proposal) : (this.isProposalAdminWithSignedBy(proposalAdminDetails = (ProposalAdminDetailsContract)this.getProposalAdminDetailsService().findProposalAdminDetailsByPropDevNumber(proposal.getProposalNumber()).stream().findFirst().orElse(null)) ? this.submittedPerson(proposalAdminDetails) : this.notSubmittedPerson(proposal));
        if (this.isOverrideWithSubmittedDate(proposal)) {
            person.setSubmittedDate(proposal.getS2sOverride().getSubmittedDate());
        }
        return person;
    }

    private boolean isOverrideWithSignedBy(DevelopmentProposalContract proposal) {
        return proposal.getS2sOverride() != null && proposal.getS2sOverride().isActive() && StringUtils.isNotBlank((CharSequence)proposal.getS2sOverride().getSignedBy()) && proposal.getS2sOverride().getSignedByPerson() != null;
    }

    private boolean isOverrideWithSubmittedDate(DevelopmentProposalContract proposal) {
        return proposal.getS2sOverride() != null && proposal.getS2sOverride().isActive() && proposal.getS2sOverride().getSubmittedDate() != null;
    }

    private boolean isProposalAdminWithSignedBy(ProposalAdminDetailsContract proposalAdminDetails) {
        return proposalAdminDetails != null && StringUtils.isNotBlank((CharSequence)proposalAdminDetails.getSignedBy());
    }

    private KeyPerson overridePerson(DevelopmentProposalContract proposal) {
        return this.fromKcPerson(proposal.getS2sOverride().getSignedByPerson());
    }

    private KeyPerson submittedPerson(ProposalAdminDetailsContract proposalAdminDetails) {
        return this.fromKcPerson(this.getKcPersonRepositoryService().findKcPersonByUserName(proposalAdminDetails.getSignedBy()));
    }

    private KeyPerson notSubmittedPerson(DevelopmentProposalContract proposal) {
        return this.fromRolodex(proposal.getApplicantOrganization().getRolodex());
    }

    private KeyPerson fromKcPerson(KcPersonContract kcPerson) {
        KeyPerson person = new KeyPerson();
        person.setName(this.toName(kcPerson.getFirstName(), kcPerson.getMiddleName(), kcPerson.getLastName()));
        person.setAddress(this.toAddress((Addressable)kcPerson));
        person.setSignature(kcPerson.getFullName());
        person.setTitle(kcPerson.getPrimaryTitle());
        person.setNsfId(kcPerson.getNsfId());
        person.setSubmittedDate(Calendar.getInstance().getTime());
        return person;
    }

    private KeyPerson fromRolodex(RolodexContract rolodex) {
        KeyPerson person = new KeyPerson();
        person.setName(this.toName(rolodex.getFirstName(), rolodex.getMiddleName(), rolodex.getLastName()));
        person.setAddress(this.toAddress((Addressable)rolodex));
        person.setSignature(rolodex.getFullName());
        person.setTitle(rolodex.getTitle());
        person.setNsfId(DUMMY_NSF_ID);
        person.setSubmittedDate(Calendar.getInstance().getTime());
        return person;
    }

    private PersonName toName(String first, String middle, String last) {
        PersonName name = new PersonName();
        name.setFirst(first);
        name.setMiddle(middle);
        name.setLast(last);
        return name;
    }

    private Address toAddress(Addressable addressable) {
        Address address = new Address();
        address.setStreet1(addressable.getAddressLine1());
        address.setStreet2(addressable.getAddressLine2());
        address.setCity(addressable.getCity());
        address.setCounty(addressable.getCounty());
        address.setZipPostalCode(addressable.getPostalCode());
        Optional<Country> maybeCountry = Optional.ofNullable(addressable.getCountryCode()).filter(StringUtils::isNotBlank).map(arg_0 -> ((CountryService)this.countryService).getCountryByAlternateCode(arg_0));
        maybeCountry.map(country -> MappingConstants.Country.valueOf(country.getAlternateCode())).ifPresent(country -> {
            address.setCountryV2(country.getDisplayV2());
            address.setCountryV3(country.getDisplayV3());
        });
        if (StringUtils.isNotBlank((CharSequence)addressable.getState())) {
            maybeCountry.filter(country -> US.equals(country.getCode())).map(state -> MappingConstants.State.valueOf(addressable.getState())).ifPresentOrElse(state -> {
                address.setStateV2(state.getDisplayV2());
                address.setStateV3(state.getDisplayV3());
            }, () -> address.setProvince(addressable.getState()));
        }
        return address;
    }

    public ProposalAdminDetailsService getProposalAdminDetailsService() {
        return this.proposalAdminDetailsService;
    }

    public void setProposalAdminDetailsService(ProposalAdminDetailsService proposalAdminDetailsService) {
        this.proposalAdminDetailsService = proposalAdminDetailsService;
    }

    public KcPersonRepositoryService getKcPersonRepositoryService() {
        return this.kcPersonRepositoryService;
    }

    public void setKcPersonRepositoryService(KcPersonRepositoryService kcPersonRepositoryService) {
        this.kcPersonRepositoryService = kcPersonRepositoryService;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public CountryService getCountryService() {
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }
}

