/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.workflow;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.SimpleBooleanSplitNodeAware;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.SplitNode;
import org.kuali.rice.kew.engine.node.SplitResult;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class SimpleBooleanSplitNode
implements SplitNode {
    private static Logger LOG = LogManager.getLogger(SimpleBooleanSplitNode.class);

    public SplitResult process(RouteContext context, RouteHelper helper) throws Exception {
        Document document;
        String documentID = context.getDocument().getDocumentId();
        String routeNodeName = context.getNodeInstance().getRouteNode().getRouteNodeName();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Entering routeNode:%s for documentId:%s", routeNodeName, documentID));
        }
        if ((document = KcServiceLocator.getService(DocumentService.class).getByDocumentHeaderIdSessionless(documentID)) instanceof SimpleBooleanSplitNodeAware) {
            boolean ret = ((SimpleBooleanSplitNodeAware)document).answerSplitNodeQuestion(routeNodeName);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("answerSplitNodeQuestion returned:%s", ret));
            }
            return this.booleanToSplitResult(ret);
        }
        throw new UnsupportedOperationException("Document was not instance of:" + document.getClass().getName() + ", not supported by SimpleBooleanSplitNode.");
    }

    protected SplitResult booleanToSplitResult(boolean b) {
        ArrayList<String> branches = new ArrayList<String>();
        String branchName = b ? "True" : "False";
        branches.add(branchName);
        return new SplitResult(branches);
    }
}

