/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardSponsorContactAuditRule
implements DocumentAuditRule {
    private static final String AWARD_SPONSOR_CONTACT_LIST_ERROR_KEY = "document.awardList[0].sponsorContact.auditErrors";
    private static final String ERROR_AWARD_NO_SPONSOR_CONTACTS = "error.awardSponsorContact.none";
    private static final String ERROR_INVALID_COUNTRY_CODE = "error.invalid.countryCode";
    private List<AuditError> auditErrors = new ArrayList<AuditError>();

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        AwardDocument awardDocument = (AwardDocument)document;
        this.auditErrors = new ArrayList<AuditError>();
        valid &= this.checkForAtLeastOneSponsorContact(awardDocument.getAward().getSponsorContacts());
        this.reportAndCreateAuditCluster();
        return valid &= this.checkForValidCountryCode(awardDocument.getAward().getSponsorContacts());
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            AuditCluster existingErrors = (AuditCluster)GlobalVariables.getAuditErrorMap().get("contactsAuditErrors");
            if (existingErrors == null) {
                GlobalVariables.getAuditErrorMap().put("contactsAuditErrors", new AuditCluster("Contacts", this.auditErrors, "Error"));
            } else {
                existingErrors.getAuditErrorList().addAll(this.auditErrors);
            }
        }
    }

    protected boolean checkForAtLeastOneSponsorContact(List<AwardSponsorContact> sponsorContacts) {
        if (sponsorContacts.isEmpty()) {
            this.auditErrors.add(new AuditError(AWARD_SPONSOR_CONTACT_LIST_ERROR_KEY, ERROR_AWARD_NO_SPONSOR_CONTACTS, "contacts.Contacts"));
            return false;
        }
        return true;
    }

    protected boolean checkForValidCountryCode(List<AwardSponsorContact> sponsorContacts) {
        if (sponsorContacts.isEmpty()) {
            return true;
        }
        for (AwardSponsorContact contact : sponsorContacts) {
            if (contact.getRolodex() == null || contact.getRolodex().getCountryCode() != null) continue;
            this.auditErrors.add(new AuditError(AWARD_SPONSOR_CONTACT_LIST_ERROR_KEY, ERROR_INVALID_COUNTRY_CODE, "contacts.Contacts"));
            return false;
        }
        return true;
    }
}

