/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class TestGroupNamespaceURIFilter
extends XMLFilterImpl {
    public static final String GROUP_URI = "http://rice.kuali.org/xsd/kim/group";
    private Map<String, String> elementTransformationMap;
    private List<String> elementAttributeTransformationList;
    private List<String> groupXmlStack = new ArrayList<String>();

    public TestGroupNamespaceURIFilter() {
        this.setElementTransformationMap();
        this.setElementAttributeTransformationList();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.groupXmlStack.isEmpty()) {
            this.groupXmlStack.add(localName);
        } else {
            this.groupXmlStack.add(this.groupXmlStack.get(this.groupXmlStack.size() - 1) + "." + localName);
        }
        if (localName.equals("data") || localName.equals("groups")) {
            return;
        }
        if (this.elementTransformationMap.containsKey(this.groupXmlStack.get(this.groupXmlStack.size() - 1))) {
            String targetLocalName;
            String targetQualifiedName = targetLocalName = this.elementTransformationMap.get(this.groupXmlStack.get(this.groupXmlStack.size() - 1));
            super.startElement(GROUP_URI, targetLocalName, targetQualifiedName, this.getTransformedAttributes(this.groupXmlStack.get(this.groupXmlStack.size() - 1), atts));
        } else {
            super.startElement(GROUP_URI, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String topStackElement = this.groupXmlStack.get(this.groupXmlStack.size() - 1);
        if (localName.equals("data") || localName.equals("groups")) {
            if (!this.groupXmlStack.isEmpty()) {
                this.groupXmlStack.remove(topStackElement);
            }
            return;
        }
        if (this.elementTransformationMap.containsKey(topStackElement)) {
            String targetLocalName;
            String targetQualifiedName = targetLocalName = this.elementTransformationMap.get(topStackElement);
            super.endElement(GROUP_URI, targetLocalName, targetQualifiedName);
        } else {
            super.endElement(GROUP_URI, localName, qName);
        }
        if (!this.groupXmlStack.isEmpty()) {
            this.groupXmlStack.remove(topStackElement);
        }
    }

    private void setElementTransformationMap() {
        HashMap<String, String> elementTransformationMap = new HashMap<String, String>();
        elementTransformationMap.put("data.groups.group", "group");
        elementTransformationMap.put("data.groups.group.name", "groupName");
        elementTransformationMap.put("data.groups.group.description", "groupDescription");
        elementTransformationMap.put("data.groups.group.namespace", "namespaceCode");
        this.elementTransformationMap = elementTransformationMap;
    }

    private void setElementAttributeTransformationList() {
        ArrayList<String> elementAttributeTransformationList = new ArrayList<String>();
        this.elementAttributeTransformationList = elementAttributeTransformationList;
    }

    private Attributes getTransformedAttributes(String stackRepresentedElement, Attributes attributes) {
        if (this.elementAttributeTransformationList.contains(stackRepresentedElement)) {
            return new AttributesImpl();
        }
        return new AttributesImpl();
    }
}

