/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.TestConstructor;

public abstract class TestConstructorUtils {
    private static final Log logger = LogFactory.getLog(TestConstructorUtils.class);

    private TestConstructorUtils() {
    }

    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass) {
        return executable instanceof Constructor && TestConstructorUtils.isAutowirableConstructor((Constructor)executable, testClass);
    }

    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass) {
        TestConstructor.AutowireMode autowireMode;
        block6: {
            if (AnnotatedElementUtils.hasAnnotation(constructor, Autowired.class)) {
                return true;
            }
            autowireMode = null;
            TestConstructor testConstructor = (TestConstructor)AnnotatedElementUtils.findMergedAnnotation(testClass, TestConstructor.class);
            if (testConstructor != null) {
                autowireMode = testConstructor.autowireMode();
            } else {
                String value = SpringProperties.getProperty((String)"spring.test.constructor.autowire.mode");
                if (value != null) {
                    try {
                        autowireMode = TestConstructor.AutowireMode.valueOf(value.trim().toUpperCase());
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block6;
                        logger.debug((Object)String.format("Failed to parse autowire mode '%s' for property '%s': %s", value, "spring.test.constructor.autowire.mode", ex.getMessage()));
                    }
                }
            }
        }
        return autowireMode == TestConstructor.AutowireMode.ALL;
    }
}

