--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2020 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

-- Narrative type cleanup.  These are due to some problems with existing narrative type duplicates
UPDATE NARRATIVE
SET NARRATIVE_TYPE_CODE = (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RRSF424_Cover_Letter' AND UPDATE_USER = 'admin')
WHERE NARRATIVE_TYPE_CODE = (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RRSF424_Cover_Letter' AND UPDATE_USER != 'admin');

UPDATE VALID_NARR_FORMS
SET NARRATIVE_TYPE_CODE = (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RRSF424_Cover_Letter' AND UPDATE_USER = 'admin')
WHERE NARRATIVE_TYPE_CODE = (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RRSF424_Cover_Letter' AND UPDATE_USER != 'admin');

DELETE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RRSF424_Cover_Letter' AND UPDATE_USER != 'admin';

UPDATE NARRATIVE
SET NARRATIVE_TYPE_CODE = (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Res_Strategy' AND UPDATE_USER = 'admin')
WHERE NARRATIVE_TYPE_CODE = (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Res_Strategy' AND UPDATE_USER != 'admin');

UPDATE VALID_NARR_FORMS
SET NARRATIVE_TYPE_CODE = (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Res_Strategy' AND UPDATE_USER = 'admin')
WHERE NARRATIVE_TYPE_CODE = (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Res_Strategy' AND UPDATE_USER != 'admin');

DELETE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'PHS_Career_Res_Strategy' AND UPDATE_USER != 'admin';

-- New stuff
INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'RR_SF424_3_0-V3.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RRSF424_Cover_Letter'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'RR_SF424_3_0-V3.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'Pre-Application'), 'N', 'admin', NOW(), UUID());

INSERT INTO SEQ_VALID_NARR_FORMS_ID VALUES (null);
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT MAX(ID) FROM SEQ_VALID_NARR_FORMS_ID), 'RR_SF424_3_0-V3.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'RRSF424_SFLLL_OtherExplanatory'), 'N', 'admin', NOW(), UUID());


INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/OrganizationInfo/DUNSID', 'The selected organization does not have DUNS number.', 'proposal.Organization/Location', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/PDPIContactInfo', 'Contact information missing for PD/PI, please make sure a Principal Investigator has been added.', 'keyPersonnel', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/PDPIContactInfo/Address', 'The country code for the PD/PI address is invalid.', 'keyPersonnel', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/PDPIContactInfo/Address/Street1', 'The PI address is invalid. Use the proposal person window to add a street address.', 'keyPersonnel', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/PDPIContactInfo/Address/Country', 'The PI country code is invalid. Use the proposal person window to fix this.', 'keyPersonnel', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/PDPIContactInfo/Address/City', 'The PI address is missing a city. Please use the Proposal Person window to fix this.', 'keyPersonnel', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ActivityTitle', 'Please enter the program title.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo/Address/Country', 'The country code for the AOR is not valid for Grants.gov.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo/Title', 'The AOR must have a title.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ProjectTitle', 'You are missing a project title.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/EstimatedProjectFunding/TotalEstimatedAmount', 'You are missing total budget amounts.', 'budgetVersions', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/EstimatedProjectFunding/TotalfedNonfedrequested', 'You are missing total budget amounts.', 'budgetVersions', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/EstimatedProjectFunding/EstimatedProgramIncome', 'You are missing total budget amounts.', 'budgetVersions', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/ContactPersonInfo', 'You are missing a contact person for the proposal.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/StateID', 'Selected organization missing state.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/OrganizationInfo/Address/City', 'Selected organization missing city.', 'proposal.Organization/Location', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/OrganizationInfo/Address/County', 'Selected organization missing county.', 'proposal.Organization/Location', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/OrganizationInfo/Address/ZipPostalCode', 'Selected organization missing postal code.', 'proposal.Organization/Location', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/OrganizationInfo/Address', 'Selected organization missing address.', 'proposal.Organization/Location', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/ContactPersonInfo/Name/FirstName', 'First name missing for proposal contact person, please verify the information in the Unit Administrator table.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/ContactPersonInfo/Name/MiddleName', 'Middle name missing for contact person.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/ContactPersonInfo/Name/LastName', 'Last name missing for proposal contact person, please verify the information in the Unit Administrator table.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/ContactPersonInfo/Fax', 'Fax missing for contact person.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/ContactPersonInfo/Email', 'Email address missing for contact person.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantType/ApplicantTypeCode', 'Applicant type missing.', 'proposal.SponsorProgramInformation', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/Location', 'Areas Affected by Project is required, please add this Abstract Type in the Abstracts and Attachments tab.', 'abstractsAttachments', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/EstimatedProjectFunding', 'Estimated Project funding missing.', 'budgetVersions', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo/Address', 'Missing AOR address.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo/Phone', 'Missing AOR phone number.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo/Fax', 'Missing AOR Fax.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo/Email', 'Missing AOR email address.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo/OrganizationName', 'Missing AOR organization name.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo/DepartmentName', 'Missing AOR department name.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo/DivisionName', 'Missing AOR division name.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/AORInfo', 'Missing AOR information.', 'proposal', NOW(), 'admin', 1, UUID());

INSERT INTO SEQ_S2S_ERROR_ID VALUES (null);
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_S2S_ERROR_ID), '/GrantApplication/Forms/RR_SF424_3_0/ApplicantInfo/ContactPersonInfo/Phone', 'Phone number missing for proposal contact person, please verify the information in the Unit Administrator table.', 'grantsGov', NOW(), 'admin', 1, UUID());

UPDATE KRMS_TERM_PARM_T SET VAL = 'RR_SF424-V1.1,RR_SF424_1_2-V1.2,RR_SF424_2_0-V2.0,RR_SF424_Multi_Project_Cover_1_0-V1.0,RR_SF424_3_0-V3.0'
WHERE TERM_PARM_ID = 'KC2004' AND TERM_ID = 'KC2004';

