/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.web;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.core.api.util.RiceUtilities;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.registry.ServiceInfo;
import org.kuali.rice.ksb.messaging.MessageFetcher;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.service.MessageQueueService;
import org.kuali.rice.ksb.messaging.web.KSBAction;
import org.kuali.rice.ksb.messaging.web.MessageQueueForm;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class MessageQueueAction
extends KSBAction {
    @Override
    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return mapping.findForward("report");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        this.save(routeQueueForm);
        ActionMessages messages = new ActionMessages();
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("routequeue.RouteQueueService.saved"));
        this.saveMessages(request, messages);
        return mapping.findForward("report");
    }

    public ActionForward saveAndResubmit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        PersistedMessageBO message = this.save(routeQueueForm);
        KSBServiceLocator.getThreadPool().execute((Runnable)new MessageServiceInvoker(message));
        ActionMessages messages = new ActionMessages();
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("routequeue.RouteQueueService.queued"));
        this.saveMessages(request, messages);
        routeQueueForm.setMessageId(null);
        routeQueueForm.setMessageQueueFromDatabase(null);
        routeQueueForm.setMessageQueueFromForm(null);
        routeQueueForm.setShowEdit("yes");
        routeQueueForm.setMethodToCall("");
        this.establishRequiredState(request, form);
        routeQueueForm.setMessageId(message.getRouteQueueId());
        routeQueueForm.setMessageQueueFromForm(message);
        routeQueueForm.setNewQueueDate(routeQueueForm.getExistingQueueDate());
        routeQueueForm.getMessageQueueFromForm().setPayload(message.getPayload());
        return mapping.findForward("report");
    }

    private PersistedMessageBO save(MessageQueueForm routeQueueForm) {
        Long routeQueueId = routeQueueForm.getMessageQueueFromForm().getRouteQueueId();
        if (routeQueueId == null || routeQueueId <= 0L) {
            throw new IllegalArgumentException("Invalid routeQueueId passed in.  Cannot save");
        }
        PersistedMessageBO existingMessage = KSBServiceLocator.getMessageQueueService().findByRouteQueueId(routeQueueId);
        PersistedMessageBO message = routeQueueForm.getMessageQueueFromForm();
        if (existingMessage == null) {
            throw new RuntimeException("Could locate the existing message, it may have already been processed.");
        }
        existingMessage.setQueuePriority(message.getQueuePriority());
        existingMessage.setIpNumber(message.getIpNumber());
        existingMessage.setLockVerNbr(message.getLockVerNbr());
        existingMessage.setApplicationId(message.getApplicationId());
        existingMessage.setMethodName(message.getMethodName());
        existingMessage.setQueueStatus(message.getQueueStatus());
        existingMessage.setRetryCount(message.getRetryCount());
        existingMessage.setServiceName(message.getServiceName());
        existingMessage.setValue1(message.getValue1());
        existingMessage.setValue2(message.getValue2());
        existingMessage = KSBServiceLocator.getMessageQueueService().save(existingMessage);
        return existingMessage;
    }

    protected PersistedMessageBO quickRequeueMessage(PersistedMessageBO message) {
        message.setQueueStatus("R");
        message.setQueueDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        message.setRetryCount(Integer.valueOf(0));
        return this.getRouteQueueService().save(message);
    }

    public ActionForward quickRequeueMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        if (routeQueueForm.getMessageQueueFromDatabase() == null) {
            throw new IllegalArgumentException("No messageId passed in with the Request.");
        }
        PersistedMessageBO message = routeQueueForm.getMessageQueueFromDatabase();
        message = this.quickRequeueMessage(message);
        KSBServiceLocator.getThreadPool().execute((Runnable)new MessageServiceInvoker(message));
        ActionMessages messages = new ActionMessages();
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("routequeue.RouteQueueService.requeued"));
        this.saveMessages(request, messages);
        routeQueueForm.setMessageQueueFromDatabase(null);
        routeQueueForm.setMessageQueueFromForm(null);
        routeQueueForm.setMessageId(null);
        routeQueueForm.setMethodToCall("");
        this.establishRequiredState(request, form);
        return mapping.findForward("report");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        routeQueueForm.setShowEdit("yes");
        routeQueueForm.setMessageQueueFromForm(routeQueueForm.getMessageQueueFromDatabase());
        routeQueueForm.setNewQueueDate(routeQueueForm.getExistingQueueDate());
        routeQueueForm.getMessageQueueFromForm().setPayload(routeQueueForm.getMessageQueueFromForm().getPayload());
        return mapping.findForward("basic");
    }

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        routeQueueForm.setShowEdit("no");
        routeQueueForm.setMessageQueueFromForm(routeQueueForm.getMessageQueueFromDatabase());
        routeQueueForm.setNewQueueDate(routeQueueForm.getExistingQueueDate());
        routeQueueForm.getMessageQueueFromForm().setPayload(routeQueueForm.getMessageQueueFromDatabase().getPayload());
        return mapping.findForward("payload");
    }

    public ActionForward reset(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        if (routeQueueForm.getShowEdit().equals("yes")) {
            routeQueueForm.setMessageQueueFromForm(routeQueueForm.getMessageQueueFromDatabase());
        }
        return mapping.findForward("basic");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        routeQueueForm.getMessageQueueFromForm().setQueuePriority(null);
        routeQueueForm.getMessageQueueFromForm().setQueueStatus(null);
        routeQueueForm.getMessageQueueFromForm().setQueueDate(null);
        routeQueueForm.getMessageQueueFromForm().setExpirationDate(null);
        routeQueueForm.getMessageQueueFromForm().setRetryCount(null);
        routeQueueForm.getMessageQueueFromForm().setIpNumber(null);
        routeQueueForm.getMessageQueueFromForm().setServiceName(null);
        routeQueueForm.getMessageQueueFromForm().setApplicationId(null);
        routeQueueForm.getMessageQueueFromForm().setMethodName(null);
        routeQueueForm.getMessageQueueFromForm().setPayload(null);
        routeQueueForm.setExistingQueueDate(null);
        routeQueueForm.setNewQueueDate(null);
        return mapping.findForward("basic");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        routeQueueForm.setMessageQueueFromForm(routeQueueForm.getMessageQueueFromDatabase());
        routeQueueForm.setMessageQueueFromDatabase(null);
        this.getRouteQueueService().delete(routeQueueForm.getMessageQueueFromForm());
        ActionMessages messages = new ActionMessages();
        messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("routequeue.RouteQueueService.deleted", (Object)routeQueueForm.getMessageQueueFromForm().getRouteQueueId().toString()));
        this.saveMessages(request, messages);
        routeQueueForm.setMessageId(null);
        this.establishRequiredState(request, form);
        return mapping.findForward("report");
    }

    public ActionForward executeMessageFetcher(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        ActionMessages messages = new ActionMessages();
        if (routeQueueForm.getMaxMessageFetcherMessages() == null || routeQueueForm.getMaxMessageFetcherMessages() <= 0) {
            messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("routequeue.RouteQueueService.invalidMessages", (Object)routeQueueForm.getMaxMessageFetcherMessages()));
        }
        if (!messages.isEmpty()) {
            this.saveMessages(request, messages);
            return mapping.findForward("report");
        }
        new MessageFetcher(routeQueueForm.getMaxMessageFetcherMessages()).run();
        return mapping.findForward("report");
    }

    @Override
    public ActionMessages establishRequiredState(HttpServletRequest request, ActionForm form) throws Exception {
        request.setAttribute("rice_constant", this.getServlet().getServletContext().getAttribute("RiceConstants"));
        request.setAttribute("ksb_constant", this.getServlet().getServletContext().getAttribute("KSBConstants"));
        MessageQueueForm routeQueueForm = (MessageQueueForm)form;
        routeQueueForm.setMyIpAddress(RiceUtilities.getIpNumber());
        routeQueueForm.setMyApplicationId(CoreConfigHelper.getApplicationId());
        routeQueueForm.setMessagePersistence(ConfigContext.getCurrentContextConfig().getProperty("message.persistence"));
        routeQueueForm.setMessageDelivery(ConfigContext.getCurrentContextConfig().getProperty("message.delivery"));
        routeQueueForm.setMessageOff(ConfigContext.getCurrentContextConfig().getProperty("message.off"));
        List services = KsbApiServiceLocator.getServiceRegistry().getAllOnlineServices();
        if (routeQueueForm.getMessageId() != null) {
            PersistedMessageBO rq = this.getRouteQueueService().findByRouteQueueId(routeQueueForm.getMessageId());
            if (rq != null) {
                routeQueueForm.setExistingQueueDate(RiceConstants.getDefaultDateFormat().format(new Date()));
                routeQueueForm.setMessageQueueFromDatabase(rq);
                String serviceName = rq.getServiceName();
                for (ServiceInfo serviceInfo : services) {
                    if (!serviceInfo.getServiceName().toString().equals(serviceName)) continue;
                    routeQueueForm.getIpAddresses().add((KeyValue)new ConcreteKeyValue(serviceInfo.getServerIpAddress(), serviceInfo.getServerIpAddress()));
                }
            } else {
                ActionMessages messages = new ActionMessages();
                messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("messagequeue.RouteQueueService.queuedDocumentNotFound", (Object)routeQueueForm.getMessageId().toString()));
                return messages;
            }
            routeQueueForm.setMessageId(null);
        } else if (!"clear".equalsIgnoreCase(request.getParameter("methodToCall"))) {
            List<PersistedMessageBO> queueEntries = this.findRouteQueues(request, routeQueueForm, routeQueueForm.getMaxRows() + 1);
            if (queueEntries.size() > 0) {
                queueEntries.sort(new Comparator<PersistedMessageBO>(){
                    private Comparator comp = new ComparableComparator();

                    @Override
                    public int compare(PersistedMessageBO object1, PersistedMessageBO object2) {
                        if (object1 == null && object2 == null) {
                            return 0;
                        }
                        if (object1 == null) {
                            return 1;
                        }
                        if (object2 == null) {
                            return -1;
                        }
                        Long id1 = object1.getRouteQueueId();
                        Long id2 = object2.getRouteQueueId();
                        try {
                            return this.comp.compare(id1, id2);
                        }
                        catch (Exception e) {
                            return 0;
                        }
                    }
                });
            }
            routeQueueForm.setMessageQueueRows(queueEntries);
        }
        return null;
    }

    protected List<PersistedMessageBO> findRouteQueues(HttpServletRequest request, MessageQueueForm routeQueueForm, int maxRows) {
        ArrayList<PersistedMessageBO> routeQueues = new ArrayList<PersistedMessageBO>();
        if (StringUtils.isBlank((String)routeQueueForm.getFilterApplied())) {
            routeQueues.addAll(this.getRouteQueueService().findAll(maxRows));
        } else {
            if (!StringUtils.isBlank((String)routeQueueForm.getRouteQueueIdFilter()) && !NumberUtils.isNumber((String)routeQueueForm.getRouteQueueIdFilter())) {
                throw new RuntimeException("Message Id must be a number.");
            }
            HashMap<String, String> criteriaValues = new HashMap<String, String>();
            for (String s : request.getParameterMap().keySet()) {
                String value;
                String key = s;
                if (!key.endsWith("Filter") || !StringUtils.isNotBlank((String)(value = request.getParameter(key)))) continue;
                String trimmedKey = key.substring(0, key.indexOf("Filter"));
                criteriaValues.put(trimmedKey, value);
            }
            routeQueues.addAll(this.getRouteQueueService().findByValues(criteriaValues, maxRows));
        }
        return routeQueues;
    }

    private MessageQueueService getRouteQueueService() {
        return KSBServiceLocator.getMessageQueueService();
    }
}

