/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.coreservice.web.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.api.CoreServiceApiServiceLocator;
import org.kuali.rice.coreservice.api.namespace.Namespace;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class NamespaceValuesFinder
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        ArrayList namespaces = CoreServiceApiServiceLocator.getNamespaceService().findAllNamespaces();
        namespaces = namespaces == null ? new ArrayList(0) : new ArrayList(namespaces);
        Collections.sort(namespaces, NamespaceComparator.INSTANCE);
        ArrayList<KeyValue> labels = new ArrayList<KeyValue>(namespaces.size());
        labels.add((KeyValue)new ConcreteKeyValue("", ""));
        for (Namespace namespace : namespaces) {
            labels.add((KeyValue)new ConcreteKeyValue(namespace.getCode(), namespace.getCode() + " - " + namespace.getName()));
        }
        return labels;
    }

    private static class NamespaceComparator
    implements Comparator<Namespace> {
        public static final Comparator<Namespace> INSTANCE = new NamespaceComparator();

        private NamespaceComparator() {
        }

        @Override
        public int compare(Namespace o1, Namespace o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }
}

