/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Signature;
import javax.servlet.ServletInputStream;

public class SignatureVerifyingInputStream
extends ServletInputStream {
    private byte[] digitalSignature;
    private Signature signature;
    private InputStream wrappedInputStream;

    public SignatureVerifyingInputStream(byte[] digitalSignature, Signature signature, InputStream wrappedInputStream) {
        this.digitalSignature = digitalSignature;
        this.signature = signature;
        this.wrappedInputStream = wrappedInputStream;
    }

    public synchronized int read() throws IOException {
        int data = this.wrappedInputStream.read();
        try {
            if (data == -1) {
                this.verifySignature();
            } else {
                this.signature.update((byte)data);
            }
        }
        catch (GeneralSecurityException e) {
            IOException exception = new IOException("Error processing digital signature.");
            exception.initCause(e);
            throw exception;
        }
        return data;
    }

    protected void verifySignature() throws IOException, GeneralSecurityException {
        boolean verifies = this.signature.verify(this.digitalSignature);
        if (!verifies) {
            throw new IOException("The digital signature could not be successfully verified!");
        }
    }
}

