/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.action;

import javax.xml.namespace.QName;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.action.RolePokerQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

final class RolePokerQueueAsyncCapableImpl
implements RolePokerQueue {
    private final AsyncCapableService asyncCapableService;
    private final RolePokerQueue rolePokerQueue;
    private final QName qname;
    private final String applicationId;

    RolePokerQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, RolePokerQueue rolePokerQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }
        if (rolePokerQueue == null) {
            throw new IllegalArgumentException("rolePokerQueue is null");
        }
        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }
        this.asyncCapableService = asyncCapableService;
        this.rolePokerQueue = rolePokerQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    public void reResolveRole(String documentId, String roleName) throws RiceIllegalArgumentException {
        this.asyncCapableService.executeCall(this.qname, this.applicationId, documentId, roleName, new CallMetadata("reResolveRole", new Class[]{String.class, String.class}, new Object[]{documentId, roleName}), () -> this.rolePokerQueue.reResolveRole(documentId, roleName));
    }

    public void reResolveQualifiedRole(String documentId, String roleName, String qualifiedRoleNameLabel) throws RiceIllegalArgumentException {
        this.asyncCapableService.executeCall(this.qname, this.applicationId, documentId, roleName + "/" + qualifiedRoleNameLabel, new CallMetadata("reResolveQualifiedRole", new Class[]{String.class, String.class, String.class}, new Object[]{documentId, roleName, qualifiedRoleNameLabel}), () -> this.rolePokerQueue.reResolveQualifiedRole(documentId, roleName, qualifiedRoleNameLabel));
    }
}

